/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class SingleByteStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final int singleByteWrites;
    private int state = 0;

    public SingleByteStreamSinkConduit(StreamSinkConduit next, int singleByteWrites) {
        super(next);
        this.singleByteWrites = singleByteWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        if (this.state > this.singleByteWrites) {
            return ((StreamSinkConduit)this.next).write(src);
        }
        if (this.state++ % 2 == 0) {
            return 0;
        }
        if (src.remaining() == 0) {
            return 0;
        }
        int limit = src.limit();
        try {
            src.limit(src.position() + 1);
            int n = ((StreamSinkConduit)this.next).write(src);
            return n;
        }
        finally {
            src.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (this.state > this.singleByteWrites) {
            return ((StreamSinkConduit)this.next).write(srcs, offs, len);
        }
        if (this.state++ % 2 == 0) {
            return 0L;
        }
        Buffer src = null;
        for (int i = offs; i < offs + len; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            src = srcs[i];
            break;
        }
        if (src == null) {
            return 0L;
        }
        int limit = src.limit();
        try {
            ((ByteBuffer)src).limit(src.position() + 1);
            long l = ((StreamSinkConduit)this.next).write((ByteBuffer)src);
            return l;
        }
        finally {
            ((ByteBuffer)src).limit(limit);
        }
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (this.state > this.singleByteWrites) {
            return ((StreamSinkConduit)this.next).transferFrom(src, position, count);
        }
        if (this.state++ % 2 == 0) {
            return 0L;
        }
        return ((StreamSinkConduit)this.next).transferFrom(src, position, count == 0L ? 0L : 1L);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (this.state > this.singleByteWrites) {
            return ((StreamSinkConduit)this.next).transferFrom(source, count, throughBuffer);
        }
        if (this.state++ % 2 == 0) {
            throughBuffer.limit(throughBuffer.position());
            return 0L;
        }
        return ((StreamSinkConduit)this.next).transferFrom(source, count == 0L ? 0L : 1L, throughBuffer);
    }
}

