/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class ChunkedStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    @Deprecated
    public static final AttachmentKey<HeaderMap> TRAILERS = HttpAttachments.RESPONSE_TRAILERS;
    private final HeaderMap responseHeaders;
    private final ConduitListener<? super ChunkedStreamSinkConduit> finishListener;
    private final int config;
    private final Pool<ByteBuffer> bufferPool;
    private static final byte[] LAST_CHUNK = new byte[]{48, 13, 10};
    private static final byte[] CRLF = new byte[]{13, 10};
    private final Attachable attachable;
    private int state;
    private int chunkleft = 0;
    private final ByteBuffer chunkingBuffer = ByteBuffer.allocate(12);
    private final ByteBuffer chunkingSepBuffer;
    private Pooled<ByteBuffer> lastChunkBuffer;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final int FLAG_WRITES_SHUTDOWN = 1;
    private static final int FLAG_NEXT_SHUTDOWN = 4;
    private static final int FLAG_WRITTEN_FIRST_CHUNK = 8;
    private static final int FLAG_FIRST_DATA_WRITTEN = 16;
    private static final int FLAG_FINISHED = 32;
    int written = 0;
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public ChunkedStreamSinkConduit(StreamSinkConduit next, Pool<ByteBuffer> bufferPool, boolean configurable, boolean passClose, HeaderMap responseHeaders, ConduitListener<? super ChunkedStreamSinkConduit> finishListener, Attachable attachable) {
        super(next);
        this.bufferPool = bufferPool;
        this.responseHeaders = responseHeaders;
        this.finishListener = finishListener;
        this.attachable = attachable;
        this.config = (configurable ? 1 : 0) | (passClose ? 2 : 0);
        this.chunkingSepBuffer = ByteBuffer.allocate(2);
        this.chunkingSepBuffer.flip();
    }

    public int write(ByteBuffer src) throws IOException {
        return this.doWrite(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doWrite(ByteBuffer src) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        if (src.remaining() == 0) {
            return 0;
        }
        this.state |= 0x10;
        int oldLimit = src.limit();
        if (this.chunkleft == 0 && !this.chunkingSepBuffer.hasRemaining()) {
            this.chunkingBuffer.clear();
            this.written += src.remaining();
            ChunkedStreamSinkConduit.putIntAsHexString(this.chunkingBuffer, src.remaining());
            this.chunkingBuffer.put(CRLF);
            this.chunkingBuffer.flip();
            this.chunkingSepBuffer.clear();
            this.chunkingSepBuffer.put(CRLF);
            this.chunkingSepBuffer.flip();
            this.state |= 8;
            this.chunkleft = src.remaining();
        } else if (src.remaining() > this.chunkleft) {
            src.limit(this.chunkleft + src.position());
        }
        try {
            int chunkingSize = this.chunkingBuffer.remaining();
            int chunkingSepSize = this.chunkingSepBuffer.remaining();
            if (chunkingSize > 0 || chunkingSepSize > 0 || this.lastChunkBuffer != null) {
                long result;
                ByteBuffer[] buf;
                int originalRemaining = src.remaining();
                if (this.lastChunkBuffer == null) {
                    buf = new ByteBuffer[]{this.chunkingBuffer, src, this.chunkingSepBuffer};
                    result = ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
                } else {
                    buf = new ByteBuffer[]{this.chunkingBuffer, src, (ByteBuffer)this.lastChunkBuffer.getResource()};
                    result = Bits.anyAreSet((int)this.state, (int)2) ? ((StreamSinkConduit)this.next).writeFinal(buf, 0, buf.length) : ((StreamSinkConduit)this.next).write(buf, 0, buf.length);
                    if (!src.hasRemaining()) {
                        this.state |= 1;
                    }
                    if (!((ByteBuffer)this.lastChunkBuffer.getResource()).hasRemaining()) {
                        this.state |= 4;
                        this.lastChunkBuffer.free();
                    }
                }
                int srcWritten = originalRemaining - src.remaining();
                this.chunkleft -= srcWritten;
                if (result < (long)chunkingSize) {
                    int n = 0;
                    return n;
                }
                int n = srcWritten;
                return n;
            }
            int result = ((StreamSinkConduit)this.next).write(src);
            this.chunkleft -= result;
            int n = result;
            return n;
        }
        finally {
            src.limit(oldLimit);
        }
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            return this.write(srcs[i]);
        }
        return 0L;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            this.terminateWrites();
            return 0;
        }
        if (this.lastChunkBuffer == null) {
            this.createLastChunk(true);
        }
        return this.doWrite(src);
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public boolean flush() throws IOException {
        this.state |= 0x10;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            if (Bits.anyAreSet((int)this.state, (int)4)) {
                boolean val = ((StreamSinkConduit)this.next).flush();
                if (val && Bits.allAreClear((int)this.state, (int)32)) {
                    this.invokeFinishListener();
                }
                return val;
            }
            ((StreamSinkConduit)this.next).write((ByteBuffer)this.lastChunkBuffer.getResource());
            if (!((ByteBuffer)this.lastChunkBuffer.getResource()).hasRemaining()) {
                this.lastChunkBuffer.free();
                if (Bits.anyAreSet((int)this.config, (int)2)) {
                    ((StreamSinkConduit)this.next).terminateWrites();
                }
                this.state |= 4;
                boolean val = ((StreamSinkConduit)this.next).flush();
                if (val && Bits.allAreClear((int)this.state, (int)32)) {
                    this.invokeFinishListener();
                }
                return val;
            }
            return false;
        }
        return ((StreamSinkConduit)this.next).flush();
    }

    private void invokeFinishListener() {
        this.state |= 0x20;
        if (this.finishListener != null) {
            this.finishListener.handleEvent(this);
        }
    }

    public void terminateWrites() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        if (this.chunkleft != 0) {
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
        if (!Bits.anyAreSet((int)this.state, (int)16)) {
            this.responseHeaders.put(Headers.CONTENT_LENGTH, "0");
            this.responseHeaders.remove(Headers.TRANSFER_ENCODING);
            this.state |= 5;
            if (Bits.anyAreSet((int)this.state, (int)2)) {
                ((StreamSinkConduit)this.next).terminateWrites();
            }
        } else {
            this.createLastChunk(false);
            this.state |= 1;
        }
    }

    private void createLastChunk(boolean writeFinal) throws UnsupportedEncodingException {
        this.lastChunkBuffer = this.bufferPool.allocate();
        ByteBuffer lastChunkBuffer = (ByteBuffer)this.lastChunkBuffer.getResource();
        if (writeFinal) {
            lastChunkBuffer.put(CRLF);
        } else if (this.chunkingSepBuffer.hasRemaining()) {
            lastChunkBuffer.put(this.chunkingSepBuffer);
        }
        lastChunkBuffer.put(LAST_CHUNK);
        HeaderMap trailers = this.attachable.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
        if (trailers != null && trailers.size() != 0) {
            for (HeaderValues trailer : trailers) {
                for (String val : trailer) {
                    trailer.getHeaderName().appendTo(lastChunkBuffer);
                    lastChunkBuffer.put((byte)58);
                    lastChunkBuffer.put((byte)32);
                    lastChunkBuffer.put(val.getBytes("US-ASCII"));
                    lastChunkBuffer.put(CRLF);
                }
            }
            lastChunkBuffer.put(CRLF);
        } else {
            lastChunkBuffer.put(CRLF);
        }
        lastChunkBuffer.flip();
    }

    public void awaitWritable() throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    private static void putIntAsHexString(ByteBuffer buf, int v) {
        byte int3 = (byte)(v >> 24);
        byte int2 = (byte)(v >> 16);
        byte int1 = (byte)(v >> 8);
        byte int0 = (byte)v;
        boolean nonZeroFound = false;
        if (int3 != 0) {
            buf.put(DIGITS[(0xF0 & int3) >>> 4]).put(DIGITS[0xF & int3]);
            nonZeroFound = true;
        }
        if (nonZeroFound || int2 != 0) {
            buf.put(DIGITS[(0xF0 & int2) >>> 4]).put(DIGITS[0xF & int2]);
            nonZeroFound = true;
        }
        if (nonZeroFound || int1 != 0) {
            buf.put(DIGITS[(0xF0 & int1) >>> 4]).put(DIGITS[0xF & int1]);
        }
        buf.put(DIGITS[(0xF0 & int0) >>> 4]).put(DIGITS[0xF & int0]);
    }
}

