/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol;

import io.undertow.server.HttpHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.util.NetworkUtils;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.protocol.AbstractWebSocketServerTest;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;

public class WebSocket07ServerTest
extends AbstractWebSocketServerTest {
    @Override
    protected WebSocketVersion getVersion() {
        return WebSocketVersion.V07;
    }

    @Test
    public void testPing() throws Exception {
        final AtomicBoolean connected = new AtomicBoolean(false);
        DefaultServer.setRootHandler((HttpHandler)new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = (StreamSourceFrameChannel)channel.receive();
                            if (ws == null) {
                                return;
                            }
                            Assert.assertEquals((Object)WebSocketFrameType.PING, (Object)ws.getType());
                            ByteBuffer buf = ByteBuffer.allocate(32);
                            while (ws.read(buf) != -1) {
                            }
                            buf.flip();
                            StreamSinkFrameChannel sink = channel.send(WebSocketFrameType.PONG, (long)buf.remaining());
                            Assert.assertEquals((Object)WebSocketFrameType.PONG, (Object)sink.getType());
                            while (buf.hasRemaining()) {
                                sink.write(buf);
                            }
                            sink.shutdownWrites();
                            if (!sink.flush()) {
                                sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                sink.resumeWrites();
                            }
                            channel.sendClose();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }));
        FutureResult latch = new FutureResult();
        byte[] payload = "payload".getBytes();
        WebSocketTestClient client = new WebSocketTestClient(this.getVersion(), new URI("ws://" + NetworkUtils.formatPossibleIpv6Address((String)DefaultServer.getHostAddress("default")) + ':' + DefaultServer.getHostPort("default") + '/'));
        client.connect();
        client.send((WebSocketFrame)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)), new FrameChecker(PongWebSocketFrame.class, payload, latch));
        latch.getIoFuture().get();
        client.destroy();
    }
}

