/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.UndertowLogger;
import io.undertow.Version;
import io.undertow.io.Sender;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.proxy.mod_cluster.Balancer;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.NodeConfig;
import io.undertow.server.handlers.proxy.mod_cluster.NodeState;
import io.undertow.server.handlers.proxy.mod_cluster.SessionId;
import io.undertow.server.handlers.proxy.mod_cluster.VHost;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimerTask;
import java.util.UUID;

public class MCMPHandler
implements HttpHandler {
    public static final HttpString CONFIG = new HttpString("CONFIG");
    public static final HttpString ENABLE_APP = new HttpString("ENABLE-APP");
    public static final HttpString DISABLE_APP = new HttpString("DISABLE-APP");
    public static final HttpString STOP_APP = new HttpString("STOP-APP");
    public static final HttpString REMOVE_APP = new HttpString("REMOVE-APP");
    public static final HttpString STATUS = new HttpString("STATUS");
    public static final HttpString DUMP = new HttpString("DUMP");
    public static final HttpString INFO = new HttpString("INFO");
    public static final HttpString PING = new HttpString("PING");
    public static final HttpString GET = new HttpString("GET");
    private static final String VERSION_PROTOCOL = "0.2.1";
    private static final String TYPESYNTAX = "SYNTAX";
    private static final String TYPEMEM = "MEM";
    private static final String SMESPAR = "SYNTAX: Can't parse message";
    private static final String SBALBIG = "SYNTAX: Balancer field too big";
    private static final String SBAFBIG = "SYNTAX: A field is too big";
    private static final String SROUBIG = "SYNTAX: JVMRoute field too big";
    private static final String SROUBAD = "SYNTAX: JVMRoute can't be empty";
    private static final String SDOMBIG = "SYNTAX: LBGroup field too big";
    private static final String SHOSBIG = "SYNTAX: Host field too big";
    private static final String SPORBIG = "SYNTAX: Port field too big";
    private static final String STYPBIG = "SYNTAX: Type field too big";
    private static final String SALIBAD = "SYNTAX: Alias without Context";
    private static final String SCONBAD = "SYNTAX: Context without Alias";
    private static final String SBADFLD = "SYNTAX: Invalid field ";
    private static final String SBADFLD1 = " in message";
    private static final String SMISFLD = "SYNTAX: Mandatory field(s) missing in message";
    private static final String SCMDUNS = "SYNTAX: Command is not supported";
    private static final String SMULALB = "SYNTAX: Only one Alias in APP command";
    private static final String SMULCTB = "SYNTAX: Only one Context in APP command";
    private static final String SREADER = "SYNTAX: %s can't read POST data";
    private static final String MNODEUI = "MEM: Can't update or insert node";
    private static final String MNODERM = "MEM: Old node still exist";
    private static final String MBALAUI = "MEM: Can't update or insert balancer";
    private static final String MNODERD = "MEM: Can't read node";
    private static final String MHOSTRD = "MEM: Can't read host alias";
    private static final String MHOSTUI = "MEM: Can't update or insert host alias";
    private static final String MCONTUI = "MEM: Can't update or insert context";
    static final byte[] CRLF = "\r\n".getBytes();
    static final String MOD_CLUSTER_EXPOSED_VERSION = "mod_cluster_undertow/" + Version.getVersionString();
    boolean checkNonce = true;
    boolean reduceDisplay = false;
    boolean allowCmd = true;
    boolean displaySessionids = true;
    private final String advertiseGroup;
    private final int advertisePort;
    private final String advertiseAddress;
    private MessageDigest md = null;
    private final String scheme;
    private final String securityKey;
    private final String managementHost;
    private final int managementPort;
    private final ModClusterContainer container;
    private final HttpHandler next;
    private MCMAdapterBackgroundProcessor backgroundProcessor;
    private final Random r = new SecureRandom();
    private String nonce = null;

    MCMPHandler(ModClusterContainer container, MCMPHandlerBuilder config, HttpHandler next) {
        this.container = container;
        this.next = next;
        this.advertiseGroup = config.advertiseGroup;
        this.advertisePort = config.advertisePort;
        this.advertiseAddress = config.advertiseAddress;
        this.managementHost = config.managementHost;
        this.scheme = config.scheme;
        this.securityKey = config.securityKey;
        this.managementPort = config.managementPort;
    }

    public void start() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.backgroundProcessor = new MCMAdapterBackgroundProcessor();
        this.container.scheduleTask(this.backgroundProcessor, 1000);
    }

    public void stop() {
        if (this.backgroundProcessor != null) {
            this.backgroundProcessor.cancel();
        }
        this.backgroundProcessor = null;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        InetSocketAddress addr = exchange.getDestinationAddress();
        if (addr.getPort() != this.managementPort || !addr.getHostName().equals(this.managementHost)) {
            this.next.handleRequest(exchange);
            return;
        }
        if (exchange.isInIoThread()) {
            exchange.dispatch(this);
            return;
        }
        HttpString method = exchange.getRequestMethod();
        try {
            if (method.equals(GET)) {
                this.processManager(exchange);
            } else if (method.equals(CONFIG)) {
                this.processConfig(exchange);
            } else if (method.equals(ENABLE_APP)) {
                try {
                    Map<String, String[]> params = this.readPostParameters(exchange);
                    if (params == null) {
                        this.processError(TYPESYNTAX, SMESPAR, exchange);
                        return;
                    }
                    this.processEnable(exchange, params);
                    this.processOK(exchange);
                }
                catch (Exception Ex) {
                    Ex.printStackTrace(System.out);
                }
            } else if (method.equals(DISABLE_APP)) {
                Map<String, String[]> params = this.readPostParameters(exchange);
                if (params == null) {
                    this.processError(TYPESYNTAX, SMESPAR, exchange);
                    return;
                }
                this.processDisable(exchange, params);
                this.processOK(exchange);
            } else if (method.equals(STOP_APP)) {
                Map<String, String[]> params = this.readPostParameters(exchange);
                if (params == null) {
                    this.processError(TYPESYNTAX, SMESPAR, exchange);
                    return;
                }
                this.processStop(exchange, params);
                this.processOK(exchange);
            } else if (method.equals(REMOVE_APP)) {
                try {
                    this.processRemove(exchange);
                }
                catch (Exception Ex) {
                    Ex.printStackTrace(System.out);
                }
            } else if (method.equals(STATUS)) {
                this.processStatus(exchange);
            } else if (method.equals(DUMP)) {
                this.processDump(exchange);
            } else if (method.equals(INFO)) {
                try {
                    this.processInfo(exchange);
                }
                catch (Exception Ex) {
                    Ex.printStackTrace(System.out);
                }
            } else if (method.equals(PING)) {
                this.processPing(exchange);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            exchange.setResponseCode(500);
            Sender resp = exchange.getResponseSender();
            ByteBuffer bb = ByteBuffer.allocate(100);
            bb.put(e.toString().getBytes());
            bb.flip();
            resp.send(bb);
            return;
        }
    }

    private void processManager(HttpServerExchange exchange) throws Exception {
        String receivedNonce;
        Map<String, Deque<String>> params = exchange.getQueryParameters();
        boolean hasNonce = params.containsKey("nonce");
        int refreshTime = 0;
        if (this.checkNonce && hasNonce && (receivedNonce = params.get("nonce").getFirst()).equals(this.getRawNonce())) {
            boolean refresh = params.containsKey("refresh");
            if (refresh) {
                String sval = params.get("refresh").getFirst();
                refreshTime = Integer.parseInt(sval);
                if (refreshTime < 10) {
                    refreshTime = 10;
                }
                exchange.getResponseHeaders().add(new HttpString("Refresh"), Integer.toString(refreshTime));
            }
            boolean cmd = params.containsKey("Cmd");
            boolean range = params.containsKey("Range");
            if (cmd) {
                String sdomain;
                boolean domain;
                Map<String, String[]> mparams;
                String srange;
                String scmd = params.get("Cmd").getFirst();
                if (scmd.equals("INFO")) {
                    this.processInfo(exchange);
                    return;
                }
                if (scmd.equals("DUMP")) {
                    this.processDump(exchange);
                    return;
                }
                if (scmd.equals("ENABLE-APP") && range) {
                    srange = params.get("Range").getFirst();
                    mparams = this.buildMap(params);
                    if (srange.equals("NODE")) {
                        this.processNodeCmd(exchange, mparams, Context.Status.ENABLED);
                    }
                    if (srange.equals("DOMAIN") && (domain = params.containsKey("Domain"))) {
                        sdomain = params.get("Domain").getFirst();
                        this.processDomainCmd(exchange, sdomain, Context.Status.ENABLED);
                    }
                    if (srange.equals("CONTEXT")) {
                        this.processCmd(exchange, mparams, Context.Status.ENABLED);
                    }
                } else if (scmd.equals("DISABLE-APP") && range) {
                    srange = params.get("Range").getFirst();
                    mparams = this.buildMap(params);
                    if (srange.equals("NODE")) {
                        this.processNodeCmd(exchange, mparams, Context.Status.DISABLED);
                    }
                    if (srange.equals("DOMAIN") && (domain = params.containsKey("Domain"))) {
                        sdomain = params.get("Domain").getFirst();
                        this.processDomainCmd(exchange, sdomain, Context.Status.DISABLED);
                    }
                    if (srange.equals("CONTEXT")) {
                        this.processCmd(exchange, mparams, Context.Status.DISABLED);
                    }
                }
            }
        }
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/html; charset=ISO-8859-1");
        Sender resp = exchange.getResponseSender();
        StringBuilder buf = new StringBuilder();
        buf.append("<html><head>\n<title>Mod_cluster Status</title>\n</head><body>\n");
        buf.append("<h1>" + MOD_CLUSTER_EXPOSED_VERSION + "</h1>");
        String uri = exchange.getRequestPath();
        String nonce = this.getNonce();
        if (refreshTime <= 0) {
            buf.append("<a href=\"" + uri + "?" + nonce + "&refresh=10" + "\">Auto Refresh</a>");
        }
        buf.append(" <a href=\"" + uri + "?" + nonce + "&Cmd=DUMP&Range=ALL" + "\">show DUMP output</a>");
        buf.append(" <a href=\"" + uri + "?" + nonce + "&Cmd=INFO&Range=ALL" + "\">show INFO output</a>");
        buf.append("\n");
        String lbgroup = "";
        for (Node node : this.container.getNodes()) {
            NodeConfig nodeConfig = node.getNodeConfig();
            if (!lbgroup.equals(nodeConfig.getDomain())) {
                lbgroup = nodeConfig.getDomain();
                if (this.reduceDisplay) {
                    buf.append("<br/><br/>LBGroup " + lbgroup + ": ");
                } else {
                    buf.append("<h1> LBGroup " + lbgroup + ": ");
                }
                if (this.allowCmd) {
                    this.domainCommandString(buf, uri, Context.Status.ENABLED, lbgroup);
                    this.domainCommandString(buf, uri, Context.Status.DISABLED, lbgroup);
                }
            }
            if (this.reduceDisplay) {
                buf.append("<br/><br/>Node " + nodeConfig.getJvmRoute());
                this.printProxyStat(buf, node, this.reduceDisplay);
            } else {
                buf.append("<h1> Node " + nodeConfig.getJvmRoute() + " (" + nodeConfig.getType() + "://" + nodeConfig.getHostname() + ":" + nodeConfig.getPort() + "): </h1>\n");
            }
            if (this.allowCmd) {
                this.nodeCommandString(buf, uri, Context.Status.ENABLED, nodeConfig.getJvmRoute());
                this.nodeCommandString(buf, uri, Context.Status.DISABLED, nodeConfig.getJvmRoute());
            }
            if (!this.reduceDisplay) {
                buf.append("<br/>\n");
                buf.append("Balancer: " + nodeConfig.getBalancer() + ",LBGroup: " + nodeConfig.getDomain());
                String flushpackets = "off";
                if (nodeConfig.isFlushPackets()) {
                    flushpackets = "Auto";
                }
                buf.append(",Flushpackets: " + flushpackets + ",Flushwait: " + nodeConfig.getFlushwait() + ",Ping: " + nodeConfig.getPing() + " ,Smax: " + nodeConfig.getPing() + ",Ttl: " + nodeConfig.getTtl());
                this.printProxyStat(buf, node, this.reduceDisplay);
            } else {
                buf.append("<br/>\n");
            }
            if (this.displaySessionids) {
                buf.append(",Num sessions: " + this.container.getJVMRouteSessionCount(nodeConfig.getJvmRoute()));
            }
            buf.append("\n");
            this.printInfoHost(buf, uri, this.reduceDisplay, this.allowCmd, nodeConfig.getJvmRoute());
        }
        if (this.displaySessionids) {
            this.printInfoSessions(buf, this.container.getSessionIds());
        }
        buf.append("</body></html>\n");
        resp.send(buf.toString());
    }

    private void processDomainCmd(HttpServerExchange exchange, String domain, Context.Status status) throws Exception {
        for (Node nodeConfig : this.container.getNodes()) {
            if (!nodeConfig.getNodeConfig().getDomain().equals(domain)) continue;
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            String[] values = new String[]{nodeConfig.getJvmRoute()};
            params.put("JVMRoute", values);
            this.processNodeCmd(exchange, params, status);
        }
    }

    private Map<String, String[]> buildMap(Map<String, Deque<String>> params) {
        HashMap<String, String[]> sparams = new HashMap<String, String[]>();
        for (String key : params.keySet()) {
            String[] values = new String[]{params.get(key).getFirst()};
            sparams.put(key, values);
        }
        return sparams;
    }

    private void printInfoSessions(StringBuilder buf, List<SessionId> sessionids) {
        buf.append("<h1>SessionIDs:</h1>");
        buf.append("<pre>");
        for (SessionId s : sessionids) {
            buf.append("id: " + s.getSessionId() + " route: " + s.getJmvRoute() + "\n");
        }
        buf.append("</pre>");
    }

    private void printInfoHost(StringBuilder buf, String uri, boolean reduceDisplay, boolean allowCmd, String jvmRoute) {
        for (VHost host : this.container.getHosts()) {
            if (!host.getJVMRoute().equals(jvmRoute)) continue;
            if (!reduceDisplay) {
                buf.append("<h2> Virtual Host " + host.getId() + ":</h2>");
            }
            this.printInfoContexts(buf, uri, reduceDisplay, allowCmd, host.getId(), host.getAliases(), jvmRoute);
            if (reduceDisplay) {
                buf.append("Aliases: ");
                for (String alias : host.getAliases()) {
                    buf.append(alias + " ");
                }
                continue;
            }
            buf.append("<h3>Aliases:</h3>");
            buf.append("<pre>");
            for (String alias : host.getAliases()) {
                buf.append(alias + "\n");
            }
            buf.append("</pre>");
        }
    }

    private void printInfoContexts(StringBuilder buf, String uri, boolean reduceDisplay, boolean allowCmd, long host, List<String> alias, String jvmRoute) {
        if (!reduceDisplay) {
            buf.append("<h3>Contexts:</h3>");
        }
        buf.append("<pre>");
        for (Context context : this.container.getContexts()) {
            if (!context.getJvmRoute().equals(jvmRoute) || context.getHostid() != host) continue;
            String status = "REMOVED";
            switch (context.getStatus()) {
                case ENABLED: {
                    status = "ENABLED";
                    break;
                }
                case DISABLED: {
                    status = "DISABLED";
                    break;
                }
                case STOPPED: {
                    status = "STOPPED";
                }
            }
            buf.append(context.getPath() + " , Status: " + status + " Request: " + context.getNbRequests() + " ");
            if (allowCmd) {
                this.contextCommandString(buf, uri, context.getStatus(), context.getPath(), alias, jvmRoute);
            }
            buf.append("\n");
        }
        buf.append("</pre>");
    }

    private void contextCommandString(StringBuilder buf, String uri, Context.Status status, String path, List<String> alias, String jvmRoute) {
        switch (status) {
            case DISABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=ENABLE-APP&Range=CONTEXT&");
                this.contextString(buf, path, alias, jvmRoute);
                buf.append("\">Enable</a> ");
                break;
            }
            case ENABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=DISABLE-APP&Range=CONTEXT&");
                this.contextString(buf, path, alias, jvmRoute);
                buf.append("\">Disable</a> ");
            }
        }
    }

    private void contextString(StringBuilder buf, String path, List<String> alias, String jvmRoute) {
        buf.append("JVMRoute=" + jvmRoute + "&Alias=");
        boolean first = true;
        for (String a : alias) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(a);
        }
        buf.append("&Context=" + path);
    }

    private void nodeCommandString(StringBuilder buf, String uri, Context.Status status, String jvmRoute) {
        switch (status) {
            case ENABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=ENABLE-APP&Range=NODE&JVMRoute=" + jvmRoute + "\">Enable Contexts</a> ");
                break;
            }
            case DISABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=DISABLE-APP&Range=NODE&JVMRoute=" + jvmRoute + "\">Disable Contexts</a> ");
            }
        }
    }

    private void printProxyStat(StringBuilder buf, Node node, boolean reduceDisplay) {
        String status = "NOTOK";
        if (node.getNodeState().getStatus() == NodeState.NodeStatus.NODE_UP) {
            status = "OK";
        }
        if (reduceDisplay) {
            buf.append(" " + status + " ");
        } else {
            buf.append(",Status: " + status + ",Elected: " + node.getNodeState().getOldelected() + ",Read: " + node.getNodeState().getRead() + ",Transferred: " + node.getNodeState().getTransfered() + ",Connected: " + node.getNodeState().getConnected() + ",Load: " + node.getNodeState().getLoad());
        }
    }

    private void domainCommandString(StringBuilder buf, String uri, Context.Status status, String lbgroup) {
        switch (status) {
            case ENABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=ENABLE-APP&Range=DOMAIN&Domain=" + lbgroup + "\">Enable Nodes</a>");
                break;
            }
            case DISABLED: {
                buf.append("<a href=\"" + uri + "?" + this.getNonce() + "&Cmd=DISABLE-APP&Range=DOMAIN&Domain=" + lbgroup + "\">Disable Nodes</a>");
            }
        }
    }

    private void processPing(HttpServerExchange exchange) throws Exception {
        System.out.println("process_ping");
        Map<String, String[]> params = this.readPostParameters(exchange);
        if (params == null) {
            this.processError(TYPESYNTAX, SMESPAR, exchange);
            return;
        }
        String jvmRoute = null;
        String scheme = null;
        String host = null;
        String port = null;
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            String value = values[0];
            if (name.equalsIgnoreCase("JVMRoute")) {
                jvmRoute = value;
                continue;
            }
            if (name.equalsIgnoreCase("Scheme")) {
                scheme = value;
                continue;
            }
            if (name.equalsIgnoreCase("Port")) {
                port = value;
                continue;
            }
            if (name.equalsIgnoreCase("Host")) {
                host = value;
                continue;
            }
            this.processError(TYPESYNTAX, SBADFLD + name + SBADFLD1, exchange);
            return;
        }
        if (jvmRoute == null) {
            ByteBuffer bb;
            Sender resp;
            String data;
            if (scheme == null && host == null && port == null) {
                exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/plain");
                data = "Type=PING-RSP&State=OK";
                resp = exchange.getResponseSender();
                bb = ByteBuffer.allocate(data.length());
                bb.put(data.getBytes());
                bb.flip();
                resp.send(bb);
                return;
            }
            if (scheme == null || host == null || port == null) {
                this.processError(TYPESYNTAX, SMISFLD, exchange);
                return;
            }
            exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/plain");
            data = "Type=PING-RSP";
            data = this.ishostUp(scheme, host, port) ? data.concat("&State=OK") : data.concat("&State=NOTOK");
            resp = exchange.getResponseSender();
            bb = ByteBuffer.allocate(data.length());
            bb.put(data.getBytes());
            bb.flip();
            resp.send(bb);
            return;
        }
        Node nodeConfig = this.container.getNode(jvmRoute);
        if (nodeConfig == null) {
            this.processError(TYPEMEM, MNODERD, exchange);
            return;
        }
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/plain");
        String data = "Type=PING-RSP";
        data = this.isNodeUp(nodeConfig) ? data.concat("&State=OK") : data.concat("&State=NOTOK");
        Sender resp = exchange.getResponseSender();
        ByteBuffer bb = ByteBuffer.allocate(data.length());
        bb.put(data.getBytes());
        bb.flip();
        resp.send(bb);
    }

    private Map<String, String[]> readPostParameters(HttpServerExchange exchange) throws IOException {
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        FormDataParser parser = FormParserFactory.builder(false).addParser(new FormEncodedDataDefinition().setForceCreation(true)).build().createParser(exchange);
        FormData formData = parser.parseBlocking();
        for (String name : formData) {
            Deque<FormData.FormValue> val = formData.get(name);
            if (ret.containsKey(name)) {
                String[] existing = (String[])ret.get(name);
                String[] array = new String[val.size() + existing.length];
                System.arraycopy(existing, 0, array, 0, existing.length);
                int i = existing.length;
                for (FormData.FormValue v : val) {
                    array[i++] = v.getValue();
                }
                ret.put(name, array);
                continue;
            }
            String[] array = new String[val.size()];
            int i = 0;
            for (FormData.FormValue v : val) {
                array[i++] = v.getValue();
            }
            ret.put(name, array);
        }
        return ret;
    }

    private boolean isNodeUp(Node nodeConfig) {
        System.out.println("process_ping: " + nodeConfig);
        return false;
    }

    private boolean ishostUp(String scheme, String host, String port) {
        System.out.println("process_ping: " + scheme + "://" + host + ":" + port);
        return false;
    }

    private void processInfo(HttpServerExchange exchange) throws Exception {
        String data = this.processInfoString();
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/plain");
        exchange.getResponseHeaders().add(new HttpString("Server"), "Mod_CLuster/0.0.0");
        Sender resp = exchange.getResponseSender();
        ByteBuffer bb = ByteBuffer.allocate(data.length());
        bb.put(data.getBytes());
        bb.flip();
        resp.send(bb);
    }

    private String processInfoString() {
        int i = 1;
        StringBuilder data = new StringBuilder();
        for (Node node : this.container.getNodes()) {
            NodeConfig nodeConfig = node.getNodeConfig();
            data.append("Node: [").append(i).append("],Name: ").append(nodeConfig.getJvmRoute()).append(",Balancer: ").append(nodeConfig.getBalancer()).append(",LBGroup: ").append(nodeConfig.getDomain()).append(",Host: ").append(nodeConfig.getHostname()).append(",Port: ").append(nodeConfig.getPort()).append(",Type: ").append(nodeConfig.getType()).append(",Flushpackets: ").append(nodeConfig.isFlushPackets() ? "On" : "Off").append(",Flushwait: ").append(nodeConfig.getFlushwait()).append(",Ping: ").append(nodeConfig.getPing()).append(",Smax: ").append(nodeConfig.getSmax()).append(",Ttl: ").append(nodeConfig.getTtl()).append(",Elected: ").append(node.getNodeState().getElected()).append(",Read: ").append(node.getNodeState().getRead()).append(",Transfered: ").append(node.getNodeState().getTransfered()).append(",Connected: ").append(node.getNodeState().getConnected()).append(",Load: ").append(node.getNodeState().getLoad() + "\n");
            ++i;
        }
        for (VHost host : this.container.getHosts()) {
            int j = 1;
            long node = this.container.getNodeId(host.getJVMRoute());
            for (String alias : host.getAliases()) {
                data.append("Vhost: [").append(node).append(":").append(host.getId()).append(":").append(j).append("], Alias: ").append(alias).append("\n");
                ++j;
            }
        }
        i = 1;
        for (Context context : this.container.getContexts()) {
            data.append("Context: [").append(this.container.getNodeId(context.getJvmRoute())).append(":").append(context.getHostid()).append(":").append(i).append("], Context: ").append(context.getPath()).append(", Status: ").append((Object)context.getStatus()).append("\n");
            ++i;
        }
        return data.toString();
    }

    private void processDump(HttpServerExchange exchange) throws IOException {
        String data = this.processDumpString();
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/plain");
        exchange.getResponseHeaders().add(new HttpString("Server"), "Mod_CLuster/0.0.0");
        Sender resp = exchange.getResponseSender();
        ByteBuffer bb = ByteBuffer.allocate(data.length());
        bb.put(data.getBytes());
        bb.flip();
        resp.send(bb);
    }

    private String processDumpString() {
        StringBuilder data = new StringBuilder();
        int i = 1;
        for (Balancer balancer : this.container.getBalancers()) {
            data.append("balancer: [" + i + "] Name: " + balancer.getName() + " Sticky: ").append((balancer.isStickySession() ? "1" : "0") + " [").append(balancer.getStickySessionCookie() + "]/[" + balancer.getStickySessionPath()).append("] remove: " + (balancer.isStickySessionRemove() ? "1" : "0") + " force: ").append((balancer.isStickySessionForce() ? "1" : "0") + " Timeout: ").append(balancer.getWaitWorker() + " maxAttempts: " + balancer.getMaxattempts()).append("\n");
            ++i;
        }
        i = 1;
        for (Node node : this.container.getNodes()) {
            data.append("node: [").append(i).append(":").append(i).append("]").append(",Balancer: ").append(node.getNodeConfig().getBalancer()).append(",JVMRoute: ").append(node.getJvmRoute()).append(",LBGroup: ").append(node.getNodeConfig().getDomain()).append(",Host: ").append(node.getNodeConfig().getHostname()).append(",Port: ").append(node.getNodeConfig().getPort()).append(",Type: ").append(node.getNodeConfig().getType()).append(",flushpackets: ").append(node.getNodeConfig().isFlushPackets() ? "1" : "0").append(",flushwait: ").append(node.getNodeConfig().getFlushwait()).append(",ping: ").append(node.getNodeConfig().getPing()).append(",smax: ").append(node.getNodeConfig().getSmax()).append(",ttl: ").append(node.getNodeConfig().getTtl()).append(",timeout: ").append(node.getNodeConfig().getTimeout()).append("\n");
            ++i;
        }
        for (VHost host : this.container.getHosts()) {
            int j = 1;
            long node = this.container.getNodeId(host.getJVMRoute());
            for (String alias : host.getAliases()) {
                data.append("host: ").append(j).append(" [").append(alias).append("] vhost: ").append(host.getId()).append(" node: ").append(node).append("\n");
                ++j;
            }
        }
        i = 1;
        for (Context context : this.container.getContexts()) {
            long node = this.container.getNodeId(context.getJvmRoute());
            data.append("context: ").append(i).append(" [").append(context.getPath()).append("] vhost: ").append(context.getHostid()).append(" node: ").append(node).append(" status: ").append((Object)context.getStatus()).append("\n");
            ++i;
        }
        return data.toString();
    }

    private void processStatus(HttpServerExchange exchange) throws Exception {
        Map<String, String[]> params = this.readPostParameters(exchange);
        if (params == null) {
            this.processError(TYPESYNTAX, SMESPAR, exchange);
            return;
        }
        String jvmRoute = null;
        String load = null;
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            String value = values[0];
            if (name.equalsIgnoreCase("JVMRoute")) {
                jvmRoute = value;
                continue;
            }
            if (name.equalsIgnoreCase("Load")) {
                load = value;
                continue;
            }
            this.processError(TYPESYNTAX, SBADFLD + value + SBADFLD1, exchange);
            return;
        }
        if (load == null || jvmRoute == null) {
            this.processError(TYPESYNTAX, SMISFLD, exchange);
            return;
        }
        Node node = this.container.getNode(jvmRoute);
        if (node == null) {
            this.processError(TYPEMEM, MNODERD, exchange);
            return;
        }
        node.getNodeState().setLoad(Integer.parseInt(load));
        node.getNodeState().setStatus(NodeState.NodeStatus.NODE_UP);
        this.processOK(exchange);
    }

    private void processRemove(HttpServerExchange exchange) throws Exception {
        Map<String, String[]> params = this.readPostParameters(exchange);
        if (params == null) {
            this.processError(TYPESYNTAX, SMESPAR, exchange);
            return;
        }
        boolean global = false;
        if (exchange.getRequestPath().equals("*") || exchange.getRequestPath().endsWith("/*")) {
            global = true;
        }
        Context.ContextBuilder context = Context.builder();
        VHost.VHostBuilder host = VHost.builder();
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            String value = values[0];
            if (name.equalsIgnoreCase("JVMRoute")) {
                if (this.container.getNodeId(value) == -1L) {
                    this.processError(TYPEMEM, MNODERD, exchange);
                    return;
                }
                host.setJVMRoute(value);
                context.setJvmRoute(value);
                continue;
            }
            if (name.equalsIgnoreCase("Alias")) {
                String[] aliases = value.split(",");
                host.addAliases(Arrays.asList(aliases));
                continue;
            }
            if (!name.equalsIgnoreCase("Context")) continue;
            context.setPath(value);
        }
        if (context.getJvmRoute() == null) {
            this.processError(TYPESYNTAX, SROUBAD, exchange);
            return;
        }
        if (global) {
            this.container.removeNode(context.getJvmRoute());
        } else {
            this.container.remove(context.build(), host.build());
        }
        this.processOK(exchange);
    }

    private void processStop(HttpServerExchange exchange, Map<String, String[]> params) throws Exception {
        this.processCmd(exchange, params, Context.Status.STOPPED);
    }

    private void processDisable(HttpServerExchange exchange, Map<String, String[]> params) throws Exception {
        this.processCmd(exchange, params, Context.Status.DISABLED);
    }

    private void processEnable(HttpServerExchange exchange, Map<String, String[]> params) throws Exception {
        this.processCmd(exchange, params, Context.Status.ENABLED);
    }

    private void processCmd(HttpServerExchange exchange, Map<String, String[]> params, Context.Status status) throws Exception {
        if (exchange.getRequestPath().equals("*") || exchange.getRequestPath().endsWith("/*")) {
            this.processNodeCmd(exchange, params, status);
            return;
        }
        Context.ContextBuilder context = Context.builder();
        VHost.VHostBuilder host = VHost.builder();
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            String value = values[0];
            if (name.equalsIgnoreCase("JVMRoute")) {
                if (this.container.getNodeId(value) == -1L) {
                    this.processError(TYPEMEM, MNODERD, exchange);
                    return;
                }
                host.setJVMRoute(value);
                context.setJvmRoute(value);
                continue;
            }
            if (name.equalsIgnoreCase("Alias")) {
                String[] aliases = value.split(",");
                host.addAliases(Arrays.asList(aliases));
                continue;
            }
            if (!name.equalsIgnoreCase("Context")) continue;
            context.setPath(value);
        }
        if (context.getJvmRoute() == null) {
            this.processError(TYPESYNTAX, SROUBAD, exchange);
            return;
        }
        context.setStatus(status);
        long id = this.container.insertupdate(host.build());
        context.setHostid(id);
        this.container.insertupdate(context.build());
    }

    private void processNodeCmd(HttpServerExchange exchange, Map<String, String[]> params, Context.Status status) throws Exception {
        String jvmRoute = null;
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            String value = values[0];
            if (!name.equalsIgnoreCase("JVMRoute")) continue;
            jvmRoute = value;
        }
        if (jvmRoute == null) {
            this.processError(TYPESYNTAX, SROUBAD, exchange);
            return;
        }
        for (VHost host : this.container.getHosts()) {
            if (!host.getJVMRoute().equals(jvmRoute)) continue;
            for (Context context : this.container.getContexts()) {
                if (!context.getJvmRoute().equals(jvmRoute) || context.getHostid() != host.getId()) continue;
                if (status != Context.Status.REMOVED) {
                    context.setStatus(status);
                    this.container.insertupdate(context);
                    continue;
                }
                this.container.remove(context, host);
            }
        }
    }

    private void processConfig(HttpServerExchange exchange) throws Exception {
        Map<String, String[]> params = this.readPostParameters(exchange);
        if (params == null) {
            this.processError(TYPESYNTAX, SMESPAR, exchange);
            return;
        }
        NodeConfig.NodeBuilder node = NodeConfig.builder();
        Balancer.BalancerBuilder balancer = Balancer.builder();
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            String value = values[0];
            if (name.equalsIgnoreCase("Balancer")) {
                UndertowLogger.ROOT_LOGGER.error("Balancer updates are not supported");
                continue;
            }
            if (name.equalsIgnoreCase("StickySession")) {
                if (!value.equalsIgnoreCase("No")) continue;
                balancer.setStickySession(false);
                continue;
            }
            if (name.equalsIgnoreCase("StickySessionCookie")) {
                balancer.setStickySessionCookie(value);
                continue;
            }
            if (name.equalsIgnoreCase("StickySessionPath")) {
                balancer.setStickySessionPath(value);
                continue;
            }
            if (name.equalsIgnoreCase("StickySessionRemove")) {
                if (!value.equalsIgnoreCase("Yes")) continue;
                balancer.setStickySessionRemove(true);
                continue;
            }
            if (name.equalsIgnoreCase("StickySessionForce")) {
                if (!value.equalsIgnoreCase("no")) continue;
                balancer.setStickySessionForce(false);
                continue;
            }
            if (name.equalsIgnoreCase("WaitWorker")) {
                balancer.setWaitWorker(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("Maxattempts")) {
                balancer.setMaxattempts(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("JVMRoute")) {
                node.setJvmRoute(value);
                continue;
            }
            if (name.equalsIgnoreCase("Domain")) {
                node.setDomain(value);
                continue;
            }
            if (name.equalsIgnoreCase("Host")) {
                node.setHostname(value);
                continue;
            }
            if (name.equalsIgnoreCase("Port")) {
                node.setPort(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("Type")) {
                node.setType(value);
                continue;
            }
            if (name.equalsIgnoreCase("Reversed")) continue;
            if (name.equalsIgnoreCase("flushpacket")) {
                if (value.equalsIgnoreCase("on")) {
                    node.setFlushPackets(true);
                }
                if (!value.equalsIgnoreCase("auto")) continue;
                node.setFlushPackets(true);
                continue;
            }
            if (name.equalsIgnoreCase("flushwait")) {
                node.setFlushwait(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("ping")) {
                node.setPing(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("smax")) {
                node.setSmax(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("ttl")) {
                node.setTtl(Integer.valueOf(value));
                continue;
            }
            if (name.equalsIgnoreCase("Timeout")) {
                node.setTimeout(Integer.valueOf(value));
                continue;
            }
            this.processError(TYPESYNTAX, SBADFLD + name + SBADFLD1, exchange);
            return;
        }
        this.container.insertupdate(balancer.build());
        this.container.insertupdate(node.build());
        this.processOK(exchange);
    }

    private void processOK(HttpServerExchange exchange) throws Exception {
        exchange.setResponseCode(200);
        exchange.getResponseHeaders().add(new HttpString("Content-type"), "plain/text");
        exchange.endExchange();
    }

    private void processError(String type, String errstring, HttpServerExchange exchange) throws Exception {
        exchange.setResponseCode(500);
        exchange.getResponseHeaders().add(new HttpString("Version"), VERSION_PROTOCOL);
        exchange.getResponseHeaders().add(new HttpString("Type"), type);
        exchange.getResponseHeaders().add(new HttpString("Mess"), errstring);
        exchange.endExchange();
    }

    String getNonce() {
        return "nonce=" + this.getRawNonce();
    }

    String getRawNonce() {
        if (this.nonce == null) {
            byte[] nonce = new byte[16];
            this.r.nextBytes(nonce);
            this.nonce = "";
            for (int i = 0; i < 16; i += 2) {
                this.nonce = this.nonce.concat(Integer.toHexString(0xFF & nonce[i] * 16 + 255 & nonce[i + 1]));
            }
        }
        return this.nonce;
    }

    public String getManagementHost() {
        return this.managementHost;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public static MCMPHandlerBuilder builder() {
        return new MCMPHandlerBuilder();
    }

    public static class MCMPHandlerBuilder {
        boolean checkNonce = true;
        boolean reduceDisplay = false;
        boolean allowCmd = true;
        boolean displaySessionids = true;
        private String advertiseGroup = "224.0.1.105";
        private int advertisePort = 23364;
        private String advertiseAddress = "127.0.0.1";
        private MessageDigest md = null;
        private String scheme = "http";
        private String securityKey;
        private String managementHost;
        private int managementPort;

        MCMPHandlerBuilder() {
        }

        public boolean isCheckNonce() {
            return this.checkNonce;
        }

        public void setCheckNonce(boolean checkNonce) {
            this.checkNonce = checkNonce;
        }

        public boolean isReduceDisplay() {
            return this.reduceDisplay;
        }

        public void setReduceDisplay(boolean reduceDisplay) {
            this.reduceDisplay = reduceDisplay;
        }

        public boolean isAllowCmd() {
            return this.allowCmd;
        }

        public void setAllowCmd(boolean allowCmd) {
            this.allowCmd = allowCmd;
        }

        public boolean isDisplaySessionids() {
            return this.displaySessionids;
        }

        public void setDisplaySessionids(boolean displaySessionids) {
            this.displaySessionids = displaySessionids;
        }

        public void setAdvertiseGroup(String advertiseGroup) {
            this.advertiseGroup = advertiseGroup;
        }

        public void setAdvertisePort(int advertisePort) {
            this.advertisePort = advertisePort;
        }

        public void setAdvertiseAddress(String advertiseAddress) {
            this.advertiseAddress = advertiseAddress;
        }

        public String getAdvertiseGroup() {
            return this.advertiseGroup;
        }

        public int getAdvertisePort() {
            return this.advertisePort;
        }

        public String getAdvertiseAddress() {
            return this.advertiseAddress;
        }

        public MessageDigest getMd() {
            return this.md;
        }

        public void setMd(MessageDigest md) {
            this.md = md;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getSecurityKey() {
            return this.securityKey;
        }

        public void setSecurityKey(String securityKey) {
            this.securityKey = securityKey;
        }

        public String getManagementHost() {
            return this.managementHost;
        }

        public void setManagementHost(String managementHost) {
            this.managementHost = managementHost;
        }

        public int getManagementPort() {
            return this.managementPort;
        }

        public void setManagementPort(int managementPort) {
            this.managementPort = managementPort;
        }

        public MCMPHandler build(ModClusterContainer container, HttpHandler next) {
            return new MCMPHandler(container, this, next);
        }
    }

    protected class MCMAdapterBackgroundProcessor
    extends TimerTask {
        final InetAddress group;
        final InetAddress addr;
        final MulticastSocket s;
        int seq = 0;

        MCMAdapterBackgroundProcessor() {
            try {
                this.group = InetAddress.getByName(MCMPHandler.this.advertiseGroup);
                this.addr = InetAddress.getByName(MCMPHandler.this.advertiseAddress);
                InetSocketAddress addrs = new InetSocketAddress(MCMPHandler.this.advertisePort);
                this.s = new MulticastSocket(addrs);
                this.s.setTimeToLive(29);
                this.s.joinGroup(this.group);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            try {
                byte[] ssalt;
                String server = UUID.randomUUID().toString();
                Date date = new Date(System.currentTimeMillis());
                MCMPHandler.this.md.reset();
                if (MCMPHandler.this.securityKey == null) {
                    ssalt = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                } else {
                    this.digestString(MCMPHandler.this.md, MCMPHandler.this.securityKey);
                    ssalt = MCMPHandler.this.md.digest();
                }
                MCMPHandler.this.md.update(ssalt);
                this.digestString(MCMPHandler.this.md, date);
                this.digestString(MCMPHandler.this.md, this.seq);
                this.digestString(MCMPHandler.this.md, server);
                byte[] digest = MCMPHandler.this.md.digest();
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < digest.length; ++i) {
                    str.append(String.format("%x", digest[i]));
                }
                String sbuf = "HTTP/1.0 200 OK\r\nDate: " + date + "\r\n" + "Sequence: " + this.seq + "\r\n" + "Digest: " + str.toString() + "\r\n" + "Server: " + server + "\r\n" + "X-Manager-Address: " + MCMPHandler.this.getManagementHost() + ":" + MCMPHandler.this.getManagementPort() + "\r\n" + "X-Manager-Url: /" + server + "\r\n" + "X-Manager-Protocol: " + MCMPHandler.this.scheme + "\r\n" + "X-Manager-Host: " + MCMPHandler.this.getManagementHost() + "\r\n";
                byte[] buf = sbuf.getBytes();
                DatagramPacket data = new DatagramPacket(buf, buf.length, this.group, MCMPHandler.this.advertisePort);
                this.s.send(data);
                ++this.seq;
            }
            catch (Exception Ex) {
                Ex.printStackTrace();
            }
        }

        private void digestString(MessageDigest md, int seq) {
            String sseq = "" + seq;
            this.digestString(md, sseq);
        }

        private void digestString(MessageDigest md, Date date) {
            String sdate = date.toString();
            this.digestString(md, sdate);
        }

        private void digestString(MessageDigest md, String securityKey) {
            byte[] buf = securityKey.getBytes();
            md.update(buf);
        }
    }
}

