/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyControlFrameStreamSinkChannel;
import io.undertow.spdy.SpdyProtocolUtils;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;

class SpdyGoAwayStreamSinkChannel
extends SpdyControlFrameStreamSinkChannel {
    private final int status;
    private final int lastGoodStreamId;

    protected SpdyGoAwayStreamSinkChannel(SpdyChannel channel, int status, int lastGoodStreamId) {
        super(channel);
        this.status = status;
        this.lastGoodStreamId = lastGoodStreamId;
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 7;
        SpdyProtocolUtils.putInt(buf, firstInt);
        SpdyProtocolUtils.putInt(buf, 8);
        SpdyProtocolUtils.putInt(buf, this.lastGoodStreamId);
        SpdyProtocolUtils.putInt(buf, this.status);
        return new SendFrameHeader(new ImmediatePooled<ByteBuffer>(buf));
    }

    @Override
    protected boolean isLastFrame() {
        return true;
    }
}

