/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.spdy;

import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.spdy.SpdyChannel;
import io.undertow.spdy.SpdyProtocolUtils;
import io.undertow.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import org.xnio.Pooled;

public class SpdySynStreamStreamSinkChannel
extends SpdyStreamStreamSinkChannel {
    private final HeaderMap headers;
    private boolean first = true;
    private final Deflater deflater;

    SpdySynStreamStreamSinkChannel(SpdyChannel channel, HeaderMap headers, int streamId, Deflater deflater) {
        super(channel, streamId);
        this.headers = headers;
        this.deflater = deflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        Pooled header = ((SpdyChannel)this.getChannel()).getHeapBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)header.getResource();
        if (this.first) {
            Pooled outPooled = ((SpdyChannel)this.getChannel()).getHeapBufferPool().allocate();
            Pooled inPooled = ((SpdyChannel)this.getChannel()).getHeapBufferPool().allocate();
            try {
                int deflated;
                ByteBuffer inputBuffer = (ByteBuffer)inPooled.getResource();
                ByteBuffer outputBuffer = (ByteBuffer)outPooled.getResource();
                this.first = false;
                int firstInt = Integer.MIN_VALUE | ((SpdyChannel)this.getChannel()).getSpdyVersion() << 16 | 1;
                SpdyProtocolUtils.putInt(buffer, firstInt);
                SpdyProtocolUtils.putInt(buffer, 0);
                HeaderMap headers = this.headers;
                SpdyProtocolUtils.putInt(buffer, this.getStreamId());
                SpdyProtocolUtils.putInt(buffer, 0);
                buffer.put((byte)0);
                buffer.put((byte)0);
                headers.remove(Headers.CONNECTION);
                headers.remove(Headers.KEEP_ALIVE);
                headers.remove(Headers.TRANSFER_ENCODING);
                SpdyProtocolUtils.putInt(inputBuffer, headers.size());
                long fiCookie = headers.fastIterateNonEmpty();
                while (fiCookie != -1L) {
                    HeaderValues headerValues = headers.fiCurrent(fiCookie);
                    SpdyProtocolUtils.putInt(inputBuffer, headerValues.getHeaderName().length());
                    for (int i = 0; i < headerValues.getHeaderName().length(); ++i) {
                        inputBuffer.put((byte)Character.toLowerCase((char)headerValues.getHeaderName().byteAt(i)));
                    }
                    int pos = inputBuffer.position();
                    SpdyProtocolUtils.putInt(inputBuffer, 0);
                    int size = headerValues.size() - 1;
                    for (int i = 0; i < headerValues.size(); ++i) {
                        String val = headerValues.get(i);
                        size += val.length();
                        for (int j = 0; j < val.length(); ++j) {
                            inputBuffer.put((byte)val.charAt(j));
                        }
                        if (i == headerValues.size() - 1) continue;
                        inputBuffer.put((byte)0);
                    }
                    SpdyProtocolUtils.putInt(inputBuffer, size, pos);
                    fiCookie = headers.fiNext(fiCookie);
                }
                this.deflater.setInput(inputBuffer.array(), inputBuffer.arrayOffset(), inputBuffer.position());
                do {
                    deflated = this.deflater.deflate(outputBuffer.array(), outputBuffer.arrayOffset(), outputBuffer.remaining(), 2);
                    buffer.put(outputBuffer.array(), outputBuffer.arrayOffset(), deflated);
                } while (deflated == outputBuffer.remaining());
                SpdyProtocolUtils.putInt(buffer, (this.isWritesShutdown() && !this.getBuffer().hasRemaining() ? 1 : 0) << 24 | buffer.position() - 8, 4);
            }
            finally {
                inPooled.free();
                outPooled.free();
            }
        }
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            int fcWindow = this.grabFlowControlBytes(this.getBuffer().remaining());
            if (fcWindow > 0) {
                remainingInBuffer = this.getBuffer().remaining() - fcWindow;
                SpdyProtocolUtils.putInt(buffer, this.getStreamId());
                SpdyProtocolUtils.putInt(buffer, ((this.isWritesShutdown() ? 1 : 0) << 24) + fcWindow);
            } else {
                remainingInBuffer = this.getBuffer().remaining();
            }
        }
        ((ByteBuffer)header.getResource()).flip();
        if (!((ByteBuffer)header.getResource()).hasRemaining()) {
            header.free();
            return new SendFrameHeader(remainingInBuffer, null);
        }
        return new SendFrameHeader(remainingInBuffer, (Pooled<ByteBuffer>)header);
    }
}

