/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketException;
import io.undertow.websockets.core.WebSocketFrameCorruptedException;
import io.undertow.websockets.core.WebSocketFramePriority;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketInvalidCloseCodeException;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.WebSockets;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;

public abstract class WebSocketChannel
extends AbstractFramedChannel<WebSocketChannel, StreamSourceFrameChannel, StreamSinkFrameChannel> {
    private final boolean client;
    private final WebSocketVersion version;
    private final String wsUrl;
    private boolean closeFrameReceived;
    private boolean closeFrameSent;
    private final String subProtocol;
    private final boolean extensionsSupported;
    private volatile PartialFrame partialFrame;
    private final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());
    protected StreamSourceFrameChannel fragmentedChannel;
    private final Set<WebSocketChannel> peerConnections;

    protected WebSocketChannel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, WebSocketVersion version, String wsUrl, String subProtocol, boolean client, boolean extensionsSupported, Set<WebSocketChannel> peerConnections) {
        super(connectedStreamChannel, bufferPool, new WebSocketFramePriority(), null);
        this.client = client;
        this.version = version;
        this.wsUrl = wsUrl;
        this.extensionsSupported = extensionsSupported;
        this.subProtocol = subProtocol;
        this.peerConnections = peerConnections;
        this.addCloseTask(new ChannelListener<WebSocketChannel>(){

            public void handleEvent(WebSocketChannel channel) {
                WebSocketChannel.this.peerConnections.remove(WebSocketChannel.this);
            }
        });
    }

    @Override
    protected boolean isLastFrameSent() {
        return this.closeFrameSent;
    }

    @Override
    protected boolean isLastFrameReceived() {
        return this.closeFrameReceived;
    }

    @Override
    protected void markReadsBroken(Throwable cause) {
        super.markReadsBroken(cause);
    }

    @Override
    protected boolean isReadsBroken() {
        return super.isReadsBroken();
    }

    @Override
    protected FrameHeaderData parseFrame(ByteBuffer data) throws IOException {
        if (this.partialFrame == null) {
            this.partialFrame = this.receiveFrame();
        }
        try {
            this.partialFrame.handle(data);
        }
        catch (WebSocketException e) {
            this.markReadsBroken(e);
            if (WebSocketLogger.REQUEST_LOGGER.isDebugEnabled()) {
                WebSocketLogger.REQUEST_LOGGER.debugf(e, "receive failed due to Exception", new Object[0]);
            }
            WebSockets.sendClose(new CloseMessage(1002, e.getMessage()).toByteBuffer(), this, null);
            throw new IOException(e);
        }
        if (this.partialFrame.isDone()) {
            PartialFrame p = this.partialFrame;
            this.partialFrame = null;
            return p;
        }
        return null;
    }

    protected abstract PartialFrame receiveFrame();

    @Override
    protected StreamSourceFrameChannel createChannel(FrameHeaderData frameHeaderData, Pooled<ByteBuffer> frameData) {
        PartialFrame partialFrame = (PartialFrame)frameHeaderData;
        StreamSourceFrameChannel channel = partialFrame.getChannel(frameData);
        if (channel.getType() == WebSocketFrameType.CLOSE) {
            this.closeFrameReceived = true;
        }
        return channel;
    }

    public final boolean setAttribute(String key, Object value) {
        if (value == null) {
            return this.attributes.remove(key) != null;
        }
        return this.attributes.put(key, value) == null;
    }

    public final Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public boolean areExtensionsSupported() {
        return this.extensionsSupported;
    }

    @Override
    protected void handleBrokenSourceChannel(Throwable e) {
        if (e instanceof UnsupportedEncodingException) {
            this.getFramePriority().immediateCloseFrame();
            WebSockets.sendClose(new CloseMessage(1007, e.getMessage()).toByteBuffer(), this, null);
        } else if (e instanceof WebSocketInvalidCloseCodeException) {
            WebSockets.sendClose(new CloseMessage(1002, e.getMessage()).toByteBuffer(), this, null);
        } else if (e instanceof WebSocketFrameCorruptedException) {
            this.getFramePriority().immediateCloseFrame();
            WebSockets.sendClose(new CloseMessage(1002, e.getMessage()).toByteBuffer(), this, null);
        }
    }

    @Override
    protected void handleBrokenSinkChannel(Throwable e) {
    }

    @Deprecated
    public Set<String> getSubProtocols() {
        return Collections.singleton(this.subProtocol);
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    public boolean isCloseFrameReceived() {
        return this.closeFrameReceived;
    }

    public boolean isCloseFrameSent() {
        return this.closeFrameSent;
    }

    public String getRequestScheme() {
        if (this.getUrl().startsWith("wss:")) {
            return "wss";
        }
        return "ws";
    }

    public boolean isSecure() {
        return "wss".equals(this.getRequestScheme());
    }

    public String getUrl() {
        return this.wsUrl;
    }

    public WebSocketVersion getVersion() {
        return this.version;
    }

    @Override
    public InetSocketAddress getSourceAddress() {
        return this.getPeerAddress(InetSocketAddress.class);
    }

    @Override
    public InetSocketAddress getDestinationAddress() {
        return this.getLocalAddress(InetSocketAddress.class);
    }

    public boolean isClient() {
        return this.client;
    }

    public final StreamSinkFrameChannel send(WebSocketFrameType type, long payloadSize) throws IOException {
        if (payloadSize < 0L) {
            throw WebSocketMessages.MESSAGES.negativePayloadLength();
        }
        if (this.isWritesBroken()) {
            throw WebSocketMessages.MESSAGES.streamIsBroken();
        }
        StreamSinkFrameChannel ch = this.createStreamSinkChannel(type, payloadSize);
        this.getFramePriority().addToOrderQueue(ch);
        if (type == WebSocketFrameType.CLOSE) {
            this.closeFrameSent = true;
        }
        return ch;
    }

    public final StreamSinkFrameChannel send(WebSocketFrameType type) throws IOException {
        if (this.isWritesBroken()) {
            throw WebSocketMessages.MESSAGES.streamIsBroken();
        }
        StreamSinkFrameChannel ch = this.createStreamSinkChannel(type, -1L);
        this.getFramePriority().addToOrderQueue(ch);
        if (type == WebSocketFrameType.CLOSE) {
            this.closeFrameSent = true;
        }
        return ch;
    }

    public void sendClose() throws IOException {
        StreamSinkFrameChannel closeChannel = this.send(WebSocketFrameType.CLOSE, 0L);
        closeChannel.shutdownWrites();
        if (!closeChannel.flush()) {
            closeChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                public void handleException(StreamSinkChannel channel, IOException exception) {
                    IoUtils.safeClose((Closeable)((Object)WebSocketChannel.this));
                }
            }));
        }
    }

    protected abstract StreamSinkFrameChannel createStreamSinkChannel(WebSocketFrameType var1, long var2);

    protected WebSocketFramePriority getFramePriority() {
        return (WebSocketFramePriority)super.getFramePriority();
    }

    public Set<WebSocketChannel> getPeerConnections() {
        return Collections.unmodifiableSet(this.peerConnections);
    }

    public static interface PartialFrame
    extends FrameHeaderData {
        public StreamSourceFrameChannel getChannel(Pooled<ByteBuffer> var1);

        public void handle(ByteBuffer var1) throws WebSocketException;

        public boolean isDone();
    }
}

