/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowMessages;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSinkChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSinkChannel {
    private static final Pooled<ByteBuffer> EMPTY_BYTE_BUFFER = new ImmediatePooled<ByteBuffer>(ByteBuffer.allocateDirect(0));
    private final Pooled<ByteBuffer> buffer;
    private final C channel;
    private final ChannelListener.SimpleSetter<S> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<S> closeSetter = new ChannelListener.SimpleSetter();
    private final Object lock = new Object();
    private volatile int state = 0;
    private SendFrameHeader header;
    private Pooled<ByteBuffer> trailer;
    private static final int STATE_BROKEN = 1;
    private static final int STATE_READY_FOR_FLUSH = 2;
    private static final int STATE_CLOSED = 4;
    private static final int STATE_ACTIVE = 8;
    private static final int STATE_WRITES_RESUMED = 16;
    private static final int STATE_WRITES_SHUTDOWN = 32;
    private static final int STATE_IN_LISTENER_LOOP = 64;
    private static final int STATE_FULLY_FLUSHED = 128;
    private static final int STATE_FINAL_FRAME_QUEUED = 256;

    protected AbstractFramedStreamSinkChannel(C channel) {
        this.channel = channel;
        this.buffer = ((AbstractFramedChannel)channel).getBufferPool().allocate();
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)((Object)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)((Object)this));
    }

    public void suspendWrites() {
        this.state &= 0xFFFFFFEF;
        if (Bits.anyAreSet((int)this.state, (int)8)) {
            ((AbstractFramedChannel)this.channel).suspendWrites();
        }
    }

    protected void suspendWritesInternal() {
        ((AbstractFramedChannel)this.channel).suspendWrites();
    }

    protected void resumeWritesInternal() {
        ((AbstractFramedChannel)this.channel).resumeWrites();
    }

    final SendFrameHeader getFrameHeader() {
        if (this.header == null) {
            this.header = this.createFrameHeader();
            if (this.header == null) {
                this.header = new SendFrameHeader(0, null);
            }
        }
        return this.header;
    }

    protected int frameCanSend() {
        return ((ByteBuffer)this.buffer.getResource()).remaining();
    }

    protected SendFrameHeader createFrameHeader() {
        return null;
    }

    final ByteBuffer getFrameFooter() {
        if (this.trailer == null) {
            this.trailer = this.createFrameFooter();
            if (this.trailer == null) {
                this.trailer = EMPTY_BYTE_BUFFER;
            }
        }
        return (ByteBuffer)this.trailer.getResource();
    }

    protected Pooled<ByteBuffer> createFrameFooter() {
        return null;
    }

    public void resumeWrites() {
        this.resumeWrites(false);
    }

    public boolean isWriteResumed() {
        return Bits.anyAreSet((int)this.state, (int)16);
    }

    public void wakeupWrites() {
        this.resumeWrites(true);
    }

    void resumeWrites(boolean wakeup) {
        this.state |= 0x10;
        if (Bits.anyAreSet((int)this.state, (int)8)) {
            if (wakeup) {
                ((AbstractFramedChannel)this.channel).wakeupWrites();
            } else {
                ((AbstractFramedChannel)this.channel).resumeWrites();
            }
        } else if (!Bits.anyAreSet((int)this.state, (int)64)) {
            this.getIoThread().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractFramedStreamSinkChannel.this.state |= 64;
                    try {
                        do {
                            ChannelListener listener;
                            if ((listener = AbstractFramedStreamSinkChannel.this.getWriteListener()) == null || !AbstractFramedStreamSinkChannel.this.isWriteResumed()) {
                                return;
                            }
                            ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedStreamSinkChannel.this), listener);
                        } while (Bits.allAreClear((int)AbstractFramedStreamSinkChannel.this.state, (int)15) && (Bits.anyAreSet((int)AbstractFramedStreamSinkChannel.this.state, (int)128) || ((ByteBuffer)AbstractFramedStreamSinkChannel.this.buffer.getResource()).hasRemaining()));
                    }
                    finally {
                        AbstractFramedStreamSinkChannel.this.state &= -65;
                    }
                }
            });
        }
    }

    public void shutdownWrites() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        this.state |= 0x20;
        this.queueFinalFrame();
    }

    private void queueFinalFrame() throws IOException {
        if (Bits.allAreClear((int)this.state, (int)259)) {
            ((ByteBuffer)this.buffer.getResource()).flip();
            this.state |= 0x102;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
    }

    protected boolean isFinalFrameQueued() {
        return Bits.anyAreSet((int)this.state, (int)256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet((int)this.state, (int)5)) {
                return;
            }
            if (Bits.anyAreSet((int)this.state, (int)8)) {
                ((AbstractFramedChannel)this.channel).awaitWritable();
            } else if (Bits.anyAreSet((int)this.state, (int)2)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet((int)this.state, (int)5)) {
                return;
            }
            if (Bits.anyAreSet((int)this.state, (int)8)) {
                ((AbstractFramedChannel)this.channel).awaitWritable(l, timeUnit);
            } else if (Bits.anyAreSet((int)this.state, (int)2)) {
                try {
                    if (Bits.anyAreSet((int)this.state, (int)5)) {
                        return;
                    }
                    this.lock.wait(timeUnit.toMillis(l));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    public XnioExecutor getWriteThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public ChannelListener.Setter<? extends S> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends S> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return ((AbstractFramedChannel)this.channel).getWorker();
    }

    public XnioIoThread getIoThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return true;
        }
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (Bits.anyAreSet((int)this.state, (int)128)) {
            this.state |= 4;
            return true;
        }
        if (Bits.anyAreSet((int)this.state, (int)32) && Bits.anyAreClear((int)this.state, (int)256)) {
            this.queueFinalFrame();
        }
        if (Bits.allAreSet((int)this.state, (int)8)) {
            ((AbstractFramedChannel)this.channel).flushSenders();
            if (Bits.allAreSet((int)this.state, (int)384)) {
                this.state |= 4;
                return true;
            }
        }
        return !Bits.allAreSet((int)this.state, (int)32);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int state = this.state;
        if (Bits.anyAreSet((int)state, (int)2)) {
            this.flush();
            state = this.state;
        }
        if (Bits.anyAreSet((int)state, (int)2)) {
            return 0L;
        }
        if (Bits.anyAreSet((int)state, (int)37)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        long copied = Buffers.copy((ByteBuffer)((ByteBuffer)this.buffer.getResource()), (ByteBuffer[])srcs, (int)offset, (int)length);
        if (!((ByteBuffer)this.buffer.getResource()).hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public int write(ByteBuffer src) throws IOException {
        int state = this.state;
        if (Bits.anyAreSet((int)state, (int)2)) {
            this.flush();
            state = this.state;
        }
        if (Bits.anyAreSet((int)state, (int)2)) {
            return 0;
        }
        if (Bits.anyAreSet((int)state, (int)37)) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        int copied = Buffers.copy((ByteBuffer)((ByteBuffer)this.buffer.getResource()), (ByteBuffer)src);
        if (!((ByteBuffer)this.buffer.getResource()).hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.writeFinal(srcs, 0, srcs.length);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer)src);
    }

    private void handleBufferFull() throws IOException {
        if (Bits.allAreClear((int)this.state, (int)2)) {
            this.getBuffer().flip();
            this.state |= 2;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
        if (Bits.anyAreSet((int)this.state, (int)8)) {
            ((AbstractFramedChannel)this.channel).flushSenders();
        }
    }

    protected abstract boolean isLastFrame();

    public boolean isReadyForFlush() {
        return Bits.anyAreSet((int)this.state, (int)2);
    }

    public boolean isWritesShutdown() {
        return Bits.anyAreSet((int)this.state, (int)32);
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)4);
    }

    public void close() throws IOException {
        this.state |= 4;
        this.buffer.free();
        if (this.header != null && this.header.getByteBuffer() != null) {
            this.header.getByteBuffer().free();
        }
        if (this.trailer != null) {
            this.trailer.free();
        }
        ((AbstractFramedChannel)this.channel).close();
        this.wakeupWaiters();
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    public ByteBuffer getBuffer() {
        return (ByteBuffer)this.buffer.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushComplete() throws IOException {
        try {
            boolean channelClosed;
            this.state &= 0xFFFFFFF5;
            int remaining = this.header.getReminingInBuffer();
            boolean bl = channelClosed = Bits.anyAreSet((int)this.state, (int)256) && remaining == 0;
            if (remaining > 0) {
                ((ByteBuffer)this.buffer.getResource()).limit(((ByteBuffer)this.buffer.getResource()).limit() + remaining);
            }
            if (channelClosed) {
                this.state |= 0x80;
                this.buffer.free();
            } else {
                ((ByteBuffer)this.buffer.getResource()).compact();
            }
            if (this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().free();
            }
            this.trailer.free();
            this.header = null;
            this.trailer = null;
            final ChannelListener closeListener = this.closeSetter.get();
            if (channelClosed && closeListener != null) {
                this.getIoThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedStreamSinkChannel.this), (ChannelListener)closeListener);
                    }
                });
            }
            if (this.isWriteResumed() && !channelClosed) {
                this.wakeupWrites();
            }
            this.handleFlushComplete();
        }
        finally {
            this.wakeupWaiters();
        }
    }

    protected void handleFlushComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markBroken() {
        this.state |= 1;
        try {
            ChannelListener closeListener;
            ChannelListener writeListener;
            this.wakeupWrites();
            this.wakeupWaiters();
            if (this.isWriteResumed() && (writeListener = this.writeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), (ChannelListener)writeListener);
            }
            if ((closeListener = this.closeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), (ChannelListener)closeListener);
            }
        }
        finally {
            if (this.header != null && this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().free();
            }
            if (this.trailer != null) {
                this.trailer.free();
            }
            this.buffer.free();
        }
    }

    ChannelListener<? super S> getWriteListener() {
        return this.writeSetter.get();
    }

    void activated() {
        if (Bits.allAreClear((int)this.state, (int)8)) {
            this.state |= 8;
            if (this.isWriteResumed()) {
                ((AbstractFramedChannel)this.channel).resumeWrites();
            }
            this.wakeupWaiters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupWaiters() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected boolean isActivated() {
        return Bits.anyAreSet((int)this.state, (int)8);
    }

    public C getChannel() {
        return this.channel;
    }
}

