/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.ConnectionSSLSessionInfo;
import io.undertow.server.Connectors;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.SSLSessionInfo;
import io.undertow.server.ServerConnection;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.server.protocol.http.HttpReadListener;
import io.undertow.server.protocol.http.HttpResponseConduit;
import io.undertow.server.protocol.http.HttpTransferEncoding;
import io.undertow.server.protocol.http.PipeliningBufferingStreamSinkConduit;
import io.undertow.server.protocol.http.ServerFixedLengthStreamSinkConduit;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.SslChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class HttpServerConnection
extends AbstractServerConnection {
    private SSLSessionInfo sslSessionInfo;
    private HttpReadListener readListener;
    private PipeliningBufferingStreamSinkConduit pipelineBuffer;
    private HttpResponseConduit responseConduit;
    private ServerFixedLengthStreamSinkConduit fixedLengthStreamSinkConduit;
    private ReadDataStreamSourceConduit readDataStreamSourceConduit;
    private HttpUpgradeListener upgradeListener;

    public HttpServerConnection(StreamConnection channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        super(channel, bufferPool, rootHandler, undertowOptions, bufferSize);
        if (channel instanceof SslChannel) {
            this.sslSessionInfo = new ConnectionSSLSessionInfo((SslChannel)channel, this);
        }
        this.responseConduit = new HttpResponseConduit(channel.getSinkChannel().getConduit(), bufferPool);
        this.fixedLengthStreamSinkConduit = new ServerFixedLengthStreamSinkConduit((StreamSinkConduit)this.responseConduit, false, false);
        this.readDataStreamSourceConduit = new ReadDataStreamSourceConduit(channel.getSourceChannel().getConduit(), this);
        this.addCloseListener(new ServerConnection.CloseListener(){

            @Override
            public void closed(ServerConnection connection) {
                if (HttpServerConnection.this.getExtraBytes() != null) {
                    HttpServerConnection.this.getExtraBytes().free();
                }
                HttpServerConnection.this.responseConduit.freeBuffers();
            }
        });
    }

    @Override
    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        if (exchange == null || !HttpContinue.requiresContinueResponse(exchange)) {
            throw UndertowMessages.MESSAGES.outOfBandResponseOnlyAllowedFor100Continue();
        }
        final AbstractServerConnection.ConduitState state = this.resetChannel();
        HttpServerExchange newExchange = new HttpServerExchange(this);
        for (HttpString header : exchange.getRequestHeaders().getHeaderNames()) {
            newExchange.getRequestHeaders().putAll(header, exchange.getRequestHeaders().get(header));
        }
        newExchange.setProtocol(exchange.getProtocol());
        newExchange.setRequestMethod(exchange.getRequestMethod());
        exchange.setRequestURI(exchange.getRequestURI(), exchange.isHostIncludedInRequestURI());
        exchange.setRequestPath(exchange.getRequestPath());
        exchange.setRelativePath(exchange.getRelativePath());
        newExchange.getRequestHeaders().put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
        newExchange.getRequestHeaders().put(Headers.CONTENT_LENGTH, 0L);
        newExchange.setPersistent(true);
        Connectors.terminateRequest(newExchange);
        newExchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                ServerFixedLengthStreamSinkConduit fixed = new ServerFixedLengthStreamSinkConduit((StreamSinkConduit)new HttpResponseConduit(HttpServerConnection.this.getSinkChannel().getConduit(), HttpServerConnection.this.getBufferPool(), exchange), false, false);
                fixed.reset(0L, exchange);
                return fixed;
            }
        });
        this.channel.getSourceChannel().setConduit(HttpServerConnection.source(state));
        newExchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                HttpServerConnection.this.restoreChannel(state);
            }
        });
        return newExchange;
    }

    public void ungetRequestBytes(Pooled<ByteBuffer> unget) {
        if (this.getExtraBytes() == null) {
            this.setExtraBytes(unget);
        } else {
            Pooled<ByteBuffer> eb = this.getExtraBytes();
            ByteBuffer buf = (ByteBuffer)eb.getResource();
            ByteBuffer ugBuffer = (ByteBuffer)unget.getResource();
            if (ugBuffer.limit() - ugBuffer.remaining() > buf.remaining()) {
                ugBuffer.compact();
                ugBuffer.put(buf);
                ugBuffer.flip();
                eb.free();
                this.setExtraBytes(unget);
            } else {
                byte[] data = new byte[ugBuffer.remaining() + buf.remaining()];
                int first = ugBuffer.remaining();
                ugBuffer.get(data, 0, ugBuffer.remaining());
                buf.get(data, first, buf.remaining());
                eb.free();
                unget.free();
                ByteBuffer newBuffer = ByteBuffer.wrap(data);
                this.setExtraBytes(new ImmediatePooled<ByteBuffer>(newBuffer));
            }
        }
    }

    @Override
    public SSLSessionInfo getSslSessionInfo() {
        return this.sslSessionInfo;
    }

    @Override
    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        this.sslSessionInfo = sessionInfo;
    }

    public SSLSession getSslSession() {
        if (this.channel instanceof SslChannel) {
            return ((SslChannel)this.channel).getSslSession();
        }
        return null;
    }

    @Override
    protected StreamConnection upgradeChannel() {
        this.clearChannel();
        if (this.extraBytes != null) {
            this.channel.getSourceChannel().setConduit((StreamSourceConduit)new ReadDataStreamSourceConduit(this.channel.getSourceChannel().getConduit(), this));
        }
        return this.channel;
    }

    @Override
    protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
        return HttpTransferEncoding.createSinkConduit(exchange);
    }

    @Override
    protected boolean isUpgradeSupported() {
        return true;
    }

    void setReadListener(HttpReadListener readListener) {
        this.readListener = readListener;
    }

    @Override
    protected void exchangeComplete(HttpServerExchange exchange) {
        if (this.pipelineBuffer == null) {
            this.readListener.exchangeComplete(exchange);
        } else {
            this.pipelineBuffer.exchangeComplete(exchange);
        }
    }

    HttpReadListener getReadListener() {
        return this.readListener;
    }

    ReadDataStreamSourceConduit getReadDataStreamSourceConduit() {
        return this.readDataStreamSourceConduit;
    }

    public PipeliningBufferingStreamSinkConduit getPipelineBuffer() {
        return this.pipelineBuffer;
    }

    public HttpResponseConduit getResponseConduit() {
        return this.responseConduit;
    }

    ServerFixedLengthStreamSinkConduit getFixedLengthStreamSinkConduit() {
        return this.fixedLengthStreamSinkConduit;
    }

    protected HttpUpgradeListener getUpgradeListener() {
        return this.upgradeListener;
    }

    @Override
    protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    void setCurrentExchange(HttpServerExchange exchange) {
        this.current = exchange;
    }

    public void setPipelineBuffer(PipeliningBufferingStreamSinkConduit pipelineBuffer) {
        this.pipelineBuffer = pipelineBuffer;
        this.responseConduit = new HttpResponseConduit((StreamSinkConduit)pipelineBuffer, (Pool<ByteBuffer>)this.bufferPool);
        this.fixedLengthStreamSinkConduit = new ServerFixedLengthStreamSinkConduit((StreamSinkConduit)this.responseConduit, false, false);
    }
}

