/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.testutils;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xnio.Pool;
import org.xnio.Pooled;

public class DebuggingSlicePool
implements Pool<ByteBuffer> {
    static final Set<DebuggingBuffer> BUFFERS = Collections.newSetFromMap(new ConcurrentHashMap());
    static volatile String currentLabel;
    private final Pool<ByteBuffer> delegate;

    public DebuggingSlicePool(Pool<ByteBuffer> delegate) {
        this.delegate = delegate;
    }

    public Pooled<ByteBuffer> allocate() {
        Pooled delegate = this.delegate.allocate();
        return new DebuggingBuffer((Pooled<ByteBuffer>)delegate, currentLabel);
    }

    static class DebuggingBuffer
    implements Pooled<ByteBuffer> {
        private final RuntimeException allocationPoint;
        private final Pooled<ByteBuffer> delegate;
        private final String label;

        public DebuggingBuffer(Pooled<ByteBuffer> delegate, String label) {
            this.delegate = delegate;
            this.label = label;
            this.allocationPoint = new RuntimeException();
            BUFFERS.add(this);
        }

        public void discard() {
            BUFFERS.remove(this);
            this.delegate.discard();
        }

        public void free() {
            BUFFERS.remove(this);
            this.delegate.free();
        }

        public ByteBuffer getResource() throws IllegalStateException {
            return (ByteBuffer)this.delegate.getResource();
        }

        public void close() {
        }

        RuntimeException getAllocationPoint() {
            return this.allocationPoint;
        }

        String getLabel() {
            return this.label;
        }

        public String toString() {
            return "[debug]" + this.delegate.toString();
        }
    }
}

