/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.spdy.SpdyClientConnection;
import io.undertow.spdy.SpdyChannel;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class SpdyClientProvider
implements ClientProvider {
    private static final String PROTOCOL_KEY;
    private static final String SPDY_3 = "spdy/3";
    private static final String SPDY_3_1 = "spdy/3.1";
    private static final String HTTP_1_1 = "http/1.1";
    private static final Method NPN_PUT_METHOD;

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("spdy"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (NPN_PUT_METHOD == null) {
            listener.failed(UndertowMessages.MESSAGES.jettyNPNNotAvailable());
            return;
        }
        if (ssl == null) {
            listener.failed(UndertowMessages.MESSAGES.sslWasNull());
            return;
        }
        if (bindAddress == null) {
            ssl.openSslConnection(worker, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        } else {
            ssl.openSslConnection(worker, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        }
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (NPN_PUT_METHOD == null) {
            listener.failed(UndertowMessages.MESSAGES.jettyNPNNotAvailable());
            return;
        }
        if (ssl == null) {
            listener.failed(UndertowMessages.MESSAGES.sslWasNull());
            return;
        }
        if (bindAddress == null) {
            ssl.openSslConnection(ioThread, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        } else {
            ssl.openSslConnection(ioThread, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, uri, ssl, bufferPool, options), options).addNotifier(this.createNotifier(listener), null);
        }
    }

    private IoFuture.Notifier<StreamConnection, Object> createNotifier(final ClientCallback<ClientConnection> listener) {
        return new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
    }

    private ChannelListener<StreamConnection> createOpenListener(final ClientCallback<ClientConnection> listener, final URI uri, final XnioSsl ssl, final Pool<ByteBuffer> bufferPool, final OptionMap options) {
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                SpdyClientProvider.this.handleConnected(connection, listener, uri, ssl, (Pool<ByteBuffer>)bufferPool, options);
            }
        };
    }

    private void handleConnected(StreamConnection connection, final ClientCallback<ClientConnection> listener, URI uri, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        SpdyClientProvider.handlePotentialSpdyConnection(connection, listener, bufferPool, options, new ChannelListener<SslConnection>(){

            public void handleEvent(SslConnection channel) {
                listener.failed(UndertowMessages.MESSAGES.spdyNotSupported());
            }
        });
    }

    public static boolean isEnabled() {
        return NPN_PUT_METHOD != null;
    }

    public static void handlePotentialSpdyConnection(final StreamConnection connection, final ClientCallback<ClientConnection> listener, final Pool<ByteBuffer> bufferPool, OptionMap options, final ChannelListener<SslConnection> spdyFailedListener) {
        final SslConnection sslConnection = (SslConnection)connection;
        SSLEngine sslEngine = JsseXnioSsl.getSslEngine((SslConnection)sslConnection);
        String existing = (String)sslEngine.getSession().getValue(PROTOCOL_KEY);
        if (existing != null) {
            if (existing.equals(SPDY_3) || existing.equals(SPDY_3_1)) {
                listener.completed(SpdyClientProvider.createSpdyChannel(connection, bufferPool));
            } else {
                sslConnection.getSourceChannel().suspendReads();
                spdyFailedListener.handleEvent((Channel)sslConnection);
            }
        } else {
            final SpdySelectionProvider spdySelectionProvider = new SpdySelectionProvider(sslEngine);
            try {
                NPN_PUT_METHOD.invoke(null, sslEngine, spdySelectionProvider);
            }
            catch (Exception e) {
                spdyFailedListener.handleEvent((Channel)sslConnection);
                return;
            }
            try {
                sslConnection.startHandshake();
                sslConnection.getSourceChannel().getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                    public void handleEvent(StreamSourceChannel channel) {
                        if (spdySelectionProvider.selected != null) {
                            if (spdySelectionProvider.selected.equals(SpdyClientProvider.HTTP_1_1)) {
                                sslConnection.getSourceChannel().suspendReads();
                                spdyFailedListener.handleEvent((Channel)sslConnection);
                                return;
                            }
                            if (spdySelectionProvider.selected.equals(SpdyClientProvider.SPDY_3) || spdySelectionProvider.selected.equals(SpdyClientProvider.SPDY_3_1)) {
                                listener.completed(SpdyClientProvider.createSpdyChannel(connection, (Pool<ByteBuffer>)bufferPool));
                            }
                        } else {
                            ByteBuffer buf = ByteBuffer.allocate(100);
                            try {
                                int read = channel.read(buf);
                                if (read > 0) {
                                    PushBackStreamSourceConduit pb = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
                                    pb.pushBack(new ImmediatePooled<ByteBuffer>(buf));
                                    connection.getSourceChannel().setConduit((StreamSourceConduit)pb);
                                }
                                if (spdySelectionProvider.selected == null && read > 0 || SpdyClientProvider.HTTP_1_1.equals(spdySelectionProvider.selected)) {
                                    sslConnection.getSourceChannel().suspendReads();
                                    spdyFailedListener.handleEvent((Channel)sslConnection);
                                    return;
                                }
                                if (spdySelectionProvider.selected != null && (spdySelectionProvider.selected.equals(SpdyClientProvider.SPDY_3) || spdySelectionProvider.selected.equals(SpdyClientProvider.SPDY_3_1))) {
                                    listener.completed(SpdyClientProvider.createSpdyChannel(connection, (Pool<ByteBuffer>)bufferPool));
                                }
                            }
                            catch (IOException e) {
                                listener.failed(e);
                            }
                        }
                    }
                });
                sslConnection.getSourceChannel().resumeReads();
            }
            catch (IOException e) {
                listener.failed(e);
            }
        }
    }

    private static SpdyClientConnection createSpdyChannel(StreamConnection connection, Pool<ByteBuffer> bufferPool) {
        SpdyChannel spdyChannel = new SpdyChannel(connection, bufferPool, null, (Pool<ByteBuffer>)new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, 8192, 8192), true);
        return new SpdyClientConnection(spdyChannel);
    }

    static {
        Method npnPutMethod;
        PROTOCOL_KEY = SpdyClientProvider.class.getName() + ".protocol";
        try {
            Class<?> npnClass = SpdyClientProvider.class.getClassLoader().loadClass("org.eclipse.jetty.npn.NextProtoNego");
            npnPutMethod = npnClass.getDeclaredMethod("put", SSLEngine.class, SpdyClientProvider.class.getClassLoader().loadClass("org.eclipse.jetty.npn.NextProtoNego$Provider"));
        }
        catch (Exception e) {
            UndertowLogger.CLIENT_LOGGER.jettyNpnNotFound();
            npnPutMethod = null;
        }
        NPN_PUT_METHOD = npnPutMethod;
    }

    private static class SpdySelectionProvider
    implements NextProtoNego.ClientProvider {
        private String selected;
        private final SSLEngine sslEngine;

        private SpdySelectionProvider(SSLEngine sslEngine) {
            this.sslEngine = sslEngine;
        }

        public boolean supports() {
            return true;
        }

        public void unsupported() {
            this.selected = SpdyClientProvider.HTTP_1_1;
        }

        public String selectProtocol(List<String> protocols) {
            NextProtoNego.remove((SSLEngine)this.sslEngine);
            this.selected = protocols.contains(SpdyClientProvider.SPDY_3_1) ? SpdyClientProvider.SPDY_3_1 : (protocols.contains(SpdyClientProvider.SPDY_3) ? SpdyClientProvider.SPDY_3 : SpdyClientProvider.HTTP_1_1);
            this.sslEngine.getSession().putValue(PROTOCOL_KEY, this.selected);
            return this.selected;
        }

        private String getSelected() {
            return this.selected;
        }
    }
}

