/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class ModClusterTestSetup {
    static String chost = System.getProperty("io.undertow.examples.proxy.CADDRESS", "localhost");
    static final int cport = Integer.parseInt(System.getProperty("io.undertow.examples.proxy.CPORT", "6666"));
    static String phost = System.getProperty("io.undertow.examples.proxy.ADDRESS", "localhost");
    static final int pport = Integer.parseInt(System.getProperty("io.undertow.examples.proxy.PORT", "8000"));

    public static void main(String[] args) {
        final ModCluster modCluster = ModCluster.builder().setHealthCheckInterval(TimeUnit.SECONDS.toMillis(3L)).setRemoveBrokenNodes(TimeUnit.SECONDS.toMillis(30L)).build();
        try {
            if (chost == null) {
                chost = InetAddress.getLocalHost().getHostName();
                System.out.println("Using: " + chost + ":" + cport);
            }
            modCluster.start();
            HttpHandler proxy = modCluster.getProxyHandler();
            MCMPConfig config = MCMPConfig.builder().setManagementHost(chost).setManagementPort(cport).enableAdvertise().setSecurityKey("secret").getParent().build();
            MCMPConfig webConfig = MCMPConfig.webBuilder().setManagementHost(chost).setManagementPort(cport).build();
            HttpHandler mcmp = config.create(modCluster, proxy);
            HttpHandler web = webConfig.create(modCluster, (HttpHandler)ResponseCodeHandler.HANDLE_404);
            final Undertow server = Undertow.builder().addHttpListener(cport, chost).addHttpListener(pport, phost).setHandler((HttpHandler)Handlers.path((HttpHandler)mcmp).addPrefixPath("/mod_cluster_manager", web)).build();
            server.start();
            modCluster.advertise(config);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    modCluster.stop();
                    server.stop();
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(r));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

