/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.mod_cluster.AbstractModClusterTestBase;
import io.undertow.server.handlers.proxy.mod_cluster.NodeTestConfig;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class StickySessionUnitTestCase
extends AbstractModClusterTestBase {
    static NodeTestConfig server1 = NodeTestConfig.builder().setJvmRoute("server1").setType("ajp").setHostname("localhost").setPort(port + 1);
    static NodeTestConfig server2 = NodeTestConfig.builder().setJvmRoute("server2").setType("http").setHostname("localhost").setPort(port + 2);

    @BeforeClass
    public static void setup() {
        StickySessionUnitTestCase.startServers(server1, server2);
    }

    @AfterClass
    public static void tearDown() {
        StickySessionUnitTestCase.stopServers();
    }

    @Test
    public void testDisabledApp() throws IOException {
        this.registerNodes(true, server1, server2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        String jvmRoute = response.startsWith(server1.getJvmRoute()) ? server1.getJvmRoute() : server2.getJvmRoute();
        modClusterClient.disableApp(jvmRoute, SESSION);
        for (int i = 0; i < 20; ++i) {
            StickySessionUnitTestCase.checkGet("/session", 200, jvmRoute).startsWith(jvmRoute);
        }
    }

    @Test
    public void testNoDomainRemovedContext() throws IOException {
        this.registerNodes(true, server1, server2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.removeApp(server1.getJvmRoute(), SESSION);
        } else {
            modClusterClient.removeApp(server2.getJvmRoute(), SESSION);
        }
        StickySessionUnitTestCase.checkGet("/session", 503);
    }

    @Test
    public void testNoDomainStoppedContext() throws IOException {
        this.registerNodes(true, server1, server2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.stopApp(server1.getJvmRoute(), SESSION);
        } else {
            modClusterClient.stopApp(server2.getJvmRoute(), SESSION);
        }
        StickySessionUnitTestCase.checkGet("/session", 503);
    }

    @Test
    public void testNoDomainNodeInError() throws IOException {
        this.registerNodes(true, server1, server2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.updateLoad(server1.getJvmRoute(), -1);
        } else {
            modClusterClient.updateLoad(server2.getJvmRoute(), -1);
        }
        StickySessionUnitTestCase.checkGet("/session", 503);
    }

    @Test
    public void testDifferentDomainRemovedContext() throws IOException {
        NodeTestConfig config1 = server1.clone().setDomain("domain1");
        NodeTestConfig config2 = server2.clone().setDomain("domain2");
        this.registerNodes(true, config1, config2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.removeApp(server1.getJvmRoute(), SESSION);
        } else {
            modClusterClient.removeApp(server2.getJvmRoute(), SESSION);
        }
        StickySessionUnitTestCase.checkGet("/session", 503);
    }

    @Test
    public void testDifferentDomainStoppedContext() throws IOException {
        NodeTestConfig config1 = server1.clone().setDomain("domain1");
        NodeTestConfig config2 = server2.clone().setDomain("domain2");
        this.registerNodes(true, config1, config2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.stopApp(server1.getJvmRoute(), SESSION);
        } else {
            modClusterClient.stopApp(server2.getJvmRoute(), SESSION);
        }
        StickySessionUnitTestCase.checkGet("/session", 503);
    }

    @Test
    public void testDifferentDomainNodeInError() throws IOException {
        NodeTestConfig config1 = server1.clone().setDomain("domain1");
        NodeTestConfig config2 = server2.clone().setDomain("domain2");
        this.registerNodes(true, config1, config2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.updateLoad(server1.getJvmRoute(), -1);
        } else {
            modClusterClient.updateLoad(server2.getJvmRoute(), -1);
        }
        StickySessionUnitTestCase.checkGet("/session", 503);
    }

    @Test
    public void testDomainStoppedContext() throws IOException {
        NodeTestConfig config1 = server1.clone().setDomain("domain1");
        NodeTestConfig config2 = server2.clone().setDomain("domain1");
        this.registerNodes(true, config1, config2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.stopApp(server1.getJvmRoute(), SESSION);
        } else {
            modClusterClient.stopApp(server2.getJvmRoute(), SESSION);
        }
        StickySessionUnitTestCase.checkGet("/session", 200);
    }

    @Test
    public void testDomainRemovedContext() throws IOException {
        NodeTestConfig config1 = server1.clone().setDomain("domain1");
        NodeTestConfig config2 = server2.clone().setDomain("domain1");
        this.registerNodes(true, config1, config2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.removeApp(server1.getJvmRoute(), SESSION);
        } else {
            modClusterClient.removeApp(server2.getJvmRoute(), SESSION);
        }
        StickySessionUnitTestCase.checkGet("/session", 200);
    }

    @Test
    public void testDomainNodeInError() throws IOException {
        NodeTestConfig config1 = server1.clone().setDomain("domain1");
        NodeTestConfig config2 = server2.clone().setDomain("domain1");
        this.registerNodes(true, config1, config2);
        modClusterClient.enableApp(server1.getJvmRoute(), SESSION);
        modClusterClient.enableApp(server2.getJvmRoute(), SESSION);
        String response = StickySessionUnitTestCase.checkGet("/session", 200);
        if (response.startsWith(server1.getJvmRoute())) {
            modClusterClient.updateLoad(server1.getJvmRoute(), -1);
        } else {
            modClusterClient.updateLoad(server2.getJvmRoute(), -1);
        }
        StickySessionUnitTestCase.checkGet("/session", 200);
    }
}

