/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowMessages;
import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2DataFrameParser;
import io.undertow.protocols.http2.Http2GoAwayParser;
import io.undertow.protocols.http2.Http2HeadersParser;
import io.undertow.protocols.http2.Http2PingParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import io.undertow.protocols.http2.Http2RstStreamParser;
import io.undertow.protocols.http2.Http2SettingsParser;
import io.undertow.protocols.http2.Http2WindowUpdateParser;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Bits;

class Http2FrameHeaderParser
implements FrameHeaderData {
    final byte[] header = new byte[9];
    int read = 0;
    int length;
    int type;
    int flags;
    int streamId;
    Http2PushBackParser parser = null;
    private static final int SECOND_RESERVED_MASK = -129;
    private Http2Channel http2Channel;

    public Http2FrameHeaderParser(Http2Channel http2Channel) {
        this.http2Channel = http2Channel;
    }

    public boolean handle(ByteBuffer byteBuffer) throws IOException {
        if (this.parser == null) {
            if (!this.parseFrameHeader(byteBuffer)) {
                return false;
            }
            switch (this.type) {
                case 0: {
                    this.parser = new Http2DataFrameParser(this.length);
                    break;
                }
                case 1: {
                    this.parser = new Http2HeadersParser(this.length, this.http2Channel.getDecoder());
                    break;
                }
                case 3: {
                    this.parser = new Http2RstStreamParser(this.length);
                    break;
                }
                case 9: {
                    throw new RuntimeException("NYI");
                }
                case 5: {
                    throw new RuntimeException("NYI");
                }
                case 7: {
                    this.parser = new Http2GoAwayParser(this.length);
                    break;
                }
                case 6: {
                    if (this.length != 8) {
                        throw new ConnectionErrorException(6, UndertowMessages.MESSAGES.invalidPingSize());
                    }
                    if (this.streamId != 0) {
                        throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustBeZeroForFrameType(6));
                    }
                    this.parser = new Http2PingParser(this.length);
                    break;
                }
                case 4: {
                    this.parser = new Http2SettingsParser(this.length);
                    break;
                }
                case 8: {
                    this.parser = new Http2WindowUpdateParser(this.length);
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        this.parser.parse(byteBuffer, this);
        return this.parser.isFinished();
    }

    private boolean parseFrameHeader(ByteBuffer byteBuffer) {
        while (this.read < 9 && byteBuffer.hasRemaining()) {
            this.header[this.read++] = byteBuffer.get();
        }
        if (this.read != 9) {
            return false;
        }
        this.length = (this.header[0] & 0xFF) << 16;
        this.length += (this.header[1] & 0xFF) << 8;
        this.length += this.header[2] & 0xFF;
        this.type = this.header[3] & 0xFF;
        this.flags = this.header[4] & 0xFF;
        this.streamId = (this.header[5] & 0xFFFFFF7F & 0xFF) << 24;
        this.streamId += (this.header[6] & 0xFF) << 16;
        this.streamId += (this.header[7] & 0xFF) << 8;
        this.streamId += this.header[8] & 0xFF;
        return true;
    }

    @Override
    public long getFrameLength() {
        if (this.type != 0) {
            return 0L;
        }
        return this.length;
    }

    @Override
    public AbstractFramedStreamSourceChannel<?, ?, ?> getExistingChannel() {
        if (this.type == 0 || this.type == 1 || this.type == 9 || this.type == 2) {
            if (Bits.anyAreSet((int)this.flags, (int)1)) {
                return this.http2Channel.getIncomingStreams().remove(this.streamId);
            }
            return this.http2Channel.getIncomingStreams().get(this.streamId);
        }
        return null;
    }
}

