/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;

class MCMPAdvertiseTask
implements Runnable {
    public static final String RFC_822_FMT = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    private static final boolean linuxLike;
    private volatile int seq = 0;
    private final String protocol;
    private final String host;
    private final int port;
    private final String path;
    private final byte[] ssalt;
    private final MessageDigest md;
    private final MulticastSocket socket;
    private final InetSocketAddress address;
    private final ModClusterContainer container;
    private static final String CRLF = "\r\n";
    private static final char[] TABLE;

    MCMPAdvertiseTask(ModClusterContainer container, MCMPConfig.AdvertiseConfig config) {
        this.container = container;
        this.protocol = config.getProtocol();
        this.host = config.getManagementHost();
        this.port = config.getManagementPort();
        this.path = config.getPath();
        try {
            InetAddress group = InetAddress.getByName(config.getAdvertiseGroup());
            this.address = group == null && linuxLike ? new InetSocketAddress(config.getAdvertisePort()) : new InetSocketAddress(group, config.getAdvertisePort());
            this.socket = new MulticastSocket(this.address);
            this.socket.setTimeToLive(29);
            this.socket.joinGroup(group);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String securityKey = config.getSecurityKey();
        if (securityKey == null) {
            this.ssalt = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        } else {
            this.md.reset();
            this.digestString(this.md, securityKey);
            this.ssalt = this.md.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] digest;
            byte[] ssalt = this.ssalt;
            String server = this.container.getServerID();
            String date = DATE_FORMAT.format(new Date(System.currentTimeMillis()));
            String seq = "" + this.seq++;
            MessageDigest messageDigest = this.md;
            synchronized (messageDigest) {
                this.md.reset();
                this.md.update(ssalt);
                this.digestString(this.md, date);
                this.digestString(this.md, seq);
                this.digestString(this.md, server);
                digest = this.md.digest();
            }
            String digestString = MCMPAdvertiseTask.bytesToHexString(digest);
            StringBuilder builder = new StringBuilder();
            builder.append("HTTP/1.0 200 OK").append(CRLF).append("Date: ").append(date).append(CRLF).append("Sequence: ").append(seq).append(CRLF).append("Digest: ").append(digestString).append(CRLF).append("Server: ").append(server).append(CRLF).append("X-Manager-Address: ").append(this.host).append(":").append(this.port).append(CRLF).append("X-Manager-Url: ").append(this.path).append(CRLF).append("X-Manager-Protocol: ").append(this.protocol).append(CRLF).append("X-Manager-Host: ").append(this.host).append(CRLF);
            String payload = builder.toString();
            byte[] buf = payload.getBytes();
            DatagramPacket data = new DatagramPacket(buf, buf.length, this.address);
            this.socket.send(data);
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
    }

    private void digestString(MessageDigest md, String securityKey) {
        byte[] buf = securityKey.getBytes();
        md.update(buf);
    }

    static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(TABLE[b >> 4 & 0xF]).append(TABLE[b & 0xF]);
        }
        return builder.toString();
    }

    static {
        String value = System.getProperty("os.name");
        linuxLike = value != null && (value.toLowerCase().startsWith("linux") || value.toLowerCase().startsWith("mac") || value.toLowerCase().startsWith("hp"));
        TABLE = "0123456789abcdef".toCharArray();
    }
}

