/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy.mod_cluster;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.mod_cluster.Context;
import io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import io.undertow.server.handlers.proxy.mod_cluster.Node;
import io.undertow.server.handlers.proxy.mod_cluster.VirtualHost;

public interface ModClusterProxyTarget
extends ProxyClient.ProxyTarget {
    public Node findNode(HttpServerExchange var1);

    public static class BasicTarget
    implements ModClusterProxyTarget {
        private final VirtualHost.HostEntry entry;
        private final ModClusterContainer container;

        public BasicTarget(VirtualHost.HostEntry entry, ModClusterContainer container) {
            this.entry = entry;
            this.container = container;
        }

        @Override
        public Node findNode(HttpServerExchange exchange) {
            return this.container.findNewNode(this.entry);
        }
    }

    public static class ExistingSessionTarget
    implements ModClusterProxyTarget {
        private final String jvmRoute;
        private final VirtualHost.HostEntry entry;
        private final boolean forceStickySession;
        private final ModClusterContainer container;

        public ExistingSessionTarget(String jvmRoute, VirtualHost.HostEntry entry, ModClusterContainer container, boolean forceStickySession) {
            this.jvmRoute = jvmRoute;
            this.entry = entry;
            this.container = container;
            this.forceStickySession = forceStickySession;
        }

        @Override
        public Node findNode(HttpServerExchange exchange) {
            Context context = this.entry.getContextForNode(this.jvmRoute);
            if (context != null && context.checkAvailable(true)) {
                Node node = context.getNode();
                node.elected();
                return node;
            }
            String domain = context != null ? context.getNode().getNodeConfig().getDomain() : null;
            return this.container.findFailoverNode(this.entry, domain, this.jvmRoute, this.forceStickySession);
        }
    }
}

