/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.spdy;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyPingStreamSourceChannel;
import io.undertow.protocols.spdy.SpdyStreamSourceChannel;
import io.undertow.protocols.spdy.SpdySynReplyStreamSinkChannel;
import io.undertow.protocols.spdy.SpdySynStreamStreamSourceChannel;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.spdy.SpdyServerConnection;
import io.undertow.server.protocol.spdy.SpdySslSessionInfo;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.URLUtils;
import java.io.Closeable;
import java.io.IOException;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class SpdyReceiveListener
implements ChannelListener<SpdyChannel> {
    private static final HttpString METHOD = new HttpString(":method");
    private static final HttpString PATH = new HttpString(":path");
    private static final HttpString SCHEME = new HttpString(":scheme");
    private static final HttpString VERSION = new HttpString(":version");
    private static final HttpString HOST = new HttpString(":host");
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final boolean decode;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean allowEncodingSlash;
    private final int bufferSize;

    public SpdyReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.allowEncodingSlash = undertowOptions.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        this.decode = undertowOptions.get(UndertowOptions.DECODE_URL, true);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? (String)undertowOptions.get(UndertowOptions.URL_CHARSET, (Object)"UTF-8") : null;
    }

    public void handleEvent(SpdyChannel channel) {
        try {
            SpdyStreamSourceChannel frame = (SpdyStreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof SpdyPingStreamSourceChannel) {
                this.handlePing((SpdyPingStreamSourceChannel)frame);
            } else if (frame instanceof SpdySynStreamStreamSourceChannel) {
                SpdySynStreamStreamSourceChannel dataChannel = (SpdySynStreamStreamSourceChannel)frame;
                SpdyServerConnection connection = new SpdyServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize);
                final HttpServerExchange exchange = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
                dataChannel.setMaxStreamSize(this.maxEntitySize);
                exchange.setRequestScheme(exchange.getRequestHeaders().getFirst(SCHEME));
                exchange.setProtocol(new HttpString(exchange.getRequestHeaders().getFirst(VERSION)));
                exchange.setRequestMethod(new HttpString(exchange.getRequestHeaders().getFirst(METHOD)));
                exchange.getRequestHeaders().put(Headers.HOST, exchange.getRequestHeaders().getFirst(HOST));
                String path = exchange.getRequestHeaders().getFirst(PATH);
                this.setRequestPath(exchange, path, this.encoding, this.allowEncodingSlash, this.decodeBuffer);
                SSLSession session = channel.getSslSession();
                if (session != null) {
                    connection.setSslSessionInfo(new SpdySslSessionInfo(channel));
                }
                dataChannel.getResponseChannel().setCompletionListener(new ChannelListener<SpdySynReplyStreamSinkChannel>(){

                    public void handleEvent(SpdySynReplyStreamSinkChannel channel) {
                        Connectors.terminateResponse(exchange);
                    }
                });
                if (!dataChannel.isOpen()) {
                    Connectors.terminateRequest(exchange);
                } else {
                    dataChannel.setCompletionListener(new ChannelListener<SpdySynStreamStreamSourceChannel>(){

                        public void handleEvent(SpdySynStreamStreamSourceChannel channel) {
                            Connectors.terminateRequest(exchange);
                        }
                    });
                }
                Connectors.executeRootHandler(this.rootHandler, exchange);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)((Object)channel));
        }
    }

    private void handlePing(SpdyPingStreamSourceChannel frame) {
        int id = frame.getId();
        if (id % 2 == 1) {
            frame.getSpdyChannel().sendPing(id);
        }
    }

    private void setRequestPath(HttpServerExchange exchange, String encodedPath, String charset, boolean allowEncodedSlash, StringBuilder decodeBuffer) {
        boolean requiresDecode = false;
        for (int i = 0; i < encodedPath.length(); ++i) {
            char c = encodedPath.charAt(i);
            if (c == '?') {
                String encodedPart = encodedPath.substring(0, i);
                String part = requiresDecode ? URLUtils.decode(encodedPart, charset, allowEncodedSlash, decodeBuffer) : encodedPart;
                exchange.setRequestPath(part);
                exchange.setRelativePath(part);
                exchange.setRequestURI(encodedPart);
                String qs = encodedPath.substring(i + 1);
                exchange.setQueryString(qs);
                URLUtils.parseQueryString(qs, exchange, this.encoding, this.decode);
                return;
            }
            if (c == ';') {
                String encodedPart = encodedPath.substring(0, i);
                String part = requiresDecode ? URLUtils.decode(encodedPart, charset, allowEncodedSlash, decodeBuffer) : encodedPart;
                exchange.setRequestPath(part);
                exchange.setRelativePath(part);
                exchange.setRequestURI(encodedPart);
                for (int j = i; j < encodedPath.length(); ++j) {
                    if (encodedPath.charAt(j) != '?') continue;
                    String pathParams = encodedPath.substring(i + 1, j);
                    URLUtils.parsePathParms(pathParams, exchange, this.encoding, this.decode);
                    String qs = encodedPath.substring(j + 1);
                    exchange.setQueryString(qs);
                    URLUtils.parseQueryString(qs, exchange, this.encoding, this.decode);
                    return;
                }
                URLUtils.parsePathParms(encodedPath.substring(i + 1), exchange, this.encoding, this.decode);
                return;
            }
            if (c != '%' && c != '+') continue;
            requiresDecode = true;
        }
        String part = requiresDecode ? URLUtils.decode(encodedPath, charset, allowEncodedSlash, decodeBuffer) : encodedPath;
        exchange.setRequestPath(part);
        exchange.setRelativePath(part);
        exchange.setRequestURI(encodedPath);
    }
}

