/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.protocols.http2.AbstractHttp2StreamSinkChannel;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackEncoder;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2FramePriority;
import io.undertow.protocols.http2.Http2GoAwayParser;
import io.undertow.protocols.http2.Http2GoAwayStreamSinkChannel;
import io.undertow.protocols.http2.Http2GoAwayStreamSourceChannel;
import io.undertow.protocols.http2.Http2HeadersParser;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingParser;
import io.undertow.protocols.http2.Http2PingStreamSinkChannel;
import io.undertow.protocols.http2.Http2PingStreamSourceChannel;
import io.undertow.protocols.http2.Http2PrefaceStreamSinkChannel;
import io.undertow.protocols.http2.Http2RstStreamParser;
import io.undertow.protocols.http2.Http2RstStreamSinkChannel;
import io.undertow.protocols.http2.Http2RstStreamStreamSourceChannel;
import io.undertow.protocols.http2.Http2Setting;
import io.undertow.protocols.http2.Http2SettingsParser;
import io.undertow.protocols.http2.Http2SettingsStreamSinkChannel;
import io.undertow.protocols.http2.Http2SettingsStreamSourceChannel;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.protocols.http2.Http2WindowUpdateParser;
import io.undertow.protocols.http2.Http2WindowUpdateStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSinkChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.FrameHeaderData;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLSession;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.ssl.SslConnection;

public class Http2Channel
extends AbstractFramedChannel<Http2Channel, AbstractHttp2StreamSourceChannel, AbstractHttp2StreamSinkChannel>
implements Attachable {
    public static final String CLEARTEXT_UPGRADE_STRING = "h2c-14";
    public static final String SSL_UPGRADE_STRING = "h2-14";
    static final int FRAME_TYPE_DATA = 0;
    static final int FRAME_TYPE_HEADERS = 1;
    static final int FRAME_TYPE_PRIORITY = 2;
    static final int FRAME_TYPE_RST_STREAM = 3;
    static final int FRAME_TYPE_SETTINGS = 4;
    static final int FRAME_TYPE_PUSH_PROMISE = 5;
    static final int FRAME_TYPE_PING = 6;
    static final int FRAME_TYPE_GOAWAY = 7;
    static final int FRAME_TYPE_WINDOW_UPDATE = 8;
    static final int FRAME_TYPE_CONTINUATION = 9;
    static final int ERROR_NO_ERROR = 0;
    static final int ERROR_PROTOCOL_ERROR = 1;
    static final int ERROR_INTERNAL_ERROR = 2;
    static final int ERROR_FLOW_CONTROL_ERROR = 3;
    static final int ERROR_SETTINGS_TIMEOUT = 4;
    static final int ERROR_STREAM_CLOSED = 5;
    static final int ERROR_FRAME_SIZE_ERROR = 6;
    static final int ERROR_REFUSED_STREAM = 7;
    static final int ERROR_CANCEL = 8;
    static final int ERROR_COMPRESSION_ERROR = 9;
    static final int ERROR_CONNECT_ERROR = 10;
    static final int ERROR_ENHANCE_YOUR_CALM = 11;
    static final int ERROR_INADEQUATE_SECURITY = 12;
    static final int DATA_FLAG_END_STREAM = 1;
    static final int DATA_FLAG_END_SEGMENT = 2;
    static final int DATA_FLAG_PADDED = 8;
    static final int PING_FRAME_LENGTH = 8;
    static final int PING_FLAG_ACK = 1;
    static final int HEADERS_FLAG_END_STREAM = 1;
    static final int HEADERS_FLAG_END_SEGMENT = 2;
    static final int HEADERS_FLAG_END_HEADERS = 4;
    static final int HEADERS_FLAG_PADDED = 8;
    static final int HEADERS_FLAG_PRIORITY = 32;
    static final int SETTINGS_FLAG_ACK = 1;
    static final int CONTINUATION_FLAG_END_HEADERS = 4;
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    public static final byte[] PREFACE_BYTES = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    public static final int DEFAULT_MAX_FRAME_SIZE = 0xFFFFFF;
    private Http2FrameHeaderParser frameParser;
    private final Map<Integer, Http2StreamSourceChannel> incomingStreams = new ConcurrentHashMap<Integer, Http2StreamSourceChannel>();
    private final Map<Integer, Http2StreamSinkChannel> outgoingStreams = new ConcurrentHashMap<Integer, Http2StreamSinkChannel>();
    private int encoderHeaderTableSize;
    private boolean enablePush = true;
    private volatile int initialSendWindowSize = 65535;
    private volatile int initialReceiveWindowSize = 65535;
    private int maxConcurrentStreams = -1;
    private int sendMaxFrameSize = 0xFFFFFF;
    private int receiveMaxFrameSize = 0xFFFFFF;
    private int maxHeaderListSize = -1;
    private volatile int receiveWindowSize = this.initialReceiveWindowSize;
    private volatile int sendWindowSize = this.initialSendWindowSize;
    private boolean thisGoneAway = false;
    private boolean peerGoneAway = false;
    private int streamIdCounter;
    private int lastGoodStreamId;
    private final HpackDecoder decoder;
    private final HpackEncoder encoder;
    private int prefaceCount;
    private boolean initialSettingsReceived;
    private Http2HeadersParser continuationParser = null;
    private final Map<AttachmentKey<?>, Object> attachments = Collections.synchronizedMap(new HashMap());

    public Http2Channel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, Pooled<ByteBuffer> data, boolean clientSide, boolean fromUpgrade, OptionMap settings) {
        this(connectedStreamChannel, bufferPool, data, clientSide, fromUpgrade, null, settings);
    }

    public Http2Channel(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, Pooled<ByteBuffer> data, boolean clientSide, boolean fromUpgrade, ByteBuffer initialOtherSideSettings, OptionMap settings) {
        super(connectedStreamChannel, bufferPool, Http2FramePriority.INSTANCE, data);
        int n = clientSide ? (fromUpgrade ? 3 : 1) : (this.streamIdCounter = 2);
        if (initialOtherSideSettings != null) {
            Http2SettingsParser parser = new Http2SettingsParser(initialOtherSideSettings.remaining());
            try {
                parser.parse(initialOtherSideSettings, new Http2FrameHeaderParser(this, null));
                this.updateSettings(parser.getSettings());
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)connectedStreamChannel);
                throw new RuntimeException(e);
            }
        }
        this.encoderHeaderTableSize = settings.get(UndertowOptions.HTTP2_SETTINGS_HEADER_TABLE_SIZE, 4096);
        this.enablePush = settings.get(UndertowOptions.HTTP2_SETTINGS_ENABLE_PUSH, true);
        this.receiveMaxFrameSize = settings.get(UndertowOptions.HTTP2_SETTINGS_MAX_FRAME_SIZE, 0xFFFFFF);
        this.decoder = new HpackDecoder(4096);
        this.encoder = new HpackEncoder(this.encoderHeaderTableSize);
        if (clientSide) {
            this.sendPreface();
            this.prefaceCount = PREFACE_BYTES.length;
        }
        this.sendSettings();
    }

    private void sendSettings() {
        ArrayList<Http2Setting> settings = new ArrayList<Http2Setting>();
        settings.add(new Http2Setting(1, this.encoderHeaderTableSize));
        settings.add(new Http2Setting(2, this.enablePush ? 1 : 0));
        settings.add(new Http2Setting(5, this.receiveMaxFrameSize));
        Http2SettingsStreamSinkChannel stream = new Http2SettingsStreamSinkChannel(this, settings);
        this.flushChannel(stream);
    }

    private void sendSettingsAck() {
        Http2SettingsStreamSinkChannel stream = new Http2SettingsStreamSinkChannel(this);
        this.flushChannel(stream);
    }

    private void flushChannel(StreamSinkChannel stream) {
        try {
            stream.shutdownWrites();
            if (!stream.flush()) {
                stream.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, this.writeExceptionHandler()));
                stream.resumeWrites();
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
    }

    private void sendPreface() {
        Http2PrefaceStreamSinkChannel preface = new Http2PrefaceStreamSinkChannel(this);
        this.flushChannel(preface);
    }

    @Override
    protected AbstractHttp2StreamSourceChannel createChannel(FrameHeaderData frameHeaderData, Pooled<ByteBuffer> frameData) throws IOException {
        AbstractHttp2StreamSourceChannel channel;
        Http2FrameHeaderParser frameParser = (Http2FrameHeaderParser)frameHeaderData;
        if (frameParser.type == 0) {
            if (frameParser.streamId == 0) {
                this.sendGoAway(1);
            } else {
                this.sendRstStream(frameParser.streamId, 5);
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Dropping Frame of length %s for stream %s", frameParser.getFrameLength(), frameParser.streamId);
            return null;
        }
        switch (frameParser.type) {
            case 1: 
            case 9: {
                Http2HeadersParser parser = (Http2HeadersParser)frameParser.parser;
                channel = new Http2StreamSourceChannel(this, frameData, frameHeaderData.getFrameLength(), parser.getHeaderMap(), frameParser.streamId);
                this.lastGoodStreamId = Math.max(this.lastGoodStreamId, frameParser.streamId);
                this.incomingStreams.put(frameParser.streamId, (Http2StreamSourceChannel)channel);
                if (!parser.isHeadersEndStream() || !Bits.allAreSet((int)frameParser.flags, (int)4)) break;
                channel.lastFrame();
                break;
            }
            case 3: {
                Http2RstStreamParser parser = (Http2RstStreamParser)frameParser.parser;
                if (frameParser.streamId == 0) {
                    throw new ConnectionErrorException(1, UndertowMessages.MESSAGES.streamIdMustNotBeZeroForFrameType(3));
                }
                channel = new Http2RstStreamStreamSourceChannel(this, frameData, parser.getErrorCode(), frameParser.streamId);
                this.handleRstStream(frameParser.streamId);
                break;
            }
            case 4: {
                if (!Bits.anyAreSet((int)frameParser.flags, (int)1)) {
                    this.updateSettings(((Http2SettingsParser)frameParser.parser).getSettings());
                    this.sendSettingsAck();
                }
                channel = new Http2SettingsStreamSourceChannel(this, frameData, frameParser.getFrameLength(), ((Http2SettingsParser)frameParser.parser).getSettings());
                break;
            }
            case 6: {
                Http2PingParser pingParser = (Http2PingParser)frameParser.parser;
                frameData.free();
                channel = new Http2PingStreamSourceChannel(this, pingParser.getData(), Bits.anyAreSet((int)frameParser.flags, (int)1));
                break;
            }
            case 7: {
                Http2GoAwayParser spdyGoAwayParser = (Http2GoAwayParser)frameParser.parser;
                channel = new Http2GoAwayStreamSourceChannel(this, frameData, frameParser.getFrameLength(), spdyGoAwayParser.getStatusCode(), spdyGoAwayParser.getLastGoodStreamId());
                this.peerGoneAway = true;
                break;
            }
            case 8: {
                Http2WindowUpdateParser parser = (Http2WindowUpdateParser)frameParser.parser;
                this.handleWindowUpdate(frameParser.streamId, parser.getDeltaWindowSize());
                frameData.free();
                return null;
            }
            default: {
                UndertowLogger.REQUEST_LOGGER.tracef("Dropping frame of length %s and type %s for stream %s as we do not understand this type of frame", frameParser.getFrameLength(), frameParser.type, frameParser.streamId);
                return null;
            }
        }
        return channel;
    }

    @Override
    protected FrameHeaderData parseFrame(ByteBuffer data) throws IOException {
        Http2FrameHeaderParser frameParser;
        if (this.prefaceCount < PREFACE_BYTES.length) {
            while (data.hasRemaining() && this.prefaceCount < PREFACE_BYTES.length) {
                if (data.get() != PREFACE_BYTES[this.prefaceCount]) {
                    IoUtils.safeClose((Closeable)this.getUnderlyingConnection());
                    throw UndertowMessages.MESSAGES.incorrectHttp2Preface();
                }
                ++this.prefaceCount;
            }
        }
        if ((frameParser = this.frameParser) == null) {
            this.frameParser = frameParser = new Http2FrameHeaderParser(this, this.continuationParser);
            this.continuationParser = null;
        }
        if (!frameParser.handle(data)) {
            return null;
        }
        if (!this.initialSettingsReceived) {
            if (frameParser.type != 4) {
                UndertowLogger.REQUEST_IO_LOGGER.remoteEndpointFailedToSendInitialSettings();
                this.markReadsBroken(new IOException());
            } else {
                this.initialSettingsReceived = true;
            }
        }
        this.frameParser = null;
        if (frameParser.getFrameLength() > (long)this.receiveMaxFrameSize) {
            this.sendGoAway(6);
            throw UndertowMessages.MESSAGES.http2FrameTooLarge();
        }
        if (frameParser.getContinuationParser() != null) {
            this.continuationParser = frameParser.getContinuationParser();
            return null;
        }
        return frameParser;
    }

    @Override
    protected void lastDataRead() {
        if (!this.peerGoneAway && !this.thisGoneAway) {
            this.sendGoAway(10);
            this.peerGoneAway = true;
        }
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && !this.peerGoneAway && !this.thisGoneAway;
    }

    @Override
    protected boolean isLastFrameReceived() {
        return this.peerGoneAway;
    }

    @Override
    protected boolean isLastFrameSent() {
        return this.peerGoneAway || this.thisGoneAway;
    }

    @Override
    protected void handleBrokenSourceChannel(Throwable e) {
        UndertowLogger.REQUEST_LOGGER.debugf(e, "Closing HTTP2 channel to %s due to broken read side", this.getPeerAddress());
        if (e instanceof ConnectionErrorException) {
            this.sendGoAway(((ConnectionErrorException)e).getCode(), new Http2ControlMessageExceptionHandler());
        } else {
            this.sendGoAway(e instanceof ClosedChannelException ? 10 : 1, new Http2ControlMessageExceptionHandler());
        }
    }

    @Override
    protected void handleBrokenSinkChannel(Throwable e) {
        UndertowLogger.REQUEST_LOGGER.debugf(e, "Closing HTTP2 channel to %s due to broken write side", this.getPeerAddress());
        IoUtils.safeClose((Closeable)((Object)this));
    }

    @Override
    protected void closeSubChannels() {
        Object receiver;
        for (Map.Entry<Integer, Http2StreamSourceChannel> entry : this.incomingStreams.entrySet()) {
            receiver = entry.getValue();
            if (((AbstractFramedStreamSourceChannel)receiver).isReadResumed()) {
                ChannelListeners.invokeChannelListener((Executor)((AbstractFramedStreamSourceChannel)receiver).getIoThread(), (Channel)receiver, (ChannelListener)((ChannelListener.SimpleSetter)((AbstractFramedStreamSourceChannel)receiver).getReadSetter()).get());
            }
            IoUtils.safeClose((Closeable)receiver);
        }
        this.incomingStreams.clear();
        for (Map.Entry<Integer, Object> entry : this.outgoingStreams.entrySet()) {
            receiver = (Http2StreamSinkChannel)entry.getValue();
            if (((AbstractFramedStreamSinkChannel)receiver).isWritesShutdown()) {
                ChannelListeners.invokeChannelListener((Executor)((AbstractFramedStreamSinkChannel)receiver).getIoThread(), (Channel)receiver, (ChannelListener)((ChannelListener.SimpleSetter)((AbstractFramedStreamSinkChannel)receiver).getWriteSetter()).get());
            }
            IoUtils.safeClose((Closeable)receiver);
        }
        this.outgoingStreams.clear();
    }

    synchronized void updateSettings(List<Http2Setting> settings) {
        for (Http2Setting setting : settings) {
            if (setting.getId() == 4) {
                int old = this.initialSendWindowSize;
                this.initialSendWindowSize = setting.getValue();
                int difference = old - this.initialSendWindowSize;
                this.sendWindowSize += difference;
                continue;
            }
            if (setting.getId() != 5) continue;
            this.sendMaxFrameSize = setting.getValue();
        }
    }

    public int getHttp2Version() {
        return 3;
    }

    public int getInitialSendWindowSize() {
        return this.initialSendWindowSize;
    }

    public int getInitialReceiveWindowSize() {
        return this.initialReceiveWindowSize;
    }

    public synchronized void handleWindowUpdate(int streamId, int deltaWindowSize) throws IOException {
        if (streamId == 0) {
            boolean exhausted = this.sendWindowSize == 0;
            this.sendWindowSize += deltaWindowSize;
            if (exhausted) {
                this.notifyFlowControlAllowed();
            }
        } else {
            Http2StreamSinkChannel stream = this.outgoingStreams.get(streamId);
            if (stream != null) {
                stream.updateFlowControlWindow(deltaWindowSize);
            }
        }
    }

    synchronized void notifyFlowControlAllowed() throws IOException {
        super.recalculateHeldFrames();
    }

    public void sendPing(byte[] data) {
        this.sendPing(data, new Http2ControlMessageExceptionHandler());
    }

    public void sendPing(byte[] data, ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> exceptionHandler) {
        this.sendPing(data, exceptionHandler, false);
    }

    void sendPing(byte[] data, ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> exceptionHandler, boolean ack) {
        Http2PingStreamSinkChannel ping = new Http2PingStreamSinkChannel(this, data, ack);
        try {
            ping.shutdownWrites();
            if (!ping.flush()) {
                ping.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, exceptionHandler));
                ping.resumeWrites();
            }
        }
        catch (IOException e) {
            exceptionHandler.handleException((Channel)((Object)ping), e);
        }
    }

    public void sendGoAway(int status) {
        this.sendGoAway(status, new Http2ControlMessageExceptionHandler());
    }

    public void sendGoAway(int status, ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> exceptionHandler) {
        if (this.thisGoneAway) {
            return;
        }
        this.thisGoneAway = true;
        Http2GoAwayStreamSinkChannel goAway = new Http2GoAwayStreamSinkChannel(this, status, this.lastGoodStreamId);
        try {
            goAway.shutdownWrites();
            if (!goAway.flush()) {
                goAway.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<Channel>(){

                    public void handleEvent(Channel channel) {
                        IoUtils.safeClose((Closeable)((Object)Http2Channel.this));
                    }
                }, exceptionHandler));
                goAway.resumeWrites();
            } else {
                IoUtils.safeClose((Closeable)((Object)this));
            }
        }
        catch (IOException e) {
            exceptionHandler.handleException((Channel)((Object)goAway), e);
        }
    }

    public void sendUpdateWindowSize(int streamId, int delta) {
        Http2WindowUpdateStreamSinkChannel windowUpdateStreamSinkChannel = new Http2WindowUpdateStreamSinkChannel(this, streamId, delta);
        try {
            windowUpdateStreamSinkChannel.shutdownWrites();
            if (!windowUpdateStreamSinkChannel.flush()) {
                windowUpdateStreamSinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new Http2ControlMessageExceptionHandler()));
                windowUpdateStreamSinkChannel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.handleBrokenSinkChannel(e);
        }
    }

    public SSLSession getSslSession() {
        StreamConnection con = this.getUnderlyingConnection();
        if (con instanceof SslConnection) {
            return ((SslConnection)con).getSslSession();
        }
        return null;
    }

    public synchronized void updateReceiveFlowControlWindow(int read) {
        if (read <= 0) {
            return;
        }
        this.receiveWindowSize -= read;
        int initialWindowSize = this.initialReceiveWindowSize;
        if (this.receiveWindowSize < initialWindowSize / 2) {
            int delta = initialWindowSize - this.receiveWindowSize;
            this.receiveWindowSize += delta;
            this.sendUpdateWindowSize(0, delta);
        }
    }

    public synchronized Http2HeadersStreamSinkChannel createStream(HeaderMap requestHeaders) throws IOException {
        if (!this.isOpen()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        int streamId = this.streamIdCounter;
        this.streamIdCounter += 2;
        Http2HeadersStreamSinkChannel spdySynStreamStreamSinkChannel = new Http2HeadersStreamSinkChannel(this, streamId, requestHeaders);
        this.outgoingStreams.put(streamId, spdySynStreamStreamSinkChannel);
        return spdySynStreamStreamSinkChannel;
    }

    synchronized int grabFlowControlBytes(int bytesToGrab) {
        int min = Math.min(bytesToGrab, this.sendWindowSize);
        min = Math.min(this.sendMaxFrameSize, min);
        this.sendWindowSize -= min;
        return min;
    }

    void registerStreamSink(Http2HeadersStreamSinkChannel synResponse) {
        this.outgoingStreams.put(synResponse.getStreamId(), synResponse);
    }

    void removeStreamSink(int streamId) {
        this.outgoingStreams.remove(streamId);
    }

    Map<Integer, Http2StreamSourceChannel> getIncomingStreams() {
        return this.incomingStreams;
    }

    public boolean isClient() {
        return this.streamIdCounter % 2 == 1;
    }

    HpackEncoder getEncoder() {
        return this.encoder;
    }

    HpackDecoder getDecoder() {
        return this.decoder;
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return (T)this.attachments.get(key);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        Object o = this.attachments.get(key);
        if (o == null) {
            return Collections.emptyList();
        }
        return (List)o;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        return key.cast(this.attachments.put(key, key.cast(value)));
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return key.cast(this.attachments.remove(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        Map<AttachmentKey<?>, Object> attachments;
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("key");
        }
        Map<AttachmentKey<?>, Object> map = attachments = this.attachments;
        synchronized (map) {
            List list = key.cast(attachments.get(key));
            if (list == null) {
                AttachmentList<Object> newList = new AttachmentList<Object>(Object.class);
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }

    public void sendRstStream(int streamId, int statusCode) {
        this.handleRstStream(streamId);
        try {
            Http2RstStreamSinkChannel channel = new Http2RstStreamSinkChannel(this, streamId, statusCode);
            channel.shutdownWrites();
            if (!channel.flush()) {
                channel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, this.writeExceptionHandler()));
                channel.resumeWrites();
            }
        }
        catch (IOException e) {
            this.markWritesBroken(e);
        }
    }

    private void handleRstStream(int streamId) {
        Http2StreamSinkChannel outgoing;
        AbstractHttp2StreamSourceChannel incoming = this.incomingStreams.remove(streamId);
        if (incoming != null) {
            incoming.rstStream();
        }
        if ((outgoing = this.outgoingStreams.remove(streamId)) != null) {
            outgoing.rstStream();
        }
    }

    public Http2HeadersStreamSinkChannel createInitialUpgradeResponseStream() {
        if (this.lastGoodStreamId != 0) {
            throw new IllegalStateException();
        }
        this.lastGoodStreamId = 1;
        Http2HeadersStreamSinkChannel stream = new Http2HeadersStreamSinkChannel(this, 1);
        this.outgoingStreams.put(1, stream);
        return stream;
    }

    public int getReceiveMaxFrameSize() {
        return this.receiveMaxFrameSize;
    }

    public int getSendMaxFrameSize() {
        return this.sendMaxFrameSize;
    }

    private class Http2ControlMessageExceptionHandler
    implements ChannelExceptionHandler<AbstractHttp2StreamSinkChannel> {
        private Http2ControlMessageExceptionHandler() {
        }

        public void handleException(AbstractHttp2StreamSinkChannel channel, IOException exception) {
            IoUtils.safeClose((Closeable)((Object)channel));
            Http2Channel.this.handleBrokenSinkChannel(exception);
        }
    }
}

