/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.conduits.ReadDataStreamSourceConduit;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ParseTimeoutUpdater;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.server.protocol.http.HttpTransferEncoding;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.util.ClosingChannelExceptionHandler;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.ConduitStreamSinkChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.StreamSourceConduit;

final class HttpReadListener
implements ChannelListener<ConduitStreamSourceChannel>,
Runnable {
    private static final String BAD_REQUEST = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\nConnection: close\r\n\r\n";
    private final HttpServerConnection connection;
    private final ParseState state = new ParseState();
    private final HttpRequestParser parser;
    private HttpServerExchange httpServerExchange;
    private int read = 0;
    private final int maxRequestSize;
    private final long maxEntitySize;
    private final boolean recordRequestStartTime;
    private volatile int requestState;
    private static final AtomicIntegerFieldUpdater<HttpReadListener> requestStateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpReadListener.class, "requestState");
    private ParseTimeoutUpdater parseTimeoutUpdater;

    HttpReadListener(HttpServerConnection connection, HttpRequestParser parser) {
        this.connection = connection;
        this.parser = parser;
        this.maxRequestSize = connection.getUndertowOptions().get(UndertowOptions.MAX_HEADER_SIZE, 0x100000);
        this.maxEntitySize = connection.getUndertowOptions().get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.recordRequestStartTime = connection.getUndertowOptions().get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        int requestParseTimeout = connection.getUndertowOptions().get(UndertowOptions.REQUEST_PARSE_TIMEOUT, -1);
        int requestIdleTimeout = connection.getUndertowOptions().get(UndertowOptions.NO_REQUEST_TIMEOUT, -1);
        if (requestIdleTimeout < 0 && requestParseTimeout < 0) {
            this.parseTimeoutUpdater = null;
        } else {
            this.parseTimeoutUpdater = new ParseTimeoutUpdater(connection, requestParseTimeout, requestIdleTimeout);
            connection.addCloseListener(this.parseTimeoutUpdater);
        }
    }

    public void newRequest() {
        this.state.reset();
        this.read = 0;
        this.httpServerExchange = new HttpServerExchange(this.connection, this.maxEntitySize);
        if (this.parseTimeoutUpdater != null) {
            this.parseTimeoutUpdater.connectionIdle();
        }
    }

    public void handleEvent(ConduitStreamSourceChannel channel) {
        while (requestStateUpdater.get(this) != 0) {
            if (!requestStateUpdater.compareAndSet(this, 1, 2)) continue;
            channel.suspendReads();
            requestStateUpdater.set(this, 1);
            return;
        }
        this.handleEventWithNoRunningRequest(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEventWithNoRunningRequest(ConduitStreamSourceChannel channel) {
        Pooled existing = this.connection.getExtraBytes();
        if (existing == null && this.connection.getOriginalSourceConduit().isReadShutdown() || this.connection.getOriginalSinkConduit().isWriteShutdown()) {
            IoUtils.safeClose((Closeable)((Object)this.connection));
            channel.suspendReads();
            return;
        }
        Pooled pooled = existing == null ? this.connection.getBufferPool().allocate() : existing;
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        boolean free = true;
        try {
            boolean bytesRead = false;
            do {
                int total;
                int res;
                if (existing == null) {
                    buffer.clear();
                    try {
                        res = channel.read(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.debug("Error reading request", e);
                        IoUtils.safeClose((Closeable)((Object)this.connection));
                        if (free) {
                            pooled.free();
                        }
                        return;
                    }
                } else {
                    res = buffer.remaining();
                }
                if (res <= 0) {
                    if (bytesRead && this.parseTimeoutUpdater != null) {
                        this.parseTimeoutUpdater.failedParse();
                    }
                    this.handleFailedRead(channel, res);
                    return;
                }
                bytesRead = true;
                if (existing != null) {
                    existing = null;
                    this.connection.setExtraBytes(null);
                } else {
                    buffer.flip();
                }
                int begin = buffer.remaining();
                this.parser.handle(buffer, this.state, this.httpServerExchange);
                if (buffer.hasRemaining()) {
                    free = false;
                    this.connection.setExtraBytes((Pooled<ByteBuffer>)pooled);
                }
                this.read = total = this.read + (begin - buffer.remaining());
                if (this.read <= this.maxRequestSize) continue;
                UndertowLogger.REQUEST_LOGGER.requestHeaderWasTooLarge(this.connection.getPeerAddress(), this.maxRequestSize);
                IoUtils.safeClose((Closeable)((Object)this.connection));
                return;
            } while (!this.state.isComplete());
            if (this.parseTimeoutUpdater != null) {
                this.parseTimeoutUpdater.requestStarted();
            }
            HttpServerExchange httpServerExchange = this.httpServerExchange;
            httpServerExchange.setRequestScheme(this.connection.getSslSession() != null ? "https" : "http");
            this.httpServerExchange = null;
            requestStateUpdater.set(this, 1);
            HttpTransferEncoding.setupRequest(httpServerExchange);
            if (this.recordRequestStartTime) {
                Connectors.setRequestStartTime(httpServerExchange);
            }
            this.connection.setCurrentExchange(httpServerExchange);
            Connectors.executeRootHandler(this.connection.getRootHandler(), httpServerExchange);
        }
        catch (Exception e) {
            this.sendBadRequestAndClose(this.connection.getChannel(), e);
            return;
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private void handleFailedRead(ConduitStreamSourceChannel channel, int res) {
        if (res == 0) {
            channel.setReadListener((ChannelListener)this);
            channel.resumeReads();
        } else if (res == -1) {
            IoUtils.safeClose((Closeable)((Object)this.connection));
        }
    }

    private void sendBadRequestAndClose(final StreamConnection connection, Exception exception) {
        UndertowLogger.REQUEST_IO_LOGGER.failedToParseRequest(exception);
        connection.getSourceChannel().suspendReads();
        new StringWriteChannelListener(BAD_REQUEST){

            @Override
            protected void writeDone(StreamSinkChannel c) {
                super.writeDone(c);
                c.suspendWrites();
                IoUtils.safeClose((Closeable)connection);
            }

            @Override
            protected void handleError(StreamSinkChannel channel, IOException e) {
                IoUtils.safeClose((Closeable)connection);
            }
        }.setup((StreamSinkChannel)connection.getSinkChannel());
    }

    public void exchangeComplete(final HttpServerExchange exchange) {
        this.connection.clearChannel();
        final HttpServerConnection connection = this.connection;
        if (exchange.isPersistent() && !exchange.isUpgrade()) {
            StreamConnection channel = connection.getChannel();
            if (connection.getExtraBytes() == null) {
                if (exchange.isInIoThread()) {
                    this.newRequest();
                    channel.getSourceChannel().setReadListener((ChannelListener)this);
                    channel.getSourceChannel().resumeReads();
                    requestStateUpdater.set(this, 0);
                } else {
                    do {
                        if (!connection.getOriginalSourceConduit().isReadShutdown() && !connection.getOriginalSinkConduit().isWriteShutdown()) continue;
                        channel.getSourceChannel().suspendReads();
                        channel.getSinkChannel().suspendWrites();
                        IoUtils.safeClose((Closeable)((Object)connection));
                        return;
                    } while (!requestStateUpdater.compareAndSet(this, 1, 2));
                    this.newRequest();
                    channel.getSourceChannel().setReadListener((ChannelListener)this);
                    requestStateUpdater.set(this, 0);
                    channel.getSourceChannel().resumeReads();
                }
            } else if (exchange.isInIoThread()) {
                requestStateUpdater.set(this, 0);
                this.newRequest();
                channel.getIoThread().execute((Runnable)this);
            } else {
                do {
                    if (!connection.getOriginalSinkConduit().isWriteShutdown()) continue;
                    channel.getSourceChannel().suspendReads();
                    channel.getSinkChannel().suspendWrites();
                    IoUtils.safeClose((Closeable)((Object)connection));
                    return;
                } while (!requestStateUpdater.compareAndSet(this, 1, 2));
                this.newRequest();
                channel.getSourceChannel().suspendReads();
                requestStateUpdater.set(this, 0);
                Executor executor = exchange.getDispatchExecutor();
                if (executor == null) {
                    executor = exchange.getConnection().getWorker();
                }
                executor.execute(this);
            }
        } else if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)((Object)connection));
        } else if (exchange.isUpgrade()) {
            if (connection.getExtraBytes() != null) {
                connection.getChannel().getSourceChannel().setConduit((StreamSourceConduit)new ReadDataStreamSourceConduit(connection.getChannel().getSourceChannel().getConduit(), connection));
            }
            try {
                if (!connection.getChannel().getSinkChannel().flush()) {
                    connection.getChannel().getSinkChannel().setWriteListener(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<ConduitStreamSinkChannel>(){

                        public void handleEvent(ConduitStreamSinkChannel conduitStreamSinkChannel) {
                            connection.getUpgradeListener().handleUpgrade(connection.getChannel(), exchange);
                        }
                    }, new ClosingChannelExceptionHandler(new Closeable[]{connection})));
                    connection.getChannel().getSinkChannel().resumeWrites();
                    return;
                }
                connection.getUpgradeListener().handleUpgrade(connection.getChannel(), exchange);
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)((Object)connection));
            }
        }
    }

    @Override
    public void run() {
        this.handleEvent(this.connection.getChannel().getSourceChannel());
    }
}

