/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowLogger;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpServerConnection;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class PipeliningBufferingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final int SHUTDOWN = 1;
    private static final int DELEGATE_SHUTDOWN = 2;
    private static final int FLUSHING = 8;
    private int state;
    private final Pool<ByteBuffer> pool;
    private Pooled<ByteBuffer> buffer;

    public PipeliningBufferingStreamSinkConduit(StreamSinkConduit next, Pool<ByteBuffer> pool) {
        super(next);
        this.pool = pool;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        boolean res;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((int)this.state, (int)8) && !(res = this.flushBuffer())) {
            return 0L;
        }
        Pooled pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        long total = Buffers.remaining((Buffer[])srcs, (int)offset, (int)length);
        if ((long)buffer.remaining() > total) {
            long put = total;
            Buffers.copy((ByteBuffer)buffer, (ByteBuffer[])srcs, (int)offset, (int)length);
            return put;
        }
        return this.flushBufferWithUserData(srcs, offset, length);
    }

    public int write(ByteBuffer src) throws IOException {
        ByteBuffer buffer;
        boolean res;
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((int)this.state, (int)8) && !(res = this.flushBuffer())) {
            return 0;
        }
        Pooled pooled = this.buffer;
        if (pooled == null) {
            this.buffer = pooled = this.pool.allocate();
        }
        if ((buffer = (ByteBuffer)pooled.getResource()).remaining() > src.remaining()) {
            int put = src.remaining();
            buffer.put(src);
            return put;
        }
        return (int)this.flushBufferWithUserData(new ByteBuffer[]{src}, 0, 1);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long flushBufferWithUserData(ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.getResource();
        if (byteBuffer.position() == 0) {
            try {
                long l = ((StreamSinkConduit)this.next).write(byteBuffers, offset, length);
                return l;
            }
            finally {
                this.buffer.free();
                this.buffer = null;
            }
        }
        if (!Bits.anyAreSet((int)this.state, (int)8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        int originalBufferedRemaining = byteBuffer.remaining();
        long toWrite = originalBufferedRemaining;
        ByteBuffer[] writeBufs = new ByteBuffer[length + 1];
        writeBufs[0] = byteBuffer;
        for (int i = offset; i < offset + length; ++i) {
            writeBufs[i + 1 - offset] = byteBuffers[i];
            toWrite += (long)byteBuffers[i].remaining();
        }
        long res = 0L;
        long written = 0L;
        do {
            res = ((StreamSinkConduit)this.next).write(writeBufs, 0, writeBufs.length);
            written += res;
            if (res != 0L) continue;
            if (written > (long)originalBufferedRemaining) {
                this.buffer.free();
                this.buffer = null;
                this.state &= 0xFFFFFFF7;
                return written - (long)originalBufferedRemaining;
            }
            return 0L;
        } while (written < toWrite);
        this.buffer.free();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return written - (long)originalBufferedRemaining;
    }

    public boolean flushPipelinedData() throws IOException {
        if (this.buffer == null || ((ByteBuffer)this.buffer.getResource()).position() == 0 && Bits.allAreClear((int)this.state, (int)8)) {
            return ((StreamSinkConduit)this.next).flush();
        }
        return this.flushBuffer();
    }

    public void setupPipelineBuffer(HttpServerExchange exchange) {
        ((HttpServerConnection)exchange.getConnection()).getChannel().getSinkChannel().setConduit((StreamSinkConduit)this);
    }

    private boolean flushBuffer() throws IOException {
        if (this.buffer == null) {
            return ((StreamSinkConduit)this.next).flush();
        }
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.getResource();
        if (!Bits.anyAreSet((int)this.state, (int)8)) {
            this.state |= 8;
            byteBuffer.flip();
        }
        while (byteBuffer.hasRemaining()) {
            if (((StreamSinkConduit)this.next).write(byteBuffer) != 0) continue;
            return false;
        }
        if (!((StreamSinkConduit)this.next).flush()) {
            return false;
        }
        this.buffer.free();
        this.buffer = null;
        this.state &= 0xFFFFFFF7;
        return true;
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (this.buffer != null && ((ByteBuffer)this.buffer.getResource()).hasRemaining()) {
            return;
        }
        ((StreamSinkConduit)this.next).awaitWritable(time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        if (this.buffer != null) {
            if (((ByteBuffer)this.buffer.getResource()).hasRemaining()) {
                return;
            }
            ((StreamSinkConduit)this.next).awaitWritable();
        }
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            if (!this.flushBuffer()) {
                return false;
            }
            if (Bits.anyAreSet((int)this.state, (int)1) && Bits.anyAreClear((int)this.state, (int)2)) {
                this.state |= 2;
                ((StreamSinkConduit)this.next).terminateWrites();
            }
            return ((StreamSinkConduit)this.next).flush();
        }
        return true;
    }

    public void terminateWrites() throws IOException {
        this.state |= 1;
        if (this.buffer == null) {
            this.state |= 2;
            ((StreamSinkConduit)this.next).terminateWrites();
        }
    }

    public void truncateWrites() throws IOException {
        try {
            ((StreamSinkConduit)this.next).truncateWrites();
        }
        finally {
            if (this.buffer != null) {
                this.buffer.free();
            }
        }
    }

    public void exchangeComplete(HttpServerExchange exchange) {
        HttpServerConnection connection = (HttpServerConnection)exchange.getConnection();
        if (connection.getExtraBytes() == null || exchange.isUpgrade()) {
            this.performFlush(exchange, connection);
        } else {
            connection.getReadListener().exchangeComplete(exchange);
        }
    }

    void performFlush(final HttpServerExchange exchange, final HttpServerConnection connection) {
        try {
            final AbstractServerConnection.ConduitState oldState = connection.resetChannel();
            if (!this.flushPipelinedData()) {
                final StreamConnection channel = connection.getChannel();
                channel.getSinkChannel().setWriteListener((ChannelListener)new ChannelListener<Channel>(){

                    public void handleEvent(Channel c) {
                        try {
                            if (PipeliningBufferingStreamSinkConduit.this.flushPipelinedData()) {
                                channel.getSinkChannel().setWriteListener(null);
                                channel.getSinkChannel().suspendWrites();
                                connection.restoreChannel(oldState);
                                connection.getReadListener().exchangeComplete(exchange);
                            }
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                            IoUtils.safeClose((Closeable)channel);
                        }
                    }
                });
                connection.getChannel().getSinkChannel().resumeWrites();
                return;
            }
            connection.restoreChannel(oldState);
            connection.getReadListener().exchangeComplete(exchange);
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)connection.getChannel());
        }
    }
}

