/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class HttpContinue {
    public static final String CONTINUE = "100-continue";
    private static final AttachmentKey<Boolean> ALREADY_SENT = AttachmentKey.create(Boolean.class);

    public static boolean requiresContinueResponse(HttpServerExchange exchange) {
        if (!exchange.isHttp11() || exchange.isResponseStarted() || exchange.getAttachment(ALREADY_SENT) != null) {
            return false;
        }
        if (exchange.getConnection() instanceof HttpServerConnection && ((HttpServerConnection)exchange.getConnection()).getExtraBytes() != null) {
            return false;
        }
        HeaderValues expect = exchange.getRequestHeaders().get(Headers.EXPECT);
        if (expect != null) {
            for (String header : expect) {
                if (!header.equalsIgnoreCase(CONTINUE)) continue;
                return true;
            }
        }
        return false;
    }

    public static void sendContinueResponse(HttpServerExchange exchange, IoCallback callback) {
        if (!exchange.isResponseChannelAvailable()) {
            callback.onException(exchange, null, UndertowMessages.MESSAGES.cannotSendContinueResponse());
            return;
        }
        HttpContinue.internalSendContinueResponse(exchange, callback);
    }

    public static ContinueResponseSender createResponseSender(HttpServerExchange exchange) throws IOException {
        if (!exchange.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.cannotSendContinueResponse();
        }
        if (exchange.getAttachment(ALREADY_SENT) != null) {
            return new ContinueResponseSender(){

                @Override
                public boolean send() throws IOException {
                    return true;
                }

                @Override
                public void awaitWritable() throws IOException {
                }

                @Override
                public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
                }
            };
        }
        HttpServerExchange newExchange = exchange.getConnection().sendOutOfBandResponse(exchange);
        exchange.putAttachment(ALREADY_SENT, true);
        newExchange.setResponseCode(100);
        newExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, 0L);
        final StreamSinkChannel responseChannel = newExchange.getResponseChannel();
        return new ContinueResponseSender(){
            boolean shutdown = false;

            @Override
            public boolean send() throws IOException {
                if (!this.shutdown) {
                    this.shutdown = true;
                    responseChannel.shutdownWrites();
                }
                return responseChannel.flush();
            }

            @Override
            public void awaitWritable() throws IOException {
                responseChannel.awaitWritable();
            }

            @Override
            public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
                responseChannel.awaitWritable(time, timeUnit);
            }
        };
    }

    public static void sendContinueResponseBlocking(HttpServerExchange exchange) throws IOException {
        if (!exchange.isResponseChannelAvailable()) {
            throw UndertowMessages.MESSAGES.cannotSendContinueResponse();
        }
        if (exchange.getAttachment(ALREADY_SENT) != null) {
            return;
        }
        HttpServerExchange newExchange = exchange.getConnection().sendOutOfBandResponse(exchange);
        exchange.putAttachment(ALREADY_SENT, true);
        newExchange.setResponseCode(100);
        newExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, 0L);
        newExchange.startBlocking();
        newExchange.getOutputStream().close();
        newExchange.getInputStream().close();
    }

    public static void rejectExchange(HttpServerExchange exchange) {
        exchange.setResponseCode(417);
        exchange.setPersistent(false);
        exchange.endExchange();
    }

    private static void internalSendContinueResponse(final HttpServerExchange exchange, final IoCallback callback) {
        if (exchange.getAttachment(ALREADY_SENT) != null) {
            callback.onComplete(exchange, null);
            return;
        }
        HttpServerExchange newExchange = exchange.getConnection().sendOutOfBandResponse(exchange);
        exchange.putAttachment(ALREADY_SENT, true);
        newExchange.setResponseCode(100);
        newExchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, 0L);
        StreamSinkChannel responseChannel = newExchange.getResponseChannel();
        try {
            responseChannel.shutdownWrites();
            if (!responseChannel.flush()) {
                responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        exchange.dispatch(new HttpHandler(){

                            @Override
                            public void handleRequest(HttpServerExchange exchange) throws Exception {
                                callback.onComplete(exchange, null);
                            }
                        });
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                    public void handleException(Channel channel, final IOException e) {
                        exchange.dispatch(new HttpHandler(){

                            @Override
                            public void handleRequest(HttpServerExchange exchange) throws Exception {
                                callback.onException(exchange, null, e);
                            }
                        });
                    }
                }));
                responseChannel.resumeWrites();
                exchange.dispatch();
            } else {
                callback.onComplete(exchange, null);
            }
        }
        catch (IOException e) {
            callback.onException(exchange, null, e);
        }
    }

    public static interface ContinueResponseSender {
        public boolean send() throws IOException;

        public void awaitWritable() throws IOException;

        public void awaitWritable(long var1, TimeUnit var3) throws IOException;
    }
}

