/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.server.HttpHandler;
import io.undertow.server.protocol.http.HttpOpenListener;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.extensions.DebugExtensionsHeaderHandler;
import io.undertow.websockets.extensions.DebugExtensionsListener;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateHandshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.log4j.BasicConfigurator;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;

public class AutobahnExtensionsServer {
    private HttpOpenListener openListener;
    private XnioWorker worker;
    private AcceptingChannel<StreamConnection> server;
    private Xnio xnio;
    private final int port;

    public static WebSocketProtocolHandshakeHandler webSocketDebugHandler() {
        return new WebSocketProtocolHandshakeHandler(new WebSocketConnectionCallback(){

            public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                WebSocketLogger.EXTENSION_LOGGER.info((Object)"onConnect() ");
                channel.getReceiveSetter().set((ChannelListener)new DebugExtensionsListener());
                channel.resumeReceives();
            }
        });
    }

    public AutobahnExtensionsServer(int port) {
        this.port = port;
    }

    public void run() {
        this.xnio = Xnio.getInstance();
        try {
            this.worker = this.xnio.createWorker(OptionMap.builder().set(Options.WORKER_WRITE_THREADS, 4).set(Options.WORKER_READ_THREADS, 4).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.WORKER_TASK_CORE_THREADS, 10).set(Options.WORKER_TASK_MAX_THREADS, 12).set(Options.TCP_NODELAY, true).set(Options.CORK, true).getMap());
            OptionMap serverOptions = OptionMap.builder().set(Options.WORKER_ACCEPT_THREADS, 4).set(Options.TCP_NODELAY, true).set(Options.REUSE_ADDRESSES, true).getMap();
            this.openListener = new HttpOpenListener((Pool)new ByteBufferSlicePool(BufferAllocator.BYTE_BUFFER_ALLOCATOR, 8192, 0x4000000), 8192);
            ChannelListener acceptListener = ChannelListeners.openListenerAdapter((ChannelListener)this.openListener);
            this.server = this.worker.createStreamConnectionServer((SocketAddress)new InetSocketAddress(this.port), acceptListener, serverOptions);
            WebSocketProtocolHandshakeHandler handler = AutobahnExtensionsServer.webSocketDebugHandler().addExtension((ExtensionHandshake)new PerMessageDeflateHandshake());
            DebugExtensionsHeaderHandler debug = new DebugExtensionsHeaderHandler((HttpHandler)handler);
            this.setRootHandler(debug);
            this.server.resumeAccepts();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setRootHandler(HttpHandler rootHandler) {
        this.openListener.setRootHandler(rootHandler);
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--debug")) {
            BasicConfigurator.configure();
        }
        new AutobahnExtensionsServer(7777).run();
    }
}

