/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.HpackEncoder;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2ProtocolUtils;
import io.undertow.protocols.http2.Http2StreamSinkChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.HeaderMap;
import io.undertow.util.ImmediatePooled;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Pooled;

public class Http2DataStreamSinkChannel
extends Http2StreamSinkChannel {
    private final HeaderMap headers;
    private boolean first = true;
    private final HpackEncoder encoder;
    private ChannelListener<Http2DataStreamSinkChannel> completionListener;
    private final int frameType;

    Http2DataStreamSinkChannel(Http2Channel channel, int streamId, int frameType) {
        this(channel, streamId, new HeaderMap(), frameType);
    }

    Http2DataStreamSinkChannel(Http2Channel channel, int streamId, HeaderMap headers, int frameType) {
        super(channel, streamId);
        this.encoder = channel.getEncoder();
        this.headers = headers;
        this.frameType = frameType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        int fcWindow = this.grabFlowControlBytes(this.getBuffer().remaining());
        if (fcWindow == 0 && this.getBuffer().hasRemaining()) {
            return new SendFrameHeader(this.getBuffer().remaining(), null);
        }
        boolean finalFrame = this.isWritesShutdown() && fcWindow >= this.getBuffer().remaining();
        Pooled<ByteBuffer> firstHeaderBuffer = ((Http2Channel)this.getChannel()).getBufferPool().allocate();
        Pooled<ByteBuffer>[] allHeaderBuffers = null;
        ByteBuffer firstBuffer = (ByteBuffer)firstHeaderBuffer.getResource();
        boolean firstFrame = false;
        if (this.first) {
            firstFrame = true;
            this.first = false;
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)0);
            firstBuffer.put((byte)this.frameType);
            firstBuffer.put((byte)0);
            Http2ProtocolUtils.putInt(firstBuffer, this.getStreamId());
            this.writeBeforeHeaderBlock(firstBuffer);
            HpackEncoder.State result = this.encoder.encode(this.headers, firstBuffer);
            Pooled<ByteBuffer> current = firstHeaderBuffer;
            int headerFrameLength = firstBuffer.position() - 9;
            firstBuffer.put(0, (byte)(headerFrameLength >> 16 & 0xFF));
            firstBuffer.put(1, (byte)(headerFrameLength >> 8 & 0xFF));
            firstBuffer.put(2, (byte)(headerFrameLength & 0xFF));
            firstBuffer.put(4, (byte)((this.isWritesShutdown() && !this.getBuffer().hasRemaining() && this.frameType == 1 ? 1 : 0) | (result == HpackEncoder.State.COMPLETE ? 4 : 0)));
            while (result != HpackEncoder.State.COMPLETE) {
                allHeaderBuffers = this.allocateAll(allHeaderBuffers, current);
                current = allHeaderBuffers[allHeaderBuffers.length - 1];
                ByteBuffer currentBuffer = (ByteBuffer)current.getResource();
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)9);
                currentBuffer.put((byte)0);
                Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
                result = this.encoder.encode(this.headers, currentBuffer);
                int contFrameLength = currentBuffer.position() - 9;
                currentBuffer.put(0, (byte)(contFrameLength >> 16 & 0xFF));
                currentBuffer.put(1, (byte)(contFrameLength >> 8 & 0xFF));
                currentBuffer.put(2, (byte)(contFrameLength & 0xFF));
                currentBuffer.put(4, (byte)(result == HpackEncoder.State.COMPLETE ? 4 : 0));
            }
        }
        Pooled<ByteBuffer> currentPooled = allHeaderBuffers == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
        ByteBuffer currentBuffer = (ByteBuffer)currentPooled.getResource();
        int remainingInBuffer = 0;
        if (this.getBuffer().remaining() > 0) {
            if (fcWindow > 0) {
                if (currentBuffer.remaining() < 8) {
                    currentPooled = (allHeaderBuffers = this.allocateAll(allHeaderBuffers, currentPooled)) == null ? firstHeaderBuffer : allHeaderBuffers[allHeaderBuffers.length - 1];
                    currentBuffer = (ByteBuffer)currentPooled.getResource();
                }
                remainingInBuffer = this.getBuffer().remaining() - fcWindow;
                this.getBuffer().limit(this.getBuffer().position() + fcWindow);
                currentBuffer.put((byte)(fcWindow >> 16 & 0xFF));
                currentBuffer.put((byte)(fcWindow >> 8 & 0xFF));
                currentBuffer.put((byte)(fcWindow & 0xFF));
                currentBuffer.put((byte)0);
                currentBuffer.put((byte)(finalFrame ? 1 : 0));
                Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
            } else {
                remainingInBuffer = this.getBuffer().remaining();
            }
        } else if (finalFrame && !firstFrame) {
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)1);
            Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
        }
        if (allHeaderBuffers == null) {
            currentBuffer.flip();
            return new SendFrameHeader(remainingInBuffer, currentPooled);
        }
        int length = 0;
        for (int i = 0; i < allHeaderBuffers.length; ++i) {
            length += ((ByteBuffer)allHeaderBuffers[i].getResource()).position();
            ((ByteBuffer)allHeaderBuffers[i].getResource()).flip();
        }
        try {
            ByteBuffer newBuf = ByteBuffer.allocate(length);
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                newBuf.put((ByteBuffer)allHeaderBuffers[i].getResource());
            }
            newBuf.flip();
            SendFrameHeader sendFrameHeader = new SendFrameHeader(remainingInBuffer, new ImmediatePooled<ByteBuffer>(newBuf));
            return sendFrameHeader;
        }
        finally {
            for (int i = 0; i < allHeaderBuffers.length; ++i) {
                allHeaderBuffers[i].free();
            }
        }
    }

    protected void writeBeforeHeaderBlock(ByteBuffer buffer) {
    }

    @Override
    protected boolean isFlushRequiredOnEmptyBuffer() {
        return this.first;
    }

    public HeaderMap getHeaders() {
        return this.headers;
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        super.handleFlushComplete(finalFrame);
        if (finalFrame && this.completionListener != null) {
            ChannelListeners.invokeChannelListener((Channel)((Object)this), this.completionListener);
        }
    }

    public ChannelListener<Http2DataStreamSinkChannel> getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(ChannelListener<Http2DataStreamSinkChannel> completionListener) {
        this.completionListener = completionListener;
    }
}

