/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
@HttpOneOnly
@ProxyIgnore
public class ProxyHandlerXForwardedForTestCase {
    protected static Undertow server;
    protected static int port;
    protected static int sslPort;
    protected static int handlerPort;
    protected static UndertowXnioSsl ssl;

    @BeforeClass
    public static void setup() throws Exception {
        port = DefaultServer.getHostPort("default");
        sslPort = port + 1;
        handlerPort = port + 2;
        DefaultServer.startSSLServer();
        ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, DefaultServer.getBufferPool(), DefaultServer.getClientSSLContext());
        server = Undertow.builder().addHttpsListener(handlerPort, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_SPDY, (Object)false).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler((HttpHandler)Handlers.jvmRoute((String)"JSESSIONID", (String)"s1", (HttpHandler)Handlers.path().addPrefixPath("/x-forwarded", (HttpHandler)new XForwardedHandler()))).build();
        server.start();
    }

    @AfterClass
    public static void teardown() throws Exception {
        DefaultServer.stopSSLServer();
        server.stop();
    }

    private static void setProxyHandler(boolean rewriteHostHeader, boolean reuseXForwarded) throws Exception {
        DefaultServer.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), handlerPort, null, null, null), "s1", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_SPDY, (Object)false)), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404, rewriteHostHeader, reuseXForwarded));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXForwarded() throws Exception {
        ProxyHandlerXForwardedForTestCase.setProxyHandler(false, false);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/x-forwarded");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((long)port, (long)Integer.parseInt(result.getFirstHeader(Headers.X_FORWARDED_PORT.toString()).getValue()));
            Assert.assertEquals((Object)"http", (Object)result.getFirstHeader(Headers.X_FORWARDED_PROTO.toString()).getValue());
            Assert.assertEquals((Object)"localhost", (Object)result.getFirstHeader(Headers.X_FORWARDED_HOST.toString()).getValue());
            Assert.assertEquals((Object)DefaultServer.getDefaultServerAddress().getAddress().getHostAddress(), (Object)result.getFirstHeader(Headers.X_FORWARDED_FOR.toString()).getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXForwardedSsl() throws Exception {
        ProxyHandlerXForwardedForTestCase.setProxyHandler(false, false);
        TestHttpClient client = new TestHttpClient();
        try {
            client.setSSLContext(DefaultServer.getClientSSLContext());
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress() + "/x-forwarded");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((long)sslPort, (long)Integer.parseInt(result.getFirstHeader(Headers.X_FORWARDED_PORT.toString()).getValue()));
            Assert.assertEquals((Object)"https", (Object)result.getFirstHeader(Headers.X_FORWARDED_PROTO.toString()).getValue());
            Assert.assertEquals((Object)"localhost", (Object)result.getFirstHeader(Headers.X_FORWARDED_HOST.toString()).getValue());
            Assert.assertEquals((Object)DefaultServer.getDefaultServerAddress().getAddress().getHostAddress(), (Object)result.getFirstHeader(Headers.X_FORWARDED_FOR.toString()).getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReuseXForwarded() throws Exception {
        ProxyHandlerXForwardedForTestCase.setProxyHandler(false, true);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/x-forwarded");
            get.addHeader(Headers.X_FORWARDED_FOR.toString(), "50.168.245.32");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((long)port, (long)Integer.parseInt(result.getFirstHeader(Headers.X_FORWARDED_PORT.toString()).getValue()));
            Assert.assertEquals((Object)"http", (Object)result.getFirstHeader(Headers.X_FORWARDED_PROTO.toString()).getValue());
            Assert.assertEquals((Object)"localhost", (Object)result.getFirstHeader(Headers.X_FORWARDED_HOST.toString()).getValue());
            Assert.assertEquals((Object)("50.168.245.32," + DefaultServer.getDefaultServerAddress().getAddress().getHostAddress()), (Object)result.getFirstHeader(Headers.X_FORWARDED_FOR.toString()).getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReqriteHostHeader() throws Exception {
        ProxyHandlerXForwardedForTestCase.setProxyHandler(true, false);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/x-forwarded");
            get.addHeader(Headers.X_FORWARDED_FOR.toString(), "50.168.245.32");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((long)port, (long)Integer.parseInt(result.getFirstHeader(Headers.X_FORWARDED_PORT.toString()).getValue()));
            Assert.assertEquals((Object)"http", (Object)result.getFirstHeader(Headers.X_FORWARDED_PROTO.toString()).getValue());
            Assert.assertEquals((Object)String.format("localhost:%d", port), (Object)result.getFirstHeader(Headers.X_FORWARDED_HOST.toString()).getValue());
            Assert.assertEquals((Object)DefaultServer.getDefaultServerAddress().getAddress().getHostAddress(), (Object)result.getFirstHeader(Headers.X_FORWARDED_FOR.toString()).getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    protected static final class XForwardedHandler
    implements HttpHandler {
        protected XForwardedHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRequestHeaders().contains(Headers.X_FORWARDED_FOR)) {
                exchange.getResponseHeaders().put(Headers.X_FORWARDED_FOR, exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_FOR));
            }
            if (exchange.getRequestHeaders().contains(Headers.X_FORWARDED_PROTO)) {
                exchange.getResponseHeaders().put(Headers.X_FORWARDED_PROTO, exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PROTO));
            }
            if (exchange.getRequestHeaders().contains(Headers.X_FORWARDED_HOST)) {
                exchange.getResponseHeaders().put(Headers.X_FORWARDED_HOST, exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_HOST));
            }
            if (exchange.getRequestHeaders().contains(Headers.X_FORWARDED_PORT)) {
                exchange.getResponseHeaders().put(Headers.X_FORWARDED_PORT, exchange.getRequestHeaders().getFirst(Headers.X_FORWARDED_PORT));
            }
        }
    }
}

