/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileHandlerSymlinksTestCase {
    @Before
    public void createSymlinksScenario() throws IOException, URISyntaxException {
        Assume.assumeFalse((boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        File filePath = new File(this.getClass().getResource("page.html").toURI());
        File rootPath = filePath.getParentFile();
        File newDir = new File(rootPath, "newDir");
        newDir.mkdir();
        Path newDirPath = newDir.toPath();
        File innerDir = new File(newDir, "innerDir");
        innerDir.mkdir();
        Path innerDirPath = innerDir.toPath();
        Files.copy(filePath.toPath(), newDirPath.resolve(filePath.toPath().getFileName()), new CopyOption[0]);
        Files.copy(filePath.toPath(), innerDirPath.resolve(filePath.toPath().getFileName()), new CopyOption[0]);
        File newSymlink = new File(rootPath, "newSymlink");
        Path newSymlinkPath = newSymlink.toPath();
        Files.createSymbolicLink(newSymlinkPath, newDirPath, new FileAttribute[0]);
        File innerSymlink = new File(newDir, "innerSymlink");
        Path innerSymlinkPath = innerSymlink.toPath();
        Files.createSymbolicLink(innerSymlinkPath, innerDirPath, new FileAttribute[0]);
    }

    @After
    public void deleteSymlinksScenario() throws IOException, URISyntaxException {
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        File newDir = new File(rootPath, "newDir");
        File page = new File(newDir, "page.html");
        File innerDir = new File(newDir, "innerDir");
        File innerSymlink = new File(newDir, "innerSymlink");
        File innerPage = new File(innerDir, "page.html");
        innerSymlink.delete();
        newSymlink.delete();
        innerPage.delete();
        page.delete();
        innerDir.delete();
        newDir.delete();
    }

    @Test
    public void testCreateSymlinks() throws IOException, URISyntaxException {
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newDir = new File(rootPath, "newDir");
        Path newDirPath = newDir.toPath();
        Assert.assertFalse((boolean)Files.isSymbolicLink(newDirPath));
        File innerDir = new File(newDir, "innerDir");
        Path innerDirPath = innerDir.toPath();
        Assert.assertFalse((boolean)Files.isSymbolicLink(innerDirPath));
        File newSymlink = new File(rootPath, "newSymlink");
        Path newSymlinkPath = newSymlink.toPath();
        Assert.assertTrue((boolean)Files.isSymbolicLink(newSymlinkPath));
        File innerSymlink = new File(newSymlink, "innerSymlink");
        Path innerSymlinkPath = innerSymlink.toPath();
        Assert.assertTrue((boolean)Files.isSymbolicLink(innerSymlinkPath));
        File f = innerSymlinkPath.getRoot().toFile();
        for (int i = 0; i < innerSymlinkPath.getNameCount(); ++i) {
            f = new File(f, innerSymlinkPath.getName(i).toString());
            System.out.println(f + " " + Files.isSymbolicLink(f.toPath()));
        }
        f = new File(f, ".");
        System.out.println(f + " " + Files.isSymbolicLink(f.toPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultAccessSymlinkDenied() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L)).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedForEmptySafePath() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{""})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedForInsideSymlinks() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newDir");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{""})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerDir/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkGranted() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{"/"})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkGrantedUsingSpecificFilters() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.getAbsolutePath().concat("/newDir")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkGrantedUsingSpecificFiltersWithDirectoryListingEnabled() throws IOException, URISyntaxException {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)300000);
        TestHttpClient client = new TestHttpClient((HttpParams)params);
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.getAbsolutePath().concat("/newDir")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"})));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/.");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedUsingSpecificFilters() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.getAbsolutePath().concat("/otherDir")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedUsingSameSymlinkName() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.getAbsolutePath().concat("/innerSymlink")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceManagerBaseSymlink() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{""})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelativePathSymlinkFilter() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        File rootPath = new File(this.getClass().getResource("page.html").toURI()).getParentFile();
        File newSymlink = new File(rootPath, "newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler().setResourceManager((ResourceManager)new FileResourceManager(newSymlink, 0xA00000L, true, new String[]{"innerDir"})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

