/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ByteRangeHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class RangeRequestTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        Path rootPath = Paths.get(RangeRequestTestCase.class.getResource("range.txt").toURI()).getParent();
        PathHandler path = Handlers.path();
        path.addPrefixPath("/path", (HttpHandler)new ByteRangeHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseSender().send("0123456789");
            }
        }, true));
        path.addPrefixPath("/resource", (HttpHandler)new ResourceHandler((ResourceManager)new FileResourceManager(rootPath.toFile(), 0xA00000L)).setDirectoryListingEnabled(true));
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void testGenericRangeHandler() throws IOException, InterruptedException {
        this.runTest("/path");
    }

    @Test
    public void testResourceHandler() throws IOException, InterruptedException {
        this.runTest("/resource/range.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String path) throws IOException, InterruptedException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("range", "bytes=2-3");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            String response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"23", (Object)response);
            Assert.assertEquals((Object)"2-3/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("range", "bytes=0-0");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0", (Object)response);
            Assert.assertEquals((Object)"0-0/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("range", "bytes=1-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"123456789", (Object)response);
            Assert.assertEquals((Object)"1-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("range", "bytes=0-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"0123456789", (Object)response);
            Assert.assertEquals((Object)"0-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("range", "bytes=9-");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            Assert.assertEquals((Object)"9-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
            get = new HttpGet(DefaultServer.getDefaultServerURL() + path);
            get.addHeader("range", "bytes=-1");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)206L, (long)result.getStatusLine().getStatusCode());
            response = EntityUtils.toString((HttpEntity)result.getEntity());
            Assert.assertEquals((Object)"9", (Object)response);
            Assert.assertEquals((Object)"9-9/10", (Object)result.getFirstHeader("Content-Range").getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

