/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class AllowedMethodsTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowedMethods() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            AllowedMethodsHandler handler = new AllowedMethodsHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, new HttpString[]{Methods.POST});
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)405L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setEntity((HttpEntity)new StringEntity("foo"));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowedMethods() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            DisallowedMethodsHandler handler = new DisallowedMethodsHandler((HttpHandler)ResponseCodeHandler.HANDLE_200, new HttpString[]{Methods.GET});
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)405L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/path");
            post.setEntity((HttpEntity)new StringEntity("foo"));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

