/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.error;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.error.FileErrorPageHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileErrorPageHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileBasedErrorPageIsGenerated() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            FileErrorPageHandler handler = new FileErrorPageHandler(new File(this.getClass().getResource("errorpage.html").getFile()), new Integer[]{404});
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((Object)"text/html", (Object)result.getHeaders("Content-Type")[0].getValue());
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertTrue((String)response, (boolean)response.contains("Custom Error Page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

