/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.HttpOneOnly;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
@HttpOneOnly
public class ChunkedRequestTrailersTestCase {
    private static volatile HttpServerConnection connection;
    private static OptionMap existing;

    @BeforeClass
    public static void setup() {
        BlockingHandler blockingHandler = new BlockingHandler();
        existing = DefaultServer.getUndertowOptions();
        DefaultServer.setUndertowOptions(OptionMap.create((Option)UndertowOptions.ALWAYS_SET_DATE, (Object)false));
        DefaultServer.setRootHandler((HttpHandler)blockingHandler);
        blockingHandler.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) {
                try {
                    if (connection == null) {
                        connection = (HttpServerConnection)exchange.getConnection();
                    } else if (!DefaultServer.isProxy() && connection != exchange.getConnection()) {
                        exchange.setResponseCode(500);
                        OutputStream outputStream = exchange.getOutputStream();
                        outputStream.write("Connection not persistent".getBytes());
                        outputStream.close();
                        return;
                    }
                    OutputStream outputStream = exchange.getOutputStream();
                    InputStream inputStream = exchange.getInputStream();
                    String m = HttpClientUtils.readResponse(inputStream);
                    Assert.assertEquals((Object)"abcdefghi", (Object)m);
                    HeaderMap headers = (HeaderMap)exchange.getAttachment(HttpAttachments.REQUEST_TRAILERS);
                    for (HeaderValues header : headers) {
                        for (String val : header) {
                            outputStream.write(header.getHeaderName().toString().getBytes());
                            outputStream.write(": ".getBytes());
                            outputStream.write(val.getBytes());
                            outputStream.write("\r\n".getBytes());
                        }
                    }
                    inputStream.close();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @AfterClass
    public static void cleanup() {
        DefaultServer.setUndertowOptions(existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChunkedRequestsWithTrailers() throws IOException {
        connection = null;
        String request = "POST / HTTP/1.1\r\nTrailer:foo, bar\r\nTransfer-Encoding: chunked\r\n\r\n9\r\nabcdefghi\r\n0\r\nfoo: fooVal\r\n bar: barVal\r\n\r\n";
        String response1 = "HTTP/1.1 200 OK\r\nConnection: keep-alive\r\nContent-Length: 26\r\n\r\nfoo: fooVal\r\nbar: barVal\r\n";
        String response2 = "HTTP/1.1 200 OK\r\nConnection: keep-alive\r\nContent-Length: 26\r\n\r\nfoo: fooVal\r\nbar: barVal\r\n";
        try (Socket s = new Socket(DefaultServer.getDefaultServerAddress().getAddress(), DefaultServer.getDefaultServerAddress().getPort());){
            int r;
            s.getOutputStream().write(request.getBytes());
            StringBuilder sb = new StringBuilder();
            int read = 0;
            byte[] buf = new byte[100];
            while (read < response1.length() && (r = s.getInputStream().read(buf)) > 0) {
                if (r <= 0) continue;
                read += r;
                sb.append(new String(buf, 0, r));
            }
            try {
                Assert.assertEquals((Object)response1, (Object)sb.toString());
            }
            catch (AssertionError e) {
                Assert.assertEquals((Object)response2, (Object)sb.toString());
            }
            s.getOutputStream().write(request.getBytes());
            sb = new StringBuilder();
            read = 0;
            buf = new byte[100];
            while (read < response1.length() && (r = s.getInputStream().read(buf)) > 0) {
                if (r <= 0) continue;
                read += r;
                sb.append(new String(buf, 0, r));
            }
            try {
                Assert.assertEquals((Object)response1, (Object)sb.toString());
            }
            catch (AssertionError e) {
                Assert.assertEquals((Object)response2, (Object)sb.toString());
            }
        }
    }
}

