/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client.http;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientProvider;
import io.undertow.client.http.HttpClientConnection;
import io.undertow.client.http2.Http2ClientProvider;
import io.undertow.client.spdy.SpdyClientProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public class HttpClientProvider
implements ClientProvider {
    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("http", "https"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (uri.getScheme().equals("https")) {
            if (ssl == null) {
                listener.failed(UndertowMessages.MESSAGES.sslWasNull());
                return;
            }
            OptionMap tlsOptions = OptionMap.builder().addAll(options).set(Options.SSL_STARTTLS, true).getMap();
            if (bindAddress == null) {
                ssl.openSslConnection(worker, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, bufferPool, tlsOptions, uri), tlsOptions).addNotifier(this.createNotifier(listener), null);
            } else {
                ssl.openSslConnection(worker, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, bufferPool, tlsOptions, uri), tlsOptions).addNotifier(this.createNotifier(listener), null);
            }
        } else if (bindAddress == null) {
            worker.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri), options).addNotifier(this.createNotifier(listener), null);
        } else {
            worker.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri), null, options).addNotifier(this.createNotifier(listener), null);
        }
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, Pool<ByteBuffer> bufferPool, OptionMap options) {
        if (uri.getScheme().equals("https")) {
            if (ssl == null) {
                listener.failed(UndertowMessages.MESSAGES.sslWasNull());
                return;
            }
            OptionMap tlsOptions = OptionMap.builder().addAll(options).set(Options.SSL_STARTTLS, true).getMap();
            if (bindAddress == null) {
                ssl.openSslConnection(ioThread, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, bufferPool, tlsOptions, uri), tlsOptions).addNotifier(this.createNotifier(listener), null);
            } else {
                ssl.openSslConnection(ioThread, bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 443 : uri.getPort()), this.createOpenListener(listener, bufferPool, tlsOptions, uri), tlsOptions).addNotifier(this.createNotifier(listener), null);
            }
        } else if (bindAddress == null) {
            ioThread.openStreamConnection((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri), options).addNotifier(this.createNotifier(listener), null);
        } else {
            ioThread.openStreamConnection((SocketAddress)bindAddress, (SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri), null, options).addNotifier(this.createNotifier(listener), null);
        }
    }

    private IoFuture.Notifier<StreamConnection, Object> createNotifier(final ClientCallback<ClientConnection> listener) {
        return new IoFuture.Notifier<StreamConnection, Object>(){

            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
    }

    private ChannelListener<StreamConnection> createOpenListener(final ClientCallback<ClientConnection> listener, final Pool<ByteBuffer> bufferPool, final OptionMap options, final URI uri) {
        return new ChannelListener<StreamConnection>(){

            public void handleEvent(StreamConnection connection) {
                HttpClientProvider.this.handleConnected(connection, listener, (Pool<ByteBuffer>)bufferPool, options, uri);
            }
        };
    }

    private void handleConnected(final StreamConnection connection, final ClientCallback<ClientConnection> listener, final Pool<ByteBuffer> bufferPool, final OptionMap options, URI uri) {
        if (options.get(UndertowOptions.ENABLE_SPDY, false) && connection instanceof SslConnection && SpdyClientProvider.isEnabled()) {
            try {
                SpdyClientProvider.handlePotentialSpdyConnection(connection, listener, bufferPool, options, new ChannelListener<SslConnection>(){

                    public void handleEvent(SslConnection channel) {
                        listener.completed(new HttpClientConnection(connection, options, (Pool<ByteBuffer>)bufferPool));
                    }
                });
            }
            catch (Exception e) {
                listener.failed(new IOException(e));
            }
        } else if (options.get(UndertowOptions.ENABLE_HTTP2, false) && connection instanceof SslConnection && Http2ClientProvider.isEnabled()) {
            try {
                Http2ClientProvider.handlePotentialHttp2Connection(connection, listener, bufferPool, options, new ChannelListener<SslConnection>(){

                    public void handleEvent(SslConnection channel) {
                        listener.completed(new HttpClientConnection(connection, options, (Pool<ByteBuffer>)bufferPool));
                    }
                }, uri);
            }
            catch (Exception e) {
                listener.failed(new IOException(e));
            }
        } else {
            if (connection instanceof SslConnection) {
                try {
                    ((SslConnection)connection).startHandshake();
                }
                catch (IOException e) {
                    listener.failed(e);
                }
            }
            listener.completed(new HttpClientConnection(connection, options, bufferPool));
        }
    }
}

