/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileHandlerSymlinksTestCase {
    @Before
    public void createSymlinksScenario() throws IOException, URISyntaxException {
        Assume.assumeFalse((boolean)System.getProperty("os.name").toLowerCase().contains("windows"));
        Path filePath = Paths.get(this.getClass().getResource("page.html").toURI());
        Path rootPath = filePath.getParent();
        Path newDir = rootPath.resolve("newDir");
        Files.createDirectories(newDir, new FileAttribute[0]);
        Path innerDir = newDir.resolve("innerDir");
        Files.createDirectories(innerDir, new FileAttribute[0]);
        Files.copy(filePath, newDir.resolve(filePath.getFileName()), new CopyOption[0]);
        Files.copy(filePath, innerDir.resolve(filePath.getFileName()), new CopyOption[0]);
        Path newSymlink = rootPath.resolve("newSymlink");
        Files.createSymbolicLink(newSymlink, newDir, new FileAttribute[0]);
        Path innerSymlink = newDir.resolve("innerSymlink");
        Files.createSymbolicLink(innerSymlink, innerDir, new FileAttribute[0]);
    }

    @After
    public void deleteSymlinksScenario() throws IOException, URISyntaxException {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        Path newDir = rootPath.resolve("newDir");
        Path page = newDir.resolve("page.html");
        Path innerDir = newDir.resolve("innerDir");
        Path innerSymlink = newDir.resolve("innerSymlink");
        Path innerPage = innerDir.resolve("page.html");
        Files.delete(innerSymlink);
        Files.delete(newSymlink);
        Files.delete(innerPage);
        Files.delete(page);
        Files.delete(innerDir);
        Files.delete(newDir);
    }

    @Test
    public void testCreateSymlinks() throws IOException, URISyntaxException {
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newDir = rootPath.resolve("newDir");
        Assert.assertFalse((boolean)Files.isSymbolicLink(newDir));
        Path innerDir = newDir.resolve("innerDir");
        Assert.assertFalse((boolean)Files.isSymbolicLink(innerDir));
        Path newSymlink = rootPath.resolve("newSymlink");
        Assert.assertTrue((boolean)Files.isSymbolicLink(newSymlink));
        Path innerSymlink = newSymlink.resolve("innerSymlink");
        Assert.assertTrue((boolean)Files.isSymbolicLink(innerSymlink));
        Path f = innerSymlink.getRoot();
        for (int i = 0; i < innerSymlink.getNameCount(); ++i) {
            f = f.resolve(innerSymlink.getName(i).toString());
            System.out.println(f + " " + Files.isSymbolicLink(f));
        }
        f = f.resolve(".");
        System.out.println(f + " " + Files.isSymbolicLink(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultAccessSymlinkDenied() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L)).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedForEmptySafePath() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{""})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedForInsideSymlinks() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newDir");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{""})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerDir/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkGranted() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{"/"})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkGrantedUsingSpecificFilters() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.toAbsolutePath().toString().concat("/newDir")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkGrantedUsingSpecificFiltersWithDirectoryListingEnabled() throws IOException, URISyntaxException {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams((HttpParams)params);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)300000);
        TestHttpClient client = new TestHttpClient((HttpParams)params);
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.toAbsolutePath().toString().concat("/newDir")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"})));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/.");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Header[] headers = result.getHeaders("Content-Type");
            Assert.assertEquals((Object)"text/html", (Object)headers[0].getValue());
            Assert.assertTrue((String)response, (boolean)response.contains("A web page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedUsingSpecificFilters() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.toAbsolutePath().toString().concat("/otherDir")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExplicitAccessSymlinkDeniedUsingSameSymlinkName() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{rootPath.toAbsolutePath().toString().concat("/innerSymlink")})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceManagerBaseSymlink() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{""})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelativePathSymlinkFilter() throws IOException, URISyntaxException {
        TestHttpClient client = new TestHttpClient();
        Path rootPath = Paths.get(this.getClass().getResource("page.html").toURI()).getParent();
        Path newSymlink = rootPath.resolve("newSymlink");
        try {
            DefaultServer.setRootHandler((HttpHandler)new CanonicalPathHandler().setNext((HttpHandler)new PathHandler().addPrefixPath("/path", (HttpHandler)new ResourceHandler((ResourceManager)new PathResourceManager(newSymlink, 0xA00000L, true, new String[]{"innerDir"})).setDirectoryListingEnabled(false).addWelcomeFiles(new String[]{"page.html"}))));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path/innerSymlink/page.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

