/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import java.nio.ByteBuffer;
import org.xnio.Bits;

class Http2DataFrameParser
extends Http2PushBackParser {
    private int padding = 0;

    public Http2DataFrameParser(int frameLength) {
        super(frameLength);
    }

    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser headerParser) {
        if (Bits.anyAreClear((int)headerParser.flags, (int)8)) {
            this.finish();
            return;
        }
        if (resource.remaining() > 0) {
            this.padding = resource.get() & 0xFF;
            this.finish();
        }
    }

    int getPadding() {
        return this.padding;
    }
}

