/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.protocols.ssl.UndertowSslConnection;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.net.ssl.SSLEngine;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.AcceptingChannel;
import org.xnio.ssl.SslConnection;

class UndertowAcceptingSslChannel
implements AcceptingChannel<SslConnection> {
    private final UndertowXnioSsl ssl;
    private final AcceptingChannel<? extends StreamConnection> tcpServer;
    private volatile SslClientAuthMode clientAuthMode;
    private volatile int useClientMode;
    private volatile int enableSessionCreation;
    private volatile String[] cipherSuites;
    private volatile String[] protocols;
    private static final AtomicReferenceFieldUpdater<UndertowAcceptingSslChannel, SslClientAuthMode> clientAuthModeUpdater = AtomicReferenceFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, SslClientAuthMode.class, "clientAuthMode");
    private static final AtomicIntegerFieldUpdater<UndertowAcceptingSslChannel> useClientModeUpdater = AtomicIntegerFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, "useClientMode");
    private static final AtomicIntegerFieldUpdater<UndertowAcceptingSslChannel> enableSessionCreationUpdater = AtomicIntegerFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, "enableSessionCreation");
    private static final AtomicReferenceFieldUpdater<UndertowAcceptingSslChannel, String[]> cipherSuitesUpdater = AtomicReferenceFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, String[].class, "cipherSuites");
    private static final AtomicReferenceFieldUpdater<UndertowAcceptingSslChannel, String[]> protocolsUpdater = AtomicReferenceFieldUpdater.newUpdater(UndertowAcceptingSslChannel.class, String[].class, "protocols");
    private final ChannelListener.Setter<AcceptingChannel<SslConnection>> closeSetter;
    private final ChannelListener.Setter<AcceptingChannel<SslConnection>> acceptSetter;
    protected final boolean startTls;
    protected final Pool<ByteBuffer> applicationBufferPool;
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add(Options.SSL_CLIENT_AUTH_MODE).add(Options.SSL_USE_CLIENT_MODE).add(Options.SSL_ENABLE_SESSION_CREATION).add(Options.SSL_ENABLED_CIPHER_SUITES).add(Options.SSL_ENABLED_PROTOCOLS).create();

    public UndertowAcceptingSslChannel(UndertowXnioSsl ssl, AcceptingChannel<? extends StreamConnection> tcpServer, OptionMap optionMap, Pool<ByteBuffer> applicationBufferPool, boolean startTls) {
        this.tcpServer = tcpServer;
        this.ssl = ssl;
        this.applicationBufferPool = applicationBufferPool;
        this.startTls = startTls;
        this.clientAuthMode = (SslClientAuthMode)optionMap.get(Options.SSL_CLIENT_AUTH_MODE);
        this.useClientMode = optionMap.get(Options.SSL_USE_CLIENT_MODE, false) ? 1 : 0;
        this.enableSessionCreation = optionMap.get(Options.SSL_ENABLE_SESSION_CREATION, true) ? 1 : 0;
        Sequence enabledCipherSuites = (Sequence)optionMap.get(Options.SSL_ENABLED_CIPHER_SUITES);
        this.cipherSuites = enabledCipherSuites != null ? (String[])enabledCipherSuites.toArray((Object[])new String[enabledCipherSuites.size()]) : null;
        Sequence enabledProtocols = (Sequence)optionMap.get(Options.SSL_ENABLED_PROTOCOLS);
        this.protocols = enabledProtocols != null ? (String[])enabledProtocols.toArray((Object[])new String[enabledProtocols.size()]) : null;
        this.closeSetter = ChannelListeners.getDelegatingSetter((ChannelListener.Setter)tcpServer.getCloseSetter(), (Channel)((Object)this));
        this.acceptSetter = ChannelListeners.getDelegatingSetter((ChannelListener.Setter)tcpServer.getAcceptSetter(), (Channel)((Object)this));
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return (T)option.cast((Object)clientAuthModeUpdater.getAndSet(this, (SslClientAuthMode)Options.SSL_CLIENT_AUTH_MODE.cast(value)));
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            Boolean valueObject = (Boolean)Options.SSL_USE_CLIENT_MODE.cast(value);
            if (valueObject != null) {
                return (T)option.cast((Object)(useClientModeUpdater.getAndSet(this, valueObject != false ? 1 : 0) != 0 ? 1 : 0));
            }
        } else if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            Boolean valueObject = (Boolean)Options.SSL_ENABLE_SESSION_CREATION.cast(value);
            if (valueObject != null) {
                return (T)option.cast((Object)(enableSessionCreationUpdater.getAndSet(this, valueObject != false ? 1 : 0) != 0 ? 1 : 0));
            }
        } else {
            if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
                Sequence seq = (Sequence)Options.SSL_ENABLED_CIPHER_SUITES.cast(value);
                return (T)option.cast(cipherSuitesUpdater.getAndSet(this, seq == null ? null : (String[])seq.toArray((Object[])new String[seq.size()])));
            }
            if (option == Options.SSL_ENABLED_PROTOCOLS) {
                Sequence seq = (Sequence)Options.SSL_ENABLED_PROTOCOLS.cast(value);
                return (T)option.cast(protocolsUpdater.getAndSet(this, seq == null ? null : (String[])seq.toArray((Object[])new String[seq.size()])));
            }
            return (T)this.tcpServer.setOption(option, value);
        }
        throw Messages.msg.nullParameter("value");
    }

    public XnioWorker getWorker() {
        return this.tcpServer.getWorker();
    }

    public UndertowSslConnection accept() throws IOException {
        String[] protocols;
        SslClientAuthMode clientAuthMode;
        StreamConnection tcpConnection = (StreamConnection)this.tcpServer.accept();
        if (tcpConnection == null) {
            return null;
        }
        InetSocketAddress peerAddress = (InetSocketAddress)tcpConnection.getPeerAddress(InetSocketAddress.class);
        SSLEngine engine = this.ssl.getSslContext().createSSLEngine(UndertowAcceptingSslChannel.getHostNameNoResolve(peerAddress), peerAddress.getPort());
        boolean clientMode = this.useClientMode != 0;
        engine.setUseClientMode(clientMode);
        if (!clientMode && (clientAuthMode = this.clientAuthMode) != null) {
            switch (clientAuthMode) {
                case NOT_REQUESTED: {
                    engine.setNeedClientAuth(false);
                    engine.setWantClientAuth(false);
                    break;
                }
                case REQUESTED: {
                    engine.setWantClientAuth(true);
                    break;
                }
                case REQUIRED: {
                    engine.setNeedClientAuth(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        engine.setEnableSessionCreation(this.enableSessionCreation != 0);
        String[] cipherSuites = this.cipherSuites;
        if (cipherSuites != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedCipherSuites()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : cipherSuites) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledCipherSuites(finalList.toArray(new String[finalList.size()]));
        }
        if ((protocols = this.protocols) != null) {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(engine.getSupportedProtocols()));
            ArrayList<String> finalList = new ArrayList<String>();
            for (String name : protocols) {
                if (!supported.contains(name)) continue;
                finalList.add(name);
            }
            engine.setEnabledProtocols(finalList.toArray(new String[finalList.size()]));
        }
        return this.accept(tcpConnection, engine);
    }

    protected UndertowSslConnection accept(StreamConnection tcpServer, SSLEngine sslEngine) throws IOException {
        return new UndertowSslConnection(tcpServer, sslEngine, this.applicationBufferPool);
    }

    public ChannelListener.Setter<? extends AcceptingChannel<SslConnection>> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean isOpen() {
        return this.tcpServer.isOpen();
    }

    public void close() throws IOException {
        this.tcpServer.close();
    }

    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.tcpServer.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return (T)option.cast((Object)this.clientAuthMode);
        }
        if (option == Options.SSL_USE_CLIENT_MODE) {
            return (T)option.cast((Object)(this.useClientMode != 0 ? 1 : 0));
        }
        if (option == Options.SSL_ENABLE_SESSION_CREATION) {
            return (T)option.cast((Object)(this.enableSessionCreation != 0 ? 1 : 0));
        }
        if (option == Options.SSL_ENABLED_CIPHER_SUITES) {
            Object[] cipherSuites = this.cipherSuites;
            return (T)(cipherSuites == null ? null : option.cast((Object)Sequence.of((Object[])cipherSuites)));
        }
        if (option == Options.SSL_ENABLED_PROTOCOLS) {
            Object[] protocols = this.protocols;
            return (T)(protocols == null ? null : option.cast((Object)Sequence.of((Object[])protocols)));
        }
        return (T)this.tcpServer.getOption(option);
    }

    public ChannelListener.Setter<? extends AcceptingChannel<SslConnection>> getAcceptSetter() {
        return this.acceptSetter;
    }

    public SocketAddress getLocalAddress() {
        return this.tcpServer.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.tcpServer.getLocalAddress(type);
    }

    public void suspendAccepts() {
        this.tcpServer.suspendAccepts();
    }

    public void resumeAccepts() {
        this.tcpServer.resumeAccepts();
    }

    public boolean isAcceptResumed() {
        return this.tcpServer.isAcceptResumed();
    }

    public void wakeupAccepts() {
        this.tcpServer.wakeupAccepts();
    }

    public void awaitAcceptable() throws IOException {
        this.tcpServer.awaitAcceptable();
    }

    public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
        this.tcpServer.awaitAcceptable(time, timeUnit);
    }

    @Deprecated
    public XnioExecutor getAcceptThread() {
        return this.tcpServer.getAcceptThread();
    }

    public XnioIoThread getIoThread() {
        return this.tcpServer.getIoThread();
    }

    private static String getHostNameNoResolve(InetSocketAddress socketAddress) {
        InetAddress address;
        String string;
        int slash;
        if (Xnio.NIO2) {
            return socketAddress.getHostString();
        }
        String hostName = socketAddress.isUnresolved() ? socketAddress.getHostName() : ((slash = (string = (address = socketAddress.getAddress()).toString()).indexOf(47)) == -1 || slash == 0 ? string.substring(slash + 1) : string.substring(0, slash));
        return hostName;
    }
}

