/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CookieHandlingTestCase {
    @BeforeClass
    public static void setup() {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.setResponseCookie((Cookie)new CookieImpl("hello", "world").setDomain("a.b.c"));
                exchange.setResponseCookie((Cookie)new CookieImpl("hello", "world").setDomain("d.e.f"));
                exchange.getResponseSender().send("");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleCookieSupport() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/somepath");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] headers = result.getHeaders("Set-Cookie");
            Assert.assertEquals((long)headers.length, (long)2L);
            Assert.assertEquals((Object)headers[0].getValue(), (Object)"hello=world; domain=a.b.c");
            Assert.assertEquals((Object)headers[1].getValue(), (Object)"hello=world; domain=d.e.f");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

