/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.sse;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;

public class ServerSentEventConnection
implements Channel,
Attachable {
    private final HttpServerExchange exchange;
    private final StreamSinkChannel sink;
    private final SseWriteListener writeListener = new SseWriteListener();
    private PooledByteBuffer pooled;
    private final Deque<SSEData> queue = new ConcurrentLinkedDeque<SSEData>();
    private final Queue<SSEData> buffered = new ConcurrentLinkedDeque<SSEData>();
    private final List<ChannelListener<ServerSentEventConnection>> closeTasks = new CopyOnWriteArrayList<ChannelListener<ServerSentEventConnection>>();
    private Map<String, String> parameters;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final AtomicIntegerFieldUpdater<ServerSentEventConnection> openUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerSentEventConnection.class, "open");
    private volatile int open = 1;
    private volatile boolean shutdown = false;
    private volatile long keepAliveTime = -1L;
    private XnioExecutor.Key timerKey;

    public ServerSentEventConnection(HttpServerExchange exchange, StreamSinkChannel sink) {
        this.exchange = exchange;
        this.sink = sink;
        this.sink.getCloseSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){

            public void handleEvent(StreamSinkChannel channel) {
                if (ServerSentEventConnection.this.timerKey != null) {
                    ServerSentEventConnection.this.timerKey.remove();
                }
                for (ChannelListener listener : ServerSentEventConnection.this.closeTasks) {
                    ChannelListeners.invokeChannelListener((Channel)ServerSentEventConnection.this, (ChannelListener)listener);
                }
            }
        });
        this.sink.getWriteSetter().set((ChannelListener)this.writeListener);
    }

    public void addCloseTask(ChannelListener<ServerSentEventConnection> listener) {
        this.closeTasks.add(listener);
    }

    public Principal getPrincipal() {
        Account account = this.getAccount();
        if (account != null) {
            return account.getPrincipal();
        }
        return null;
    }

    public Account getAccount() {
        SecurityContext sc = this.exchange.getSecurityContext();
        if (sc != null) {
            return sc.getAuthenticatedAccount();
        }
        return null;
    }

    public HeaderMap getRequestHeaders() {
        return this.exchange.getRequestHeaders();
    }

    public HeaderMap getResponseHeaders() {
        return this.exchange.getResponseHeaders();
    }

    public String getRequestURI() {
        return this.exchange.getRequestURI();
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.exchange.getQueryParameters();
    }

    public String getQueryString() {
        return this.exchange.getQueryString();
    }

    public void send(String data) {
        this.send(data, null, null, null);
    }

    public void send(String data, EventCallback callback) {
        this.send(data, null, null, callback);
    }

    public void send(String data, String event, String id, EventCallback callback) {
        if (this.open == 0 || this.shutdown) {
            if (callback != null) {
                callback.failed(this, event, data, id, new ClosedChannelException());
            }
            return;
        }
        this.queue.add(new SSEData(event, data, id, callback));
        this.sink.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                if (ServerSentEventConnection.this.pooled == null) {
                    ServerSentEventConnection.this.fillBuffer();
                    ServerSentEventConnection.this.writeListener.handleEvent(ServerSentEventConnection.this.sink);
                }
            }
        });
    }

    public String getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        if (this.timerKey != null) {
            this.timerKey.remove();
        }
        this.timerKey = this.sink.getIoThread().executeAtInterval(new Runnable(){

            @Override
            public void run() {
                if (ServerSentEventConnection.this.shutdown || ServerSentEventConnection.this.open == 0) {
                    if (ServerSentEventConnection.this.timerKey != null) {
                        ServerSentEventConnection.this.timerKey.remove();
                    }
                    return;
                }
                if (ServerSentEventConnection.this.pooled == null) {
                    ServerSentEventConnection.this.pooled = ServerSentEventConnection.this.exchange.getConnection().getByteBufferPool().allocate();
                    ServerSentEventConnection.this.pooled.getBuffer().put(":\n".getBytes(StandardCharsets.UTF_8));
                    ServerSentEventConnection.this.pooled.getBuffer().flip();
                    ServerSentEventConnection.this.writeListener.handleEvent(ServerSentEventConnection.this.sink);
                }
            }
        }, keepAliveTime, TimeUnit.MILLISECONDS);
    }

    private void fillBuffer() {
        if (this.queue.isEmpty()) {
            if (this.pooled != null) {
                this.pooled.close();
                this.pooled = null;
                this.sink.suspendWrites();
            }
            return;
        }
        if (this.pooled == null) {
            this.pooled = this.exchange.getConnection().getByteBufferPool().allocate();
        } else {
            this.pooled.getBuffer().clear();
        }
        ByteBuffer buffer = this.pooled.getBuffer();
        while (!this.queue.isEmpty() && buffer.hasRemaining()) {
            SSEData data = this.queue.poll();
            this.buffered.add(data);
            if (data.leftOverData == null) {
                StringBuilder message = new StringBuilder();
                if (data.id != null) {
                    message.append("id:");
                    message.append(data.id);
                    message.append('\n');
                }
                if (data.event != null) {
                    message.append("event:");
                    message.append(data.event);
                    message.append('\n');
                }
                if (data.data != null) {
                    message.append("data:");
                    message.append(data.data);
                    message.append('\n');
                }
                message.append('\n');
                byte[] messageBytes = message.toString().getBytes(StandardCharsets.UTF_8);
                if (messageBytes.length < buffer.remaining()) {
                    buffer.put(messageBytes);
                    data.endBufferPosition = buffer.position();
                    continue;
                }
                this.queue.addFirst(data);
                int rem = buffer.remaining();
                buffer.put(messageBytes, 0, rem);
                SSEData.access$1102(data, messageBytes);
                data.leftOverDataOffset = rem;
                continue;
            }
            int remainingData = data.leftOverData.length - data.leftOverDataOffset;
            if (remainingData > buffer.remaining()) {
                this.queue.addFirst(data);
                int toWrite = buffer.remaining();
                buffer.put(data.leftOverData, data.leftOverDataOffset, toWrite);
                SSEData sSEData = data;
                sSEData.leftOverDataOffset = sSEData.leftOverDataOffset + toWrite;
                continue;
            }
            buffer.put(data.leftOverData, data.leftOverDataOffset, remainingData);
            data.endBufferPosition = buffer.position();
            SSEData.access$1102(data, null);
        }
        buffer.flip();
        this.sink.resumeWrites();
    }

    public void shutdown() {
        if (this.open == 0 || this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.sink.getIoThread().execute(new Runnable(){

            @Override
            public void run() {
                if (ServerSentEventConnection.this.queue.isEmpty() && ServerSentEventConnection.this.pooled == null) {
                    try {
                        ServerSentEventConnection.this.sink.shutdownWrites();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    IoUtils.safeClose((Closeable)ServerSentEventConnection.this);
                }
            }
        });
    }

    @Override
    public boolean isOpen() {
        return this.open != 0;
    }

    @Override
    public void close() throws IOException {
        if (openUpdater.compareAndSet(this, 1, 0)) {
            if (this.pooled != null) {
                this.pooled.close();
                this.pooled = null;
            }
            this.queue.clear();
            this.buffered.clear();
            this.sink.shutdownWrites();
            if (!this.sink.flush()) {
                this.sink.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                    public void handleException(StreamSinkChannel channel, IOException exception) {
                        IoUtils.safeClose((Closeable)ServerSentEventConnection.this.sink);
                    }
                }));
            }
        }
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        return this.exchange.getAttachment(key);
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        return this.exchange.getAttachmentList(key);
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return this.exchange.putAttachment(key, value);
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        return this.exchange.removeAttachment(key);
    }

    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        this.exchange.addToAttachmentList(key, value);
    }

    private void handleException(IOException e) {
        for (SSEData i : this.buffered) {
            if (i.callback == null) continue;
            i.callback.failed(this, i.data, i.event, i.id, e);
        }
        for (SSEData i : this.queue) {
            if (i.callback == null) continue;
            i.callback.failed(this, i.data, i.event, i.id, e);
        }
        IoUtils.safeClose((Closeable)this);
    }

    private class SseWriteListener
    implements ChannelListener<StreamSinkChannel> {
        private SseWriteListener() {
        }

        public void handleEvent(StreamSinkChannel channel) {
            try {
                int res;
                if (ServerSentEventConnection.this.pooled == null) {
                    if (!channel.flush()) {
                        return;
                    }
                    channel.suspendWrites();
                    return;
                }
                ByteBuffer buffer = ServerSentEventConnection.this.pooled.getBuffer();
                do {
                    SSEData data;
                    res = channel.write(buffer);
                    while (!ServerSentEventConnection.this.buffered.isEmpty() && (data = (SSEData)ServerSentEventConnection.this.buffered.peek()).endBufferPosition > 0 && buffer.position() >= data.endBufferPosition) {
                        if (data.callback != null) {
                            data.callback.done(ServerSentEventConnection.this, data.data, data.event, data.id);
                        }
                        ServerSentEventConnection.this.buffered.poll();
                    }
                    if (res == 0) {
                        ServerSentEventConnection.this.sink.resumeWrites();
                        return;
                    }
                    if (!buffer.hasRemaining()) {
                        ServerSentEventConnection.this.fillBuffer();
                    }
                    if (channel.flush()) continue;
                    ServerSentEventConnection.this.sink.resumeWrites();
                    return;
                } while (res > 0);
            }
            catch (IOException e) {
                ServerSentEventConnection.this.handleException(e);
            }
        }
    }

    private static class SSEData {
        final String event;
        final String data;
        final String id;
        final EventCallback callback;
        private int endBufferPosition = -1;
        private byte[] leftOverData;
        private int leftOverDataOffset;

        private SSEData(String event, String data, String id, EventCallback callback) {
            this.event = event;
            this.data = data;
            this.id = id;
            this.callback = callback;
        }

        static /* synthetic */ byte[] access$1102(SSEData x0, byte[] x1) {
            x0.leftOverData = x1;
            return x1;
        }
    }

    public static interface EventCallback {
        public void done(ServerSentEventConnection var1, String var2, String var3, String var4);

        public void failed(ServerSentEventConnection var1, String var2, String var3, String var4, IOException var5);
    }
}

