/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.AbstractLoadBalancingProxyTestCase;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.testutils.DefaultServer;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
public class LoadBalancingProxySPDYTestCase
extends AbstractLoadBalancingProxyTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        final HttpHandler handler1 = LoadBalancingProxySPDYTestCase.getRootHandler("s1", "server1");
        server1 = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_SPDY, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                System.out.println(exchange.getRequestHeaders());
                handler1.handleRequest(exchange);
            }
        }).build();
        final HttpHandler handler2 = LoadBalancingProxySPDYTestCase.getRootHandler("s2", "server2");
        server2 = Undertow.builder().addHttpsListener(port + 2, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_SPDY, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                System.out.println(exchange.getRequestHeaders());
                handler2.handleRequest(exchange);
            }
        }).build();
        server1.start();
        server2.start();
        UndertowXnioSsl ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, (ByteBufferPool)DefaultServer.SSL_BUFFER_POOL, DefaultServer.createClientSslContext());
        DefaultServer.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 1, null, null, null), "s1", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_SPDY, (Object)true)).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 2, null, null, null), "s2", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_SPDY, (Object)true)), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404));
    }

    @Before
    public void requireAlpn() {
        DefaultServer.assumeAlpnEnabled();
    }
}

