/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.mina.util.ConcurrentHashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@ProxyIgnore
public class LoadBalancerConnectionPoolingTestCase {
    private static Undertow undertow;
    private static final Set<ServerConnection> activeConnections;
    static final String host;
    static int port;

    @BeforeClass
    public static void before() throws Exception {
        ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).setSoftMaxConnectionsPerThread(0).setTtl(1000).addHost(new URI("http", null, host, port, null, null, null), "s1"), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404);
        undertow = Undertow.builder().setIoThreads(1).addHttpListener(port + 1, host).setHandler((HttpHandler)proxyHandler).build();
        undertow.start();
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ServerConnection con = exchange.getConnection();
                if (!activeConnections.contains(con)) {
                    activeConnections.add(con);
                    con.addCloseListener(new ServerConnection.CloseListener(){

                        public void closed(ServerConnection connection) {
                            activeConnections.remove(connection);
                        }
                    });
                }
            }
        });
    }

    @AfterClass
    public static void after() {
        undertow.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReduceConnectionPool() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        PoolingClientConnectionManager conman = new PoolingClientConnectionManager();
        conman.setDefaultMaxPerRoute(20);
        final TestHttpClient client = new TestHttpClient((ClientConnectionManager)conman);
        int requests = 1000;
        final CountDownLatch latch = new CountDownLatch(requests);
        try {
            for (int i = 0; i < requests; ++i) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        HttpGet get = new HttpGet("http://" + host + ":" + (port + 1));
                        try {
                            client.execute((HttpUriRequest)get, (ResponseHandler)new ResponseHandler<HttpResponse>(){

                                public HttpResponse handleResponse(HttpResponse response) throws IOException {
                                    latch.countDown();
                                    Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
                                    return response;
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            latch.await(2000L, TimeUnit.MILLISECONDS);
        }
        finally {
            executorService.shutdownNow();
            client.getConnectionManager().shutdown();
        }
        Assert.assertEquals((long)1L, (long)activeConnections.size());
        long end = System.currentTimeMillis() + 4000L;
        while (!activeConnections.isEmpty() && System.currentTimeMillis() < end) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)0L, (long)activeConnections.size());
    }

    static {
        activeConnections = new ConcurrentHashSet();
        host = DefaultServer.getHostAddress("default");
        port = DefaultServer.getHostPort("default");
    }
}

