/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.server.BasicSSLSessionInfo;
import io.undertow.util.HttpString;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.security.cert.CertificateException;

class AjpRequestParseState {
    public static final int BEGIN = 0;
    public static final int READING_MAGIC_NUMBER = 1;
    public static final int READING_DATA_SIZE = 2;
    public static final int READING_PREFIX_CODE = 3;
    public static final int READING_METHOD = 4;
    public static final int READING_PROTOCOL = 5;
    public static final int READING_REQUEST_URI = 6;
    public static final int READING_REMOTE_ADDR = 7;
    public static final int READING_REMOTE_HOST = 8;
    public static final int READING_SERVER_NAME = 9;
    public static final int READING_SERVER_PORT = 10;
    public static final int READING_IS_SSL = 11;
    public static final int READING_NUM_HEADERS = 12;
    public static final int READING_HEADERS = 13;
    public static final int READING_ATTRIBUTES = 14;
    public static final int DONE = 15;
    int state;
    byte prefix;
    int dataSize;
    int numHeaders = 0;
    HttpString currentHeader;
    String currentAttribute;
    Map<String, String> attributes;
    String remoteAddress;
    int remotePort = -1;
    int serverPort = 80;
    String serverAddress;
    public int stringLength = -1;
    private byte[] currentString = new byte[16];
    private int currentStringLength = 0;
    public int currentIntegerPart = -1;
    boolean containsUrlCharacters = false;
    public int readHeaders = 0;
    public String sslSessionId;
    public String sslCipher;
    public String sslCert;
    public String sslKeySize;

    AjpRequestParseState() {
    }

    public void reset() {
        this.stringLength = -1;
        this.currentStringLength = 0;
        this.currentIntegerPart = -1;
        this.readHeaders = 0;
    }

    public boolean isComplete() {
        return this.state == 15;
    }

    BasicSSLSessionInfo createSslSessionInfo() {
        String sessionId = this.sslSessionId;
        String cypher = this.sslCipher;
        String cert = this.sslCert;
        if (cert == null && sessionId == null) {
            return null;
        }
        try {
            return new BasicSSLSessionInfo(sessionId, cypher, cert);
        }
        catch (java.security.cert.CertificateException e) {
            return null;
        }
        catch (CertificateException e) {
            return null;
        }
    }

    InetSocketAddress createPeerAddress() {
        if (this.remoteAddress == null) {
            return null;
        }
        int port = this.remotePort > 0 ? this.remotePort : 0;
        try {
            InetAddress address = InetAddress.getByName(this.remoteAddress);
            return new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    InetSocketAddress createDestinationAddress() {
        if (this.serverAddress == null) {
            return null;
        }
        return InetSocketAddress.createUnresolved(this.serverAddress, this.serverPort);
    }

    public void addStringByte(byte b) {
        if (this.currentString.length == this.currentStringLength) {
            byte[] old = this.currentString;
            this.currentString = new byte[this.currentStringLength + 16];
            System.arraycopy(old, 0, this.currentString, 0, this.currentStringLength);
        }
        this.currentString[this.currentStringLength++] = b;
    }

    public String getStringAndClear(String charset) throws UnsupportedEncodingException {
        String ret = new String(this.currentString, 0, this.currentStringLength, charset);
        this.currentStringLength = 0;
        return ret;
    }

    public int getCurrentStringLength() {
        return this.currentStringLength;
    }
}

