/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.framed;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.protocol.framed.AbstractFramedChannel;
import io.undertow.server.protocol.framed.AbstractFramedStreamSourceChannel;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class AbstractFramedStreamSinkChannel<C extends AbstractFramedChannel<C, R, S>, R extends AbstractFramedStreamSourceChannel<C, R, S>, S extends AbstractFramedStreamSinkChannel<C, R, S>>
implements StreamSinkChannel {
    private static final PooledByteBuffer EMPTY_BYTE_BUFFER = new ImmediatePooledByteBuffer(ByteBuffer.allocateDirect(0));
    private final C channel;
    private final ChannelListener.SimpleSetter<S> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<S> closeSetter = new ChannelListener.SimpleSetter();
    private final Object lock = new Object();
    private volatile int state = 0;
    private volatile boolean readyForFlush;
    private volatile boolean fullyFlushed;
    private volatile boolean finalFrameQueued;
    private volatile boolean broken;
    private volatile int waiterCount = 0;
    private volatile SendFrameHeader header;
    private volatile PooledByteBuffer writeBuffer;
    private volatile PooledByteBuffer body;
    private volatile PooledByteBuffer trailer;
    private static final int STATE_CLOSED = 1;
    private static final int STATE_WRITES_SHUTDOWN = 2;
    private static final int STATE_FIRST_DATA_WRITTEN = 4;
    private static final int STATE_PRE_WRITE_CALLED = 8;
    private volatile boolean writesResumed;
    private volatile int inListenerLoop;
    private static final AtomicIntegerFieldUpdater<AbstractFramedStreamSinkChannel> inListenerLoopUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractFramedStreamSinkChannel.class, "inListenerLoop");

    protected AbstractFramedStreamSinkChannel(C channel) {
        this.channel = channel;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)((Object)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)((Object)this));
    }

    public void suspendWrites() {
        this.writesResumed = false;
    }

    final SendFrameHeader getFrameHeader() throws IOException {
        if (this.header == null) {
            this.header = this.createFrameHeader();
            if (this.header == null) {
                this.header = new SendFrameHeader(0, null);
            }
        }
        return this.header;
    }

    protected SendFrameHeader createFrameHeader() throws IOException {
        return null;
    }

    final ByteBuffer getFrameFooter() {
        if (this.trailer == null) {
            this.trailer = this.createFrameFooter();
            if (this.trailer == null) {
                this.trailer = EMPTY_BYTE_BUFFER;
            }
        }
        return this.trailer.getBuffer();
    }

    protected PooledByteBuffer createFrameFooter() {
        return null;
    }

    final void preWrite() {
        if (Bits.allAreClear((int)this.state, (int)8)) {
            this.state |= 8;
            this.body = this.preWriteTransform(this.body);
        }
    }

    protected PooledByteBuffer preWriteTransform(PooledByteBuffer body) {
        return body;
    }

    public boolean isWriteResumed() {
        return this.writesResumed;
    }

    public void wakeupWrites() {
        this.resumeWritesInternal(true);
    }

    public void resumeWrites() {
        this.resumeWritesInternal(false);
    }

    protected void resumeWritesInternal(boolean wakeup) {
        boolean alreadyResumed = this.writesResumed;
        if (!wakeup && alreadyResumed) {
            return;
        }
        this.writesResumed = true;
        if (this.readyForFlush && !wakeup) {
            return;
        }
        if (inListenerLoopUpdater.compareAndSet(this, 0, 1)) {
            ((AbstractFramedChannel)this.getChannel()).runInIoThread(new Runnable(){
                int loopCount = 0;

                @Override
                public void run() {
                    try {
                        ChannelListener listener = AbstractFramedStreamSinkChannel.this.getWriteListener();
                        if (listener == null || !AbstractFramedStreamSinkChannel.this.isWriteResumed()) {
                            return;
                        }
                        if (this.loopCount++ == 100) {
                            UndertowLogger.ROOT_LOGGER.listenerNotProgressing();
                            IoUtils.safeClose((Closeable)((Object)AbstractFramedStreamSinkChannel.this));
                            return;
                        }
                        ChannelListeners.invokeChannelListener((Channel)((Object)AbstractFramedStreamSinkChannel.this), listener);
                    }
                    finally {
                        inListenerLoopUpdater.set(AbstractFramedStreamSinkChannel.this, 0);
                    }
                    if (AbstractFramedStreamSinkChannel.this.writesResumed && Bits.allAreClear((int)AbstractFramedStreamSinkChannel.this.state, (int)1) && !AbstractFramedStreamSinkChannel.this.broken && !AbstractFramedStreamSinkChannel.this.readyForFlush && !AbstractFramedStreamSinkChannel.this.fullyFlushed && inListenerLoopUpdater.compareAndSet(AbstractFramedStreamSinkChannel.this, 0, 1)) {
                        AbstractFramedStreamSinkChannel.this.getIoThread().execute((Runnable)this);
                    }
                }
            });
        }
    }

    public void shutdownWrites() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2) || this.broken) {
            return;
        }
        this.queueFinalFrame();
        this.state |= 2;
    }

    private void queueFinalFrame() throws IOException {
        if (!(this.readyForFlush || this.fullyFlushed || !Bits.allAreClear((int)this.state, (int)1) || this.broken || this.finalFrameQueued)) {
            if (null == this.body && null != this.writeBuffer) {
                this.sendWriteBuffer();
            } else if (null == this.body) {
                this.body = EMPTY_BYTE_BUFFER;
            }
            this.readyForFlush = true;
            this.state |= 4;
            this.state |= 2;
            this.finalFrameQueued = true;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
    }

    protected boolean isFinalFrameQueued() {
        return this.finalFrameQueued;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable() throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet((int)this.state, (int)1) || this.broken) {
                return;
            }
            if (this.readyForFlush) {
                try {
                    ++this.waiterCount;
                    if (this.readyForFlush && !Bits.anyAreSet((int)this.state, (int)1) && !this.broken) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                finally {
                    --this.waiterCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitWritable(long l, TimeUnit timeUnit) throws IOException {
        if (Thread.currentThread() == this.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Object object = this.lock;
        synchronized (object) {
            if (Bits.anyAreSet((int)this.state, (int)1) || this.broken) {
                return;
            }
            if (this.readyForFlush) {
                try {
                    ++this.waiterCount;
                    if (this.readyForFlush && !Bits.anyAreSet((int)this.state, (int)1) && !this.broken) {
                        this.lock.wait(timeUnit.toMillis(l));
                    }
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
                finally {
                    --this.waiterCount;
                }
            }
        }
    }

    public XnioExecutor getWriteThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public ChannelListener.Setter<? extends S> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends S> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return ((AbstractFramedChannel)this.channel).getWorker();
    }

    public XnioIoThread getIoThread() {
        return ((AbstractFramedChannel)this.channel).getIoThread();
    }

    public boolean flush() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            return true;
        }
        if (this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        if (this.readyForFlush) {
            return false;
        }
        if (this.fullyFlushed) {
            this.state |= 1;
            return true;
        }
        if (Bits.anyAreSet((int)this.state, (int)2) && !this.finalFrameQueued) {
            this.queueFinalFrame();
            return false;
        }
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return false;
        }
        if (this.isFlushRequiredOnEmptyBuffer() || this.writeBuffer != null && this.writeBuffer.getBuffer().position() > 0) {
            this.handleBufferFull();
            return !this.readyForFlush;
        }
        return true;
    }

    protected boolean isFlushRequiredOnEmptyBuffer() {
        return false;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.safeToSend()) {
            return 0L;
        }
        if (this.writeBuffer == null) {
            this.writeBuffer = ((AbstractFramedChannel)this.getChannel()).getBufferPool().allocate();
        }
        ByteBuffer buffer = this.writeBuffer.getBuffer();
        int copied = Buffers.copy((ByteBuffer)buffer, (ByteBuffer[])srcs, (int)offset, (int)length);
        if (!buffer.hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public int write(ByteBuffer src) throws IOException {
        if (!this.safeToSend()) {
            return 0;
        }
        if (this.writeBuffer == null) {
            this.writeBuffer = ((AbstractFramedChannel)this.getChannel()).getBufferPool().allocate();
        }
        ByteBuffer buffer = this.writeBuffer.getBuffer();
        int copied = Buffers.copy((ByteBuffer)buffer, (ByteBuffer)src);
        if (!buffer.hasRemaining()) {
            this.handleBufferFull();
        }
        return copied;
    }

    public boolean send(PooledByteBuffer pooled) throws IOException {
        if (this.isWritesShutdown()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.sendInternal(pooled);
    }

    protected boolean sendInternal(PooledByteBuffer pooled) throws IOException {
        if (this.safeToSend()) {
            this.body = pooled;
            return true;
        }
        return false;
    }

    protected boolean safeToSend() throws IOException {
        int state = this.state;
        if (this.readyForFlush) {
            return false;
        }
        if (null != this.body) {
            return false;
        }
        if (Bits.anyAreSet((int)state, (int)1) || this.broken) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return true;
    }

    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer[])srcs, (int)offset, (int)length);
    }

    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.writeFinal(srcs, 0, srcs.length);
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Channels.writeFinalBasic((StreamSinkChannel)this, (ByteBuffer)src);
    }

    private void handleBufferFull() throws IOException {
        if (!this.readyForFlush) {
            this.sendWriteBuffer();
            this.readyForFlush = true;
            this.state |= 4;
            ((AbstractFramedChannel)this.channel).queueFrame((AbstractFramedStreamSinkChannel)this);
        }
    }

    private void sendWriteBuffer() throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = EMPTY_BYTE_BUFFER;
        }
        this.writeBuffer.getBuffer().flip();
        if (!this.sendInternal(this.writeBuffer)) {
            throw UndertowMessages.MESSAGES.failedToSendAfterBeingSafe();
        }
        this.writeBuffer = null;
    }

    protected abstract boolean isLastFrame();

    public boolean isReadyForFlush() {
        return this.readyForFlush;
    }

    public boolean isWritesShutdown() {
        return Bits.anyAreSet((int)this.state, (int)2);
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)1);
    }

    public void close() throws IOException {
        if (this.fullyFlushed || Bits.anyAreSet((int)this.state, (int)1)) {
            return;
        }
        try {
            this.state |= 1;
            if (this.writeBuffer != null) {
                this.writeBuffer.close();
                this.writeBuffer = null;
            }
            if (this.body != null) {
                this.body.close();
                this.body = null;
            }
            if (this.header != null && this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().close();
                this.header = null;
            }
            if (this.trailer != null) {
                this.trailer.close();
                this.trailer = null;
            }
            if (Bits.anyAreSet((int)this.state, (int)4)) {
                this.channelForciblyClosed();
            }
            if (this.isWriteResumed()) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), this.getWriteListener());
            }
            this.wakeupWrites();
        }
        finally {
            this.wakeupWaiters();
        }
    }

    protected void channelForciblyClosed() throws IOException {
        if (this.isFirstDataWritten()) {
            ((AbstractFramedChannel)this.getChannel()).markWritesBroken(null);
        }
        this.wakeupWaiters();
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> tOption) throws IOException {
        return null;
    }

    public <T> T setOption(Option<T> tOption, T t) throws IllegalArgumentException, IOException {
        return null;
    }

    public ByteBuffer getBuffer() {
        if (Bits.anyAreSet((int)this.state, (int)1)) {
            throw new IllegalStateException();
        }
        if (this.body == null) {
            this.body = EMPTY_BYTE_BUFFER;
        }
        return this.body.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void flushComplete() throws IOException {
        try {
            boolean channelClosed;
            int remaining = this.header.getRemainingInBuffer();
            boolean finalFrame = this.finalFrameQueued;
            boolean bl = channelClosed = finalFrame && remaining == 0 && !this.header.isAnotherFrameRequired();
            if (remaining > 0) {
                this.body.getBuffer().limit(this.body.getBuffer().limit() + remaining);
                if (finalFrame) {
                    this.finalFrameQueued = false;
                }
            } else if (this.header.isAnotherFrameRequired()) {
                this.finalFrameQueued = false;
                if (this.body != null) {
                    this.body.close();
                    this.body = null;
                    this.state &= 0xFFFFFFF7;
                }
            } else if (this.body != null) {
                this.body.close();
                this.body = null;
                this.state &= 0xFFFFFFF7;
            }
            if (channelClosed) {
                this.fullyFlushed = true;
                if (this.body != null) {
                    this.body.close();
                    this.body = null;
                    this.state &= 0xFFFFFFF7;
                }
            } else if (this.body != null) {
                this.body.getBuffer().compact();
                this.writeBuffer = this.body;
                this.body = null;
                this.state &= 0xFFFFFFF7;
            }
            if (this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().close();
            }
            this.trailer.close();
            this.header = null;
            this.trailer = null;
            this.readyForFlush = false;
            if (this.isWriteResumed() && !channelClosed) {
                this.wakeupWrites();
            } else if (this.isWriteResumed()) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), this.getWriteListener());
            }
            ChannelListener closeListener = this.closeSetter.get();
            if (channelClosed && closeListener != null) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), (ChannelListener)closeListener);
            }
            this.handleFlushComplete(channelClosed);
        }
        finally {
            this.wakeupWaiters();
        }
    }

    protected void handleFlushComplete(boolean finalFrame) {
    }

    protected boolean isFirstDataWritten() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public void markBroken() {
        this.broken = true;
        try {
            ChannelListener closeListener;
            ChannelListener writeListener;
            this.wakeupWrites();
            this.wakeupWaiters();
            if (this.isWriteResumed() && (writeListener = this.writeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), (ChannelListener)writeListener);
            }
            if ((closeListener = this.closeSetter.get()) != null) {
                ChannelListeners.invokeChannelListener((Executor)this.getIoThread(), (Channel)((Object)this), (ChannelListener)closeListener);
            }
        }
        finally {
            if (this.header != null && this.header.getByteBuffer() != null) {
                this.header.getByteBuffer().close();
                this.header = null;
            }
            if (this.trailer != null) {
                this.trailer.close();
                this.trailer = null;
            }
            if (this.body != null) {
                this.body.close();
                this.body = null;
            }
            if (this.writeBuffer != null) {
                this.writeBuffer.close();
                this.writeBuffer = null;
            }
        }
    }

    ChannelListener<? super S> getWriteListener() {
        return this.writeSetter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupWaiters() {
        if (this.waiterCount > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public C getChannel() {
        return this.channel;
    }

    public boolean isBroken() {
        return this.broken;
    }
}

