/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.UndertowLogger;
import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.SslConnection;

public class JettyALPNClientProvider
implements ALPNClientSelector.ClientSelector {
    private static final String PROTOCOL_KEY;
    private static final Method ALPN_PUT_METHOD;

    @Override
    public void runAlpn(final SslConnection connection, final ChannelListener<SslConnection> fallback, final ClientCallback<ClientConnection> failedListener, ALPNClientSelector.ALPNProtocol ... details) {
        final SslConnection sslConnection = connection;
        final SSLEngine sslEngine = UndertowXnioSsl.getSslEngine(sslConnection);
        final HashMap<String, ALPNClientSelector.ALPNProtocol> protocolMap = new HashMap<String, ALPNClientSelector.ALPNProtocol>();
        ArrayList<String> protocols = new ArrayList<String>(details.length);
        for (int i = 0; i < details.length; ++i) {
            protocols.add(details[i].getProtocol());
            protocolMap.put(details[i].getProtocol(), details[i]);
        }
        final ALPNSelectionProvider selectionProvider = new ALPNSelectionProvider(protocols, sslEngine);
        try {
            ALPN_PUT_METHOD.invoke(null, sslEngine, selectionProvider);
        }
        catch (Exception e) {
            fallback.handleEvent((Channel)sslConnection);
            return;
        }
        try {
            sslConnection.startHandshake();
            sslConnection.getSourceChannel().getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                public void handleEvent(StreamSourceChannel channel) {
                    if (selectionProvider.selected != null) {
                        this.handleSelected(selectionProvider.selected);
                    } else {
                        ByteBuffer buf = ByteBuffer.allocate(100);
                        try {
                            int read = channel.read(buf);
                            if (read > 0) {
                                buf.flip();
                                PushBackStreamSourceConduit pb = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
                                pb.pushBack(new ImmediatePooled<ByteBuffer>(buf));
                                connection.getSourceChannel().setConduit((StreamSourceConduit)pb);
                            }
                            if (selectionProvider.selected == null) {
                                selectionProvider.selected = (String)sslEngine.getSession().getValue(PROTOCOL_KEY);
                            }
                            if (selectionProvider.selected != null) {
                                this.handleSelected(selectionProvider.selected);
                            } else if (read > 0) {
                                sslConnection.getSourceChannel().suspendReads();
                                fallback.handleEvent((Channel)sslConnection);
                                return;
                            }
                        }
                        catch (IOException e) {
                            failedListener.failed(e);
                        }
                    }
                }

                protected void handleSelected(String selected) {
                    if (selected.isEmpty()) {
                        connection.getSourceChannel().suspendReads();
                        fallback.handleEvent((Channel)connection);
                        return;
                    }
                    ALPNClientSelector.ALPNProtocol details = (ALPNClientSelector.ALPNProtocol)protocolMap.get(selected);
                    if (details == null) {
                        connection.getSourceChannel().suspendReads();
                        fallback.handleEvent((Channel)connection);
                        return;
                    }
                    connection.getSourceChannel().suspendReads();
                    details.getSelected().handleEvent((Channel)connection);
                }
            });
            sslConnection.getSourceChannel().resumeReads();
        }
        catch (IOException e) {
            failedListener.failed(e);
        }
        catch (Throwable e) {
            failedListener.failed(new IOException(e));
        }
    }

    @Override
    public boolean isEnabled() {
        return ALPN_PUT_METHOD != null;
    }

    static {
        Method npnPutMethod;
        PROTOCOL_KEY = JettyALPNClientProvider.class.getName() + ".protocol";
        try {
            Class<?> npnClass = Class.forName("org.eclipse.jetty.alpn.ALPN", false, JettyALPNClientProvider.class.getClassLoader());
            npnPutMethod = npnClass.getDeclaredMethod("put", SSLEngine.class, Class.forName("org.eclipse.jetty.alpn.ALPN$Provider", false, JettyALPNClientProvider.class.getClassLoader()));
        }
        catch (Exception e) {
            UndertowLogger.CLIENT_LOGGER.jettyALPNNotFound("HTTP2");
            npnPutMethod = null;
        }
        ALPN_PUT_METHOD = npnPutMethod;
    }

    private static class ALPNSelectionProvider
    implements ALPN.ClientProvider {
        final List<String> protocols;
        private String selected;
        private final SSLEngine sslEngine;

        private ALPNSelectionProvider(List<String> protocols, SSLEngine sslEngine) {
            this.protocols = protocols;
            this.sslEngine = sslEngine;
        }

        public boolean supports() {
            return true;
        }

        public List<String> protocols() {
            return this.protocols;
        }

        public void unsupported() {
            ALPN.remove((SSLEngine)this.sslEngine);
            this.selected = "";
        }

        public void selected(String s) {
            ALPN.remove((SSLEngine)this.sslEngine);
            this.selected = s;
            this.sslEngine.getHandshakeSession().putValue(PROTOCOL_KEY, this.selected);
        }
    }
}

