/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.GSSAPIServerSubjectFactory;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.impl.GSSAPIAuthenticationMechanism;
import io.undertow.server.security.AuthenticationTestBase;
import io.undertow.server.security.KerberosKDCUtil;
import io.undertow.testutils.AjpIgnore;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore(apacheOnly=true, value="SPNEGO requires a single connection to the server, and apache cannot guarantee that")
public class SpnegoAuthenticationTestCase
extends AuthenticationTestBase {
    private static Oid SPNEGO;

    @Override
    protected List<AuthenticationMechanism> getTestMechanisms() {
        GSSAPIAuthenticationMechanism mechanism = new GSSAPIAuthenticationMechanism((GSSAPIServerSubjectFactory)new SubjectFactory());
        return Collections.singletonList(mechanism);
    }

    @BeforeClass
    public static void startServers() throws Exception {
        KerberosKDCUtil.startServer();
        SPNEGO = new Oid("1.3.6.1.5.5.2");
    }

    @AfterClass
    public static void stopServers() {
    }

    @Test
    public void testSpnegoSuccess() throws Exception {
        final TestHttpClient client = new TestHttpClient();
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
        Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
        String header = SpnegoAuthenticationTestCase.getAuthHeader(Headers.NEGOTIATE, values);
        Assert.assertEquals((Object)Headers.NEGOTIATE.toString(), (Object)header);
        HttpClientUtils.readResponse(result);
        Subject clientSubject = KerberosKDCUtil.login("jduke", "theduke".toCharArray());
        Subject.doAs(clientSubject, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                GSSManager gssManager = GSSManager.getInstance();
                GSSName serverName = gssManager.createName("HTTP/" + DefaultServer.getDefaultServerAddress().getHostString(), null);
                GSSContext context = gssManager.createContext(serverName, SPNEGO, null, 0);
                byte[] token = new byte[]{};
                boolean gotOur200 = false;
                while (!context.isEstablished()) {
                    if ((token = context.initSecContext(token, 0, token.length)) == null || token.length <= 0) continue;
                    HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL());
                    get.addHeader(Headers.AUTHORIZATION.toString(), Headers.NEGOTIATE + " " + FlexBase64.encodeString((byte[])token, (boolean)false));
                    HttpResponse result = client.execute((HttpUriRequest)get);
                    Header[] headers = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
                    if (headers.length > 0) {
                        String header = AuthenticationTestBase.getAuthHeader(Headers.NEGOTIATE, headers);
                        byte[] headerBytes = header.getBytes("UTF-8");
                        token = FlexBase64.decode((byte[])headerBytes, (int)(Headers.NEGOTIATE.toString().length() + 1), (int)headerBytes.length).array();
                    }
                    if (result.getStatusLine().getStatusCode() == 200) {
                        Header[] values = result.getHeaders("ProcessedBy");
                        Assert.assertEquals((long)1L, (long)values.length);
                        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
                        HttpClientUtils.readResponse(result);
                        AuthenticationTestBase.assertSingleNotificationType(SecurityNotification.EventType.AUTHENTICATED);
                        gotOur200 = true;
                        continue;
                    }
                    if (result.getStatusLine().getStatusCode() == 401) {
                        Assert.assertTrue((String)"We did get a header.", (headers.length > 0 ? 1 : 0) != 0);
                        HttpClientUtils.readResponse(result);
                        continue;
                    }
                    Assert.fail((String)String.format("Unexpected status code %d", result.getStatusLine().getStatusCode()));
                }
                Assert.assertTrue((boolean)gotOur200);
                Assert.assertTrue((boolean)context.isEstablished());
                return null;
            }
        });
    }

    private class SubjectFactory
    implements GSSAPIServerSubjectFactory {
        private SubjectFactory() {
        }

        public Subject getSubjectForHost(String hostName) throws GeneralSecurityException {
            return KerberosKDCUtil.login("HTTP/" + hostName, "servicepwd".toCharArray());
        }
    }
}

