/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.protocol.http2.Http2ReceiveListener;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import io.undertow.util.Protocols;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class Http2UpgradeHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Set<String> upgradeStrings;

    public Http2UpgradeHandler(HttpHandler next) {
        this.next = next;
        this.upgradeStrings = Collections.singleton("h2c");
    }

    public Http2UpgradeHandler(HttpHandler next, String ... upgradeStrings) {
        this.next = next;
        this.upgradeStrings = new HashSet<String>(Arrays.asList(upgradeStrings));
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String settings;
        final String upgrade = exchange.getRequestHeaders().getFirst(Headers.UPGRADE);
        if (upgrade != null && this.upgradeStrings.contains(upgrade) && (settings = exchange.getRequestHeaders().getFirst("HTTP2-Settings")) != null) {
            final ByteBuffer settingsFrame = FlexBase64.decodeURL(settings);
            exchange.getResponseHeaders().put(Headers.UPGRADE, upgrade);
            exchange.upgradeChannel(new HttpUpgradeListener(){

                @Override
                public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                    OptionMap undertowOptions = exchange.getConnection().getUndertowOptions();
                    Http2Channel channel = new Http2Channel(streamConnection, upgrade, exchange.getConnection().getByteBufferPool(), null, false, true, true, settingsFrame, undertowOptions);
                    Http2ReceiveListener receiveListener = new Http2ReceiveListener(new HttpHandler(){

                        @Override
                        public void handleRequest(HttpServerExchange exchange) throws Exception {
                            if (exchange.getRequestHeaders().contains("X-HTTP2-connect-only")) {
                                exchange.endExchange();
                                return;
                            }
                            exchange.setProtocol(Protocols.HTTP_2_0);
                            Http2UpgradeHandler.this.next.handleRequest(exchange);
                        }
                    }, undertowOptions, exchange.getConnection().getBufferSize(), null);
                    channel.getReceiveSetter().set((ChannelListener)receiveListener);
                    receiveListener.handleInitialRequest(exchange, channel);
                    channel.resumeReceives();
                }
            });
            return;
        }
        this.next.handleRequest(exchange);
    }
}

