/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.AbstractLoadBalancingProxyTestCase;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.ssl.XnioSsl;

@RunWith(value=DefaultServer.class)
public class LoadBalancingProxyHTTP2TestCase
extends AbstractLoadBalancingProxyTestCase {
    @BeforeClass
    public static void setup() throws URISyntaxException {
        SessionCookieConfig sessionConfig = new SessionCookieConfig();
        int port = DefaultServer.getHostPort("default");
        final HttpHandler handler1 = LoadBalancingProxyHTTP2TestCase.getRootHandler("s1", "server1");
        server1 = Undertow.builder().addHttpsListener(port + 1, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!(exchange.getConnection() instanceof Http2ServerConnection)) {
                    throw new RuntimeException("Not HTTP2");
                }
                exchange.getResponseHeaders().add(new HttpString("X-Custom-Header"), "foo");
                System.out.println(exchange.getRequestHeaders());
                handler1.handleRequest(exchange);
            }
        }).build();
        final HttpHandler handler2 = LoadBalancingProxyHTTP2TestCase.getRootHandler("s2", "server2");
        server2 = Undertow.builder().addHttpsListener(port + 2, DefaultServer.getHostAddress("default"), DefaultServer.getServerSslContext()).setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).setHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (!(exchange.getConnection() instanceof Http2ServerConnection)) {
                    throw new RuntimeException("Not HTTP2");
                }
                exchange.getResponseHeaders().add(new HttpString("X-Custom-Header"), "foo");
                System.out.println(exchange.getRequestHeaders());
                handler2.handleRequest(exchange);
            }
        }).build();
        server1.start();
        server2.start();
        UndertowXnioSsl ssl = new UndertowXnioSsl(DefaultServer.getWorker().getXnio(), OptionMap.EMPTY, (ByteBufferPool)DefaultServer.SSL_BUFFER_POOL, DefaultServer.createClientSslContext());
        DefaultServer.setRootHandler((HttpHandler)new ProxyHandler((ProxyClient)new LoadBalancingProxyClient().setConnectionsPerThread(1).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 1, null, null, null), "s1", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)).addHost(new URI("https", null, DefaultServer.getHostAddress("default"), port + 2, null, null, null), "s2", (XnioSsl)ssl, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)true)), 10000, (HttpHandler)ResponseCodeHandler.HANDLE_404));
    }

    @Before
    public void requireAlpn() {
        DefaultServer.assumeAlpnEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadersAreLowercase() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/name");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse(result);
            Header header = result.getFirstHeader("x-custom-header");
            Assert.assertEquals((Object)"x-custom-header", (Object)header.getName());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

