/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.sse;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.server.handlers.sse.ServerSentEventHandler;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.IoUtils;
import org.xnio.XnioIoThread;

@RunWith(value=DefaultServer.class)
public class ServerSentEventTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSE() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            DefaultServer.setRootHandler((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

                public void connected(ServerSentEventConnection connection, String lastEventId) {
                    connection.send("msg 1", new ServerSentEventConnection.EventCallback(){

                        public void done(ServerSentEventConnection connection, String data, String event, String id) {
                            connection.send("msg\n2", new ServerSentEventConnection.EventCallback(){

                                public void done(ServerSentEventConnection connection, String data, String event, String id) {
                                    connection.shutdown();
                                }

                                public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                                    e.printStackTrace();
                                    IoUtils.safeClose((Closeable)connection);
                                }
                            });
                        }

                        public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                            e.printStackTrace();
                            IoUtils.safeClose((Closeable)connection);
                        }
                    });
                }
            }));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)"data:msg 1\n\ndata:msg\ndata:2\n\n", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProgressiveSSEWithCompression() throws IOException {
        final AtomicReference connectionReference = new AtomicReference();
        DecompressingHttpClient client = new DecompressingHttpClient((HttpClient)new TestHttpClient());
        try {
            DefaultServer.setRootHandler((HttpHandler)new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(), 50)).setNext((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

                public void connected(ServerSentEventConnection connection, String lastEventId) {
                    connectionReference.set(connection);
                    connection.send("msg 1", new ServerSentEventConnection.EventCallback(){

                        public void done(ServerSentEventConnection connection, String data, String event, String id) {
                        }

                        public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                            e.printStackTrace();
                            IoUtils.safeClose((Closeable)connection);
                        }
                    });
                }
            })));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            InputStream stream = result.getEntity().getContent();
            this.assertData(stream, "data:msg 1\n\n");
            ((ServerSentEventConnection)connectionReference.get()).send("msg 2");
            this.assertData(stream, "data:msg 2\n\n");
            ((ServerSentEventConnection)connectionReference.get()).close();
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void assertData(InputStream stream, String data) throws IOException {
        byte[] d = data.getBytes(StandardCharsets.US_ASCII);
        int index = 0;
        byte[] buf = new byte[100];
        while (index < d.length) {
            int rem;
            int r = stream.read(buf);
            if (r == -1) {
                Assert.fail((String)("unexpected end of stream at index " + index));
            }
            if (r > (rem = d.length - index)) {
                Assert.fail((String)("Read too much data index: " + index + " expected: " + data + " read: " + new String(buf, 0, r)));
            }
            for (int i = 0; i < r; ++i) {
                Assert.assertEquals((String)("Comparison failed index: " + index + " expected: " + data + " read: " + new String(buf, 0, r)), (long)d[index++], (long)buf[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeMessage() throws IOException {
        TestHttpClient client = new TestHttpClient();
        final StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            sb.append("hello world ");
        }
        try {
            DefaultServer.setRootHandler((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

                public void connected(ServerSentEventConnection connection, String lastEventId) {
                    connection.send(sb.toString(), new ServerSentEventConnection.EventCallback(){

                        public void done(ServerSentEventConnection connection, String data, String event, String id) {
                            connection.shutdown();
                        }

                        public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                            e.printStackTrace();
                            IoUtils.safeClose((Closeable)connection);
                        }
                    });
                }
            }));
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertEquals((Object)("data:" + sb.toString() + "\n\n"), (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testConnectionFail() throws IOException, InterruptedException {
        Socket socket = new Socket(DefaultServer.getHostAddress("default"), DefaultServer.getHostPort("default"));
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch connected = new CountDownLatch(1);
        DefaultServer.setRootHandler((HttpHandler)new ServerSentEventHandler(new ServerSentEventConnectionCallback(){

            public void connected(final ServerSentEventConnection connection, String lastEventId) {
                final XnioIoThread thread = (XnioIoThread)Thread.currentThread();
                connected.countDown();
                thread.execute(new Runnable(){

                    @Override
                    public void run() {
                        connection.send("hello", new ServerSentEventConnection.EventCallback(){

                            public void done(ServerSentEventConnection connection, String data, String event, String id) {
                            }

                            public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e) {
                                latch.countDown();
                            }
                        });
                        if (latch.getCount() > 0L) {
                            thread.executeAfter((Runnable)this, 100L, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        }));
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        out.write("GET / HTTP/1.1\r\n\r\n".getBytes());
        out.flush();
        if (!connected.await(10L, TimeUnit.SECONDS)) {
            Assert.fail();
        }
        out.close();
        in.close();
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            Assert.fail();
        }
    }
}

