/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.JDK8HackALPNClientProvider;
import io.undertow.client.JDK9ALPNClientProvider;
import io.undertow.client.JettyALPNClientProvider;
import io.undertow.protocols.ssl.ALPNHackSSLEngine;
import io.undertow.util.ALPN;
import org.xnio.ChannelListener;
import org.xnio.ssl.SslConnection;

public class ALPNClientSelector {
    private static final ClientSelector SELECTOR = ALPN.JDK_9_ALPN_METHODS != null ? new JDK9ALPNClientProvider() : (ALPNHackSSLEngine.ENABLED ? new JDK8HackALPNClientProvider() : new JettyALPNClientProvider());

    private ALPNClientSelector() {
    }

    public static void runAlpn(SslConnection connection, ChannelListener<SslConnection> fallback, ClientCallback<ClientConnection> failedListener, ALPNProtocol ... details) {
        SELECTOR.runAlpn(connection, fallback, failedListener, details);
    }

    public static boolean isEnabled() {
        return SELECTOR.isEnabled();
    }

    static interface ClientSelector {
        public void runAlpn(SslConnection var1, ChannelListener<SslConnection> var2, ClientCallback<ClientConnection> var3, ALPNProtocol ... var4);

        public boolean isEnabled();
    }

    public static class ALPNProtocol {
        private final ChannelListener<SslConnection> selected;
        private final String protocol;

        public ALPNProtocol(ChannelListener<SslConnection> selected, String protocol) {
            this.selected = selected;
            this.protocol = protocol;
        }

        public ChannelListener<SslConnection> getSelected() {
            return this.selected;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

