/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.proxy;

import io.undertow.server.protocol.proxy.ProxyProtocolReadListener;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import org.junit.Assert;
import org.junit.Test;

public class ProxyProtocolReadListenerAddressParsingTestCase {
    @Test
    public void testIpV4Address() throws IOException {
        InetAddress res = ProxyProtocolReadListener.parseAddress((String)"1.123.255.2", (String)"TCP");
        Assert.assertTrue((boolean)(res instanceof Inet4Address));
        Assert.assertEquals((long)1L, (long)res.getAddress()[0]);
        Assert.assertEquals((long)123L, (long)res.getAddress()[1]);
        Assert.assertEquals((long)-1L, (long)res.getAddress()[2]);
        Assert.assertEquals((long)2L, (long)res.getAddress()[3]);
        Assert.assertEquals((Object)"/1.123.255.2", (Object)res.toString());
        res = ProxyProtocolReadListener.parseAddress((String)"127.0.0.1", (String)"TCP");
        Assert.assertTrue((boolean)(res instanceof Inet4Address));
        Assert.assertEquals((long)127L, (long)res.getAddress()[0]);
        Assert.assertEquals((long)0L, (long)res.getAddress()[1]);
        Assert.assertEquals((long)0L, (long)res.getAddress()[2]);
        Assert.assertEquals((long)1L, (long)res.getAddress()[3]);
        Assert.assertEquals((Object)"/127.0.0.1", (Object)res.toString());
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressWithLeadingZero() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"01.123.255.2", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressToSmall() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"01.123.255", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressToLarge() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"01.123.255.1.1", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressMultipleDots() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"1..255.2", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressMultipleDots2() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"1..3.255.2", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4Hostname() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"localhost", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4Hostname2() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"ff", (String)"TCP");
    }

    @Test(expected=IOException.class)
    public void testIpV4AddressStartsWithDot() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)".1.123.255.2", (String)"TCP");
    }

    @Test
    public void testIpv6Address() throws IOException {
        int i;
        String addressString = "2001:1db8:100:3:6:ff00:42:8329";
        InetAddress res = ProxyProtocolReadListener.parseAddress((String)addressString, (String)"TCP_6");
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        int[] parts = new int[]{8193, 7608, 256, 3, 6, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)("/" + addressString), (Object)res.toString());
        addressString = "2001:1db8:100::6:ff00:42:8329";
        res = ProxyProtocolReadListener.parseAddress((String)addressString, (String)"TCP_6");
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{8193, 7608, 256, 0, 6, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/2001:1db8:100:0:6:ff00:42:8329", (Object)res.toString());
        addressString = "2001:1db8:100::ff00:42:8329";
        res = ProxyProtocolReadListener.parseAddress((String)addressString, (String)"TCP_6");
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{8193, 7608, 256, 0, 0, 65280, 66, 33577};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/2001:1db8:100:0:0:ff00:42:8329", (Object)res.toString());
        addressString = "::1";
        res = ProxyProtocolReadListener.parseAddress((String)addressString, (String)"TCP_6");
        Assert.assertTrue((boolean)(res instanceof Inet6Address));
        parts = new int[]{0, 0, 0, 0, 0, 0, 0, 1};
        for (i = 0; i < parts.length; ++i) {
            Assert.assertEquals((long)((byte)(parts[i] >> 8)), (long)res.getAddress()[i * 2]);
            Assert.assertEquals((long)((byte)parts[i]), (long)res.getAddress()[i * 2 + 1]);
        }
        Assert.assertEquals((Object)"/0:0:0:0:0:0:0:1", (Object)res.toString());
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressWithLeadingZero() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"2001:1db8:100:03:6:ff00:42:8329", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressToSmall() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"2001:1db8:3:6:ff00:42:8329", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressToLarge() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"2001:1db8:100:3:6:7:ff00:42:8329", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressMultipleColons() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"2001:1db8:100::3:6:ff00:42:8329", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressMultipleColons2() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"2001::100::329", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6Hostname() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"localhost", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6Hostname2() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)"ff", (String)"TCP_6");
    }

    @Test(expected=IOException.class)
    public void testIpV6AddressStartsWithColon() throws IOException {
        ProxyProtocolReadListener.parseAddress((String)":2001:1db8:100:3:6:ff00:42:8329", (String)"TCP_6");
    }
}

