/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.WebSocketFrameCorruptedException;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketHandshakeException;
import io.undertow.websockets.core.WebSocketInvalidCloseCodeException;
import io.undertow.websockets.core.WebSocketMessages;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.DataFormatException;

public class WebSocketMessages_$bundle
implements WebSocketMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final WebSocketMessages_$bundle INSTANCE = new WebSocketMessages_$bundle();
    private static final String channelClosed = "UT002002: Channel is closed";
    private static final String invalidTextFrameEncoding = "UT002003: Text frame contains non UTF-8 data";
    private static final String fragmentedControlFrame = "UT002005: Fragmented control frame";
    private static final String toBigControlFrame = "UT002006: Control frame with payload length > 125 octets";
    private static final String reservedOpCodeInControlFrame = "UT002007: Control frame using reserved opcode = %s";
    private static final String controlFrameWithPayloadLen1 = "UT002008: Received close control frame with payload len 1";
    private static final String reservedOpCodeInDataFrame = "UT002009: Data frame using reserved opcode = %s";
    private static final String continuationFrameOutsideFragmented = "UT002010: Received continuation data frame outside fragmented message";
    private static final String nonContinuationFrameInsideFragmented = "UT002011: Received non-continuation data frame while inside fragmented message";
    private static final String unsupportedOpCode = "UT002013: Cannot decode web socket frame with opcode: %s";
    private static final String unsupportedFrameType = "UT002014: WebSocketFrameType %s is not supported by this WebSocketChannel\"";
    private static final String extensionsNotAllowed = "UT002015: Extensions not allowed but received rsv of %s";
    private static final String unsupportedProtocol = "UT002016: Could not find supported protocol in request list %s. Supported protocols are %s";
    private static final String invalidPayloadLengthForPing = "UT002019: Invalid payload for PING (payload length must be <= 125, was %s)";
    private static final String extensionsNotSupported = "UT002023: Extensions not supported";
    private static final String invalidCloseFrameStatusCode = "UT002026: Invalid close frame status code: %s";
    private static final String streamIsBroken = "UT002027: Could not send data, as the underlying web socket connection has been broken";
    private static final String frameNotMasked = "UT002034: Web socket frame was not masked";
    private static final String noWebSocketUpgradeHeader = "UT002035: The response did not contain an 'Upgrade: websocket' header";
    private static final String noWebSocketConnectionHeader = "UT002036: The response did not contain a 'Connection: upgrade' header";
    private static final String webSocketAcceptKeyMismatch = "UT002037: Sec-WebSocket-Accept mismatch, expecting %s, received %s";
    private static final String messageToBig = "UT002040: Message exceeded max message size of %s";
    private static final String badCompressedPayload = "UT002044: Compressed message payload is corrupted";
    private static final String unableToSendOnNewChannel = "UT002045: Unable to send on newly created channel!";

    protected WebSocketMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected String channelClosed$str() {
        return channelClosed;
    }

    @Override
    public final IOException channelClosed() {
        IOException result = new IOException(String.format(this.channelClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTextFrameEncoding$str() {
        return invalidTextFrameEncoding;
    }

    @Override
    public final UnsupportedEncodingException invalidTextFrameEncoding() {
        UnsupportedEncodingException result = new UnsupportedEncodingException(String.format(this.invalidTextFrameEncoding$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fragmentedControlFrame$str() {
        return fragmentedControlFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException fragmentedControlFrame() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.fragmentedControlFrame$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String toBigControlFrame$str() {
        return toBigControlFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException toBigControlFrame() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.toBigControlFrame$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String reservedOpCodeInControlFrame$str() {
        return reservedOpCodeInControlFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException reservedOpCodeInControlFrame(int opCode) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.reservedOpCodeInControlFrame$str(), opCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String controlFrameWithPayloadLen1$str() {
        return controlFrameWithPayloadLen1;
    }

    @Override
    public final WebSocketFrameCorruptedException controlFrameWithPayloadLen1() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.controlFrameWithPayloadLen1$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String reservedOpCodeInDataFrame$str() {
        return reservedOpCodeInDataFrame;
    }

    @Override
    public final WebSocketFrameCorruptedException reservedOpCodeInDataFrame(int opCode) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.reservedOpCodeInDataFrame$str(), opCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String continuationFrameOutsideFragmented$str() {
        return continuationFrameOutsideFragmented;
    }

    @Override
    public final WebSocketFrameCorruptedException continuationFrameOutsideFragmented() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.continuationFrameOutsideFragmented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonContinuationFrameInsideFragmented$str() {
        return nonContinuationFrameInsideFragmented;
    }

    @Override
    public final WebSocketFrameCorruptedException nonContinuationFrameInsideFragmented() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.nonContinuationFrameInsideFragmented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedOpCode$str() {
        return unsupportedOpCode;
    }

    @Override
    public final IllegalStateException unsupportedOpCode(int opCode) {
        IllegalStateException result = new IllegalStateException(String.format(this.unsupportedOpCode$str(), opCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedFrameType$str() {
        return unsupportedFrameType;
    }

    @Override
    public final IllegalArgumentException unsupportedFrameType(WebSocketFrameType type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unsupportedFrameType$str(), new Object[]{type}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionsNotAllowed$str() {
        return extensionsNotAllowed;
    }

    @Override
    public final WebSocketFrameCorruptedException extensionsNotAllowed(int rsv) {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.extensionsNotAllowed$str(), rsv));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedProtocol$str() {
        return unsupportedProtocol;
    }

    @Override
    public final WebSocketHandshakeException unsupportedProtocol(String requestedSubprotocols, Collection<String> subprotocols) {
        WebSocketHandshakeException result = new WebSocketHandshakeException(String.format(this.unsupportedProtocol$str(), requestedSubprotocols, subprotocols));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPayloadLengthForPing$str() {
        return invalidPayloadLengthForPing;
    }

    @Override
    public final IllegalArgumentException invalidPayloadLengthForPing(long payloadLength) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidPayloadLengthForPing$str(), payloadLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionsNotSupported$str() {
        return extensionsNotSupported;
    }

    @Override
    public final UnsupportedOperationException extensionsNotSupported() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.extensionsNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCloseFrameStatusCode$str() {
        return invalidCloseFrameStatusCode;
    }

    @Override
    public final WebSocketInvalidCloseCodeException invalidCloseFrameStatusCode(int statusCode) {
        WebSocketInvalidCloseCodeException result = new WebSocketInvalidCloseCodeException(String.format(this.invalidCloseFrameStatusCode$str(), statusCode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String streamIsBroken$str() {
        return streamIsBroken;
    }

    @Override
    public final IOException streamIsBroken() {
        IOException result = new IOException(String.format(this.streamIsBroken$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String frameNotMasked$str() {
        return frameNotMasked;
    }

    @Override
    public final WebSocketFrameCorruptedException frameNotMasked() {
        WebSocketFrameCorruptedException result = new WebSocketFrameCorruptedException(String.format(this.frameNotMasked$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noWebSocketUpgradeHeader$str() {
        return noWebSocketUpgradeHeader;
    }

    @Override
    public final IOException noWebSocketUpgradeHeader() {
        IOException result = new IOException(String.format(this.noWebSocketUpgradeHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noWebSocketConnectionHeader$str() {
        return noWebSocketConnectionHeader;
    }

    @Override
    public final IOException noWebSocketConnectionHeader() {
        IOException result = new IOException(String.format(this.noWebSocketConnectionHeader$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String webSocketAcceptKeyMismatch$str() {
        return webSocketAcceptKeyMismatch;
    }

    @Override
    public final IOException webSocketAcceptKeyMismatch(String dKey, String acceptKey) {
        IOException result = new IOException(String.format(this.webSocketAcceptKeyMismatch$str(), dKey, acceptKey));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageToBig$str() {
        return messageToBig;
    }

    @Override
    public final String messageToBig(long maxMessageSize) {
        return String.format(this.messageToBig$str(), maxMessageSize);
    }

    protected String badCompressedPayload$str() {
        return badCompressedPayload;
    }

    @Override
    public final IOException badCompressedPayload(DataFormatException cause) {
        IOException result = new IOException(String.format(this.badCompressedPayload$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendOnNewChannel$str() {
        return unableToSendOnNewChannel;
    }

    @Override
    public final IllegalStateException unableToSendOnNewChannel() {
        IllegalStateException result = new IllegalStateException(String.format(this.unableToSendOnNewChannel$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

