/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.caching;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.Headers;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CacheHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicPathBasedCaching() throws IOException {
        final AtomicInteger responseCount = new AtomicInteger();
        HttpHandler messageHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ResponseCache cache = (ResponseCache)exchange.getAttachment(ResponseCache.ATTACHMENT_KEY);
                if (!cache.tryServeResponse()) {
                    String data = "Response " + responseCount.incrementAndGet();
                    exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, data.length() + "");
                    exchange.getResponseSender().send(data);
                }
            }
        };
        CacheHandler cacheHandler = new CacheHandler(new DirectBufferCache(100, 10, 1000), messageHandler);
        DefaultServer.setRootHandler((HttpHandler)cacheHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            for (int i = 1; i <= 5; ++i) {
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertEquals((Object)("Response " + i), (Object)HttpClientUtils.readResponse(result));
            }
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 5", (Object)HttpClientUtils.readResponse(result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 5", (Object)HttpClientUtils.readResponse(result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 5", (Object)HttpClientUtils.readResponse(result));
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path2");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 6", (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

