/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.security;

import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.ProxyIgnore;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FileUtils;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SimpleConfidentialRedirectTestCase {
    @BeforeClass
    public static void setup() throws IOException {
        DefaultServer.startSSLServer();
        HttpHandler current = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"uri"), exchange.getRequestURI());
                exchange.endExchange();
            }
        };
        current = new SinglePortConfidentialityHandler(current, DefaultServer.getHostSSLPort("default"));
        DefaultServer.setRootHandler(current);
    }

    @AfterClass
    public static void stop() throws IOException {
        DefaultServer.stopSSLServer();
    }

    @Test
    public void simpleRedirectTestCase() throws IOException, GeneralSecurityException {
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            this.sendRequest(client, "/foo");
            this.sendRequest(client, "/foo+bar");
            this.sendRequest(client, "/foo+bar;aa");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @ProxyIgnore
    public void testRedirectWithFullURLInPath() throws IOException {
        DefaultServer.isProxy();
        try (Socket socket = new Socket(DefaultServer.getHostAddress(), DefaultServer.getHostPort());){
            socket.getOutputStream().write(("GET " + DefaultServer.getDefaultServerURL() + "/foo HTTP/1.0\r\n\r\n").getBytes(StandardCharsets.UTF_8));
            String result = FileUtils.readFile((InputStream)socket.getInputStream());
            Assert.assertTrue((boolean)result.contains("Location: " + DefaultServer.getDefaultServerSSLAddress() + "/foo"));
        }
    }

    private void sendRequest(TestHttpClient client, String uri) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + uri);
        CloseableHttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"https", (Object)result.getFirstHeader("scheme").getValue());
        Assert.assertEquals((Object)uri, (Object)result.getFirstHeader("uri").getValue());
        HttpClientUtils.readResponse((HttpResponse)result);
    }
}

