/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.junit.Assert;
import org.junit.Test;
import org.xnio.Option;
import org.xnio.OptionMap;

public class SimpleParserTestCase {
    private final ParseState parseState = new ParseState();

    @Test
    public void testEncodedSlashDisallowed() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath%2FotherPath HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath%2FotherPath", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/somepath%2FotherPath", (Object)result.getRequestPath());
    }

    @Test
    public void testEncodedSlashAllowed() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath%2fotherPath HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath/otherPath", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/somepath%2fotherPath", (Object)result.getRequestURI());
    }

    @Test
    public void testColonSlashInURL() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /a/http://myurl.com/b/c HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/a/http://myurl.com/b/c", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/a/http://myurl.com/b/c", (Object)result.getRequestURI());
    }

    @Test
    public void testColonSlashInFullURL() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET http://foo.com/a/http://myurl.com/b/c HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/a/http://myurl.com/b/c", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"http://foo.com/a/http://myurl.com/b/c", (Object)result.getRequestURI());
    }

    @Test
    public void testPathParameters() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath;p1 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/somepath;p1", (Object)result.getRequestURI());
        Assert.assertTrue((boolean)result.getPathParameters().containsKey("p1"));
        in = "GET /somepath;p1=v1&p2=v2?q1=v3 HTTP/1.1\r\n\r\n".getBytes();
        context = new ParseState();
        result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/somepath;p1=v1&p2=v2", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"q1=v3", (Object)result.getQueryString());
        Assert.assertEquals((Object)"v1", ((Deque)result.getPathParameters().get("p1")).getFirst());
        Assert.assertEquals((Object)"v2", ((Deque)result.getPathParameters().get("p2")).getFirst());
        Assert.assertEquals((Object)"v3", ((Deque)result.getQueryParameters().get("q1")).getFirst());
    }

    @Test
    public void testFullUrlRootPath() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET http://myurl.com HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.create((Option)UndertowOptions.ALLOW_ENCODED_SLASH, (Object)true)).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"http://myurl.com", (Object)result.getRequestURI());
    }

    @Test
    public void testSimpleRequest() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testSimpleRequestWithHeaderCaching() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: foo\r\n\r\n".getBytes();
        this.runTest(in, "foo");
        in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader:       foo\r\n\r\n".getBytes();
        this.runTest(in, "foo");
        in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader:      some value\r\n\r\n".getBytes();
        this.runTest(in);
        in = "GET /somepath HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some value\r\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testCarriageReturnLineEnds() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\rHost:   www.somehost.net\rOtherHeader: some\r    value\r\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testLineFeedsLineEnds() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /somepath HTTP/1.1\nHost:   www.somehost.net\nOtherHeader: some\n    value\n\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testTabWhitespace() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET\t/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        this.runTest(in);
    }

    @Test
    public void testCanonicalPath() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET\thttp://www.somehost.net/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertEquals((Object)"/somepath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/somepath", (Object)result.getRequestURI());
    }

    @Test
    public void testNoHeaders() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET\t/aa\tHTTP/1.1\n\n\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertTrue((boolean)context.isComplete());
        Assert.assertEquals((Object)"/aa", (Object)result.getRelativePath());
    }

    @Test
    public void testQueryParams() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET\thttp://www.somehost.net/somepath?a=b&b=c&d&e&f=\tHTTP/1.1\nHost: \t www.somehost.net\nOtherHeader:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertEquals((Object)"/somepath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/somepath", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"a=b&b=c&d&e&f=", (Object)result.getQueryString());
        Assert.assertEquals((Object)"b", ((Deque)result.getQueryParameters().get("a")).getFirst());
        Assert.assertEquals((Object)"c", ((Deque)result.getQueryParameters().get("b")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("d")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("e")).getFirst());
        Assert.assertEquals((Object)"", ((Deque)result.getQueryParameters().get("f")).getFirst());
    }

    @Test
    public void testSameHttpStringReturned() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET\thttp://www.somehost.net/somepath\tHTTP/1.1\nHost: \t www.somehost.net\nAccept-Charset:\tsome\n \t  value\n\r\n".getBytes();
        ParseState context1 = new ParseState();
        HttpServerExchange result1 = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context1, result1);
        ParseState context2 = new ParseState();
        HttpServerExchange result2 = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context2, result2);
        Assert.assertSame((Object)result1.getProtocol(), (Object)result2.getProtocol());
        Assert.assertSame((Object)result1.getRequestMethod(), (Object)result2.getRequestMethod());
        for (HttpString header : result1.getRequestHeaders().getHeaderNames()) {
            boolean found = false;
            for (HttpString header2 : result1.getRequestHeaders().getHeaderNames()) {
                if (header != header2) continue;
                found = true;
                break;
            }
            if (header.equals(Headers.HOST)) {
                Assert.assertSame((Object)Headers.HOST, (Object)header);
            }
            Assert.assertTrue((String)("Could not found header " + header), (boolean)found);
        }
    }

    @Test
    public void testEmptyQueryParams() throws HttpRequestParser.BadRequestException {
        byte[] in = "GET /clusterbench/requestinfo//?;?=44&test=OK;devil=3&&&&&&&&&&&&&&&&&&&&&&&&&&&&777=666 HTTP/1.1\r\n\r\n".getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/clusterbench/requestinfo//", (Object)result.getRequestURI());
        Assert.assertEquals((Object)"/clusterbench/requestinfo//", (Object)result.getRequestPath());
        Assert.assertEquals((long)3L, (long)result.getQueryParameters().size());
        Assert.assertEquals((Object)"OK;devil=3", ((Deque)result.getQueryParameters().get("test")).getFirst());
        Assert.assertEquals((Object)"666", ((Deque)result.getQueryParameters().get("777")).getFirst());
        Assert.assertEquals((Object)"44", ((Deque)result.getQueryParameters().get(";?")).getFirst());
    }

    @Test
    public void testNonEncodedAsciiCharacters() throws UnsupportedEncodingException, HttpRequestParser.BadRequestException {
        byte[] in = "GET /b\u00c3\u00a5r HTTP/1.1\r\n\r\n".getBytes("ISO-8859-1");
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), context, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/b\u00e5r", (Object)result.getRequestPath());
        Assert.assertEquals((Object)"/b\u00c3\u00a5r", (Object)result.getRequestURI());
    }

    private void runTest(byte[] in) throws HttpRequestParser.BadRequestException {
        this.runTest(in, "some value");
    }

    private void runTest(byte[] in, String lastHeader) throws HttpRequestParser.BadRequestException {
        this.parseState.reset();
        HttpServerExchange result = new HttpServerExchange(null);
        HttpRequestParser.instance((OptionMap)OptionMap.EMPTY).handle(ByteBuffer.wrap(in), this.parseState, result);
        Assert.assertSame((Object)Methods.GET, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/somepath", (Object)result.getRequestURI());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertEquals((long)2L, (long)result.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((Object)"www.somehost.net", (Object)result.getRequestHeaders().getFirst(new HttpString("Host")));
        Assert.assertEquals((Object)lastHeader, (Object)result.getRequestHeaders().getFirst(new HttpString("OtherHeader")));
        Assert.assertEquals((long)8L, (long)this.parseState.state);
    }
}

